/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.api.PyDevdTableDataProvider;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterComparisonType;
import com.intellij.scientific.tables.api.FilterExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015H\u0016J4\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010#\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0018\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyTorchTensorArrayProvider;", "Lcom/intellij/scientific/py/tables/api/PyDevdTableDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getType", "()Lcom/intellij/scientific/tables/api/DSTableDataType;", "pydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "getPydevdId", "()Lcom/intellij/scientific/py/tables/api/PyDevdID;", "isFallbackToStaticTableSupported", "", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "id", "Lcom/intellij/scientific/tables/DataId;", "table", "getSortingCommand", "tableVariable", "sortKeys", "", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "composeFilterCommandOneColumn", "columnVariable", "filterExpression", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "getColumnVariableExpressionForFilterCommand", "getSupportedFilterComparisonTypes", "Lcom/intellij/scientific/tables/api/FilterComparisonType;", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyTorchTensorArrayProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTorchTensorArrayProvider.kt\ncom/intellij/scientific/py/tables/providers/PyTorchTensorArrayProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1557#2:71\n1628#2,3:72\n774#2:75\n865#2,2:76\n*S KotlinDebug\n*F\n+ 1 PyTorchTensorArrayProvider.kt\ncom/intellij/scientific/py/tables/providers/PyTorchTensorArrayProvider\n*L\n33#1:71\n33#1:72,3\n63#1:75\n63#1:76,2\n*E\n"})
public final class PyTorchTensorArrayProvider
extends PyDevdTableDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final DSTableDataType type;
    @NotNull
    private final PyDevdID pydevdId;

    public PyTorchTensorArrayProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.type = DSTableDataType.TORCH_TENSOR;
        this.pydevdId = PyDevdID.NUMPY_BASED;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DSTableDataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public PyDevdID getPydevdId() {
        return this.pydevdId;
    }

    public boolean isFallbackToStaticTableSupported() {
        return false;
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String string = "Showing tensors as tables isn't supported for non-executed cells";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId id, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        String string = "Showing tensors as tables isn't supported for non-executed cells";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        RowSorter.SortKey it;
        Collection<String> collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (sortKeys.isEmpty()) {
            return tableVariable;
        }
        Iterable $this$map$iv = sortKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RowSorter.SortKey sortKey = (RowSorter.SortKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf(it.getColumn()));
        }
        $this$map$iv = sortKeys;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RowSorter.SortKey)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getSortOrder() == SortOrder.ASCENDING ? "True" : "False");
        }
        Pair pair2 = TuplesKt.to(collection, (Object)((List)destination$iv$iv));
        List cols = (List)pair2.component1();
        List orders = (List)pair2.component2();
        return "{'data': " + tableVariable + ", 'sort_keys': (" + cols + ", " + orders + ")}";
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        if (filters == null) {
            return tableVariable;
        }
        String filterExpression = this.composeFilterCommand(tableVariable, filters);
        return !StringsKt.isBlank((CharSequence)filterExpression) ? tableVariable + "[" + filterExpression + "]" : tableVariable;
    }

    @Override
    @NotNull
    public String composeFilterCommandOneColumn(@NotNull String columnVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)columnVariable, (String)"columnVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return switch (WhenMappings.$EnumSwitchMapping$0[filterExpression.getCondition().ordinal()]) {
            case 1 -> columnVariable + ".isnan()";
            case 2 -> "~" + columnVariable + ".isnan()";
            case 3 -> "";
            case 4 -> "";
            case 5 -> "";
            case 6 -> "";
            case 7 -> "";
            default -> this.composeFilterCommandOneColumnCommon(columnVariable, filterExpression);
        };
    }

    @Override
    @NotNull
    public String getColumnVariableExpressionForFilterCommand(@NotNull String tableVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return tableVariable + "[:, " + filterExpression.getColumn().getName() + "]";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FilterComparisonType> getSupportedFilterComparisonTypes() {
        void $this$filterTo$iv$iv;
        List<FilterComparisonType> allComparisonTypes = super.getSupportedFilterComparisonTypes();
        Iterable $this$filter$iv = allComparisonTypes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilterComparisonType it = (FilterComparisonType)element$iv$iv;
            boolean bl = false;
            if (!(it != FilterComparisonType.STARTS_WITH && it != FilterComparisonType.ENDS_WITH && it != FilterComparisonType.CONTAINS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterComparisonType.values().length];
            try {
                nArray[FilterComparisonType.IS_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IS_NOT_NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.NOT_IN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.CONTAINS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.STARTS_WITH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.ENDS_WITH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

