/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import java.util.Collections;
import java.util.Map;
import org.apache.thrift.ProcessFunction;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;

public abstract class TBaseProcessor<I>
implements TProcessor {
    private final I iface;
    private final Map<String, ProcessFunction<I, ? extends TBase>> processMap;

    protected TBaseProcessor(I iface, Map<String, ProcessFunction<I, ? extends TBase>> processFunctionMap) {
        this.iface = iface;
        this.processMap = processFunctionMap;
    }

    public Map<String, ProcessFunction<I, ? extends TBase>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public void process(TProtocol in, TProtocol out) throws TException {
        TMessage msg = in.readMessageBegin();
        ProcessFunction<I, TBase> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x2 = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
            x2.write(out);
            out.writeMessageEnd();
            out.getTransport().flush();
        } else {
            fn.process(msg.seqid, in, out, this.iface);
        }
    }
}

