/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfo;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoFactory;
import org.jetbrains.letsPlot.core.commons.enums.EnumInfoImpl;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStat;
import org.jetbrains.letsPlot.core.plot.base.stat.BinStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ;\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014H\u0016J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "binCount", "", "binWidth", "", "xPosKind", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;", "xPos", "method", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "(ILjava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStat$XPosKind;DLorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;)V", "binOptions", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BinStatUtil$BinOptions;", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "Method", "plot-base"})
public final class DotplotStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BinStat.XPosKind xPosKind;
    private final double xPos;
    @NotNull
    private final Method method;
    @NotNull
    private final BinStatUtil.BinOptions binOptions;
    @NotNull
    private static final Method DEF_METHOD = Method.DOTDENSITY;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public DotplotStat(int binCount, @Nullable Double binWidth, @NotNull BinStat.XPosKind xPosKind, double xPos, @NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)((Object)xPosKind), (String)"xPosKind");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        super(DEF_MAPPING);
        this.xPosKind = xPosKind;
        this.xPos = xPos;
        this.method = method;
        this.binOptions = new BinStatUtil.BinOptions(binCount, binWidth);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        return CollectionsKt.listOf(Aes.Companion.getX());
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        ArrayList statX = new ArrayList();
        ArrayList statCount2 = new ArrayList();
        ArrayList statDensity2 = new ArrayList();
        ArrayList statBinWidth = new ArrayList();
        DoubleSpan rangeX = statCtx.overallXRange();
        if (rangeX != null) {
            BinStatUtil.BinsData binsData;
            switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
                case 1: {
                    binsData = BinStatUtil.INSTANCE.computeDotdensityStatSeries(rangeX, data.getNumeric(TransformVar.INSTANCE.getX()), this.binOptions);
                    break;
                }
                case 2: {
                    binsData = BinStatUtil.INSTANCE.computeHistogramStatSeries(data, rangeX, data.getNumeric(TransformVar.INSTANCE.getX()), this.xPosKind, this.xPos, this.binOptions);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            BinStatUtil.BinsData binsData2 = binsData;
            statX.addAll(binsData2.getX$plot_base());
            statCount2.addAll(binsData2.getCount$plot_base());
            statDensity2.addAll(binsData2.getDensity$plot_base());
            statBinWidth.addAll(binsData2.getBinWidth$plot_base());
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), statX).putNumeric(Stats.INSTANCE.getCOUNT(), statCount2).putNumeric(Stats.INSTANCE.getDENSITY(), statDensity2).putNumeric(Stats.INSTANCE.getBIN_WIDTH(), statBinWidth).build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getSTACKSIZE(), (Object)Stats.INSTANCE.getCOUNT()), TuplesKt.to(Aes.Companion.getBINWIDTH(), (Object)Stats.INSTANCE.getBIN_WIDTH())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Companion;", "", "()V", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "DEF_METHOD", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "getDEF_METHOD", "()Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Method getDEF_METHOD() {
            return DEF_METHOD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "", "(Ljava/lang/String;I)V", "HISTODOT", "DOTDENSITY", "Companion", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nDotplotStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method\n+ 2 EnumInfoFactory.kt\norg/jetbrains/letsPlot/core/commons/enums/EnumInfoFactory\n*L\n1#1,82:1\n14#2:83\n*S KotlinDebug\n*F\n+ 1 DotplotStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method\n*L\n61#1:83\n*E\n"})
    public static final class Method
    extends Enum<Method> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final EnumInfo<Method> ENUM_INFO;
        public static final /* enum */ Method HISTODOT;
        public static final /* enum */ Method DOTDENSITY;
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value2) {
            return Enum.valueOf(Method.class, value2);
        }

        @NotNull
        public static EnumEntries<Method> getEntries() {
            return $ENTRIES;
        }

        static {
            HISTODOT = new Method();
            DOTDENSITY = new Method();
            $VALUES = methodArray = new Method[]{Method.HISTODOT, Method.DOTDENSITY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            EnumInfoFactory this_$iv = EnumInfoFactory.INSTANCE;
            boolean $i$f$createEnumInfo = false;
            ENUM_INFO = new EnumInfoImpl((Enum[])Method.values());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method$Companion;", "", "()V", "ENUM_INFO", "Lorg/jetbrains/letsPlot/core/commons/enums/EnumInfo;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DotplotStat$Method;", "safeValueOf", "v", "", "plot-base"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Method safeValueOf(@NotNull String v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Method method = (Method)((Object)ENUM_INFO.safeValueOf(v));
                if (method == null) {
                    throw new IllegalArgumentException("Unsupported method: '" + v + "'\nUse one of: histodot, dotdensity.");
                }
                return method;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.DOTDENSITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.HISTODOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

