/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stylelint;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import org.jetbrains.annotations.NotNull;

public class StylelintState
implements JSNpmLinterState<StylelintState> {
    @NotNull
    private final NodePackage myStylelintPackage;
    @NotNull
    private final NodePackageRef myPackageRef;
    @NotNull
    private final String myConfigFilePath;
    @NotNull
    private final String myFilesPattern;
    private final boolean myRunOnSave;
    static final String FILES_PATTERN_DEFAULT = "**/*.{css}";
    static final String FILES_PATTERN_DEFAULT_WITH_JS = "**/*.{css,js,jsx,ts,tsx}";
    static final boolean RUN_ON_SAVE_DEFAULT = false;

    public StylelintState() {
        this(new NodePackage(""), "", FILES_PATTERN_DEFAULT, false);
    }

    public StylelintState(@NotNull NodePackage stylelintPackage, @NotNull String configFilePath, @NotNull String filesPattern, boolean runOnSave) {
        if (stylelintPackage == null) {
            StylelintState.$$$reportNull$$$0(0);
        }
        if (configFilePath == null) {
            StylelintState.$$$reportNull$$$0(1);
        }
        if (filesPattern == null) {
            StylelintState.$$$reportNull$$$0(2);
        }
        this.myStylelintPackage = stylelintPackage;
        this.myPackageRef = NodePackageRef.create((NodePackage)stylelintPackage);
        this.myConfigFilePath = configFilePath;
        this.myFilesPattern = filesPattern;
        this.myRunOnSave = runOnSave;
    }

    @NotNull
    public NodePackage getStylelintPackage() {
        NodePackage nodePackage = this.myStylelintPackage;
        if (nodePackage == null) {
            StylelintState.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    @NotNull
    public NodePackageRef getNodePackageRef() {
        NodePackageRef nodePackageRef = this.myPackageRef;
        if (nodePackageRef == null) {
            StylelintState.$$$reportNull$$$0(4);
        }
        return nodePackageRef;
    }

    @NotNull
    public String getConfigFilePath() {
        String string = this.myConfigFilePath;
        if (string == null) {
            StylelintState.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFilesPattern() {
        String string = this.myFilesPattern;
        if (string == null) {
            StylelintState.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isRunOnSave() {
        return this.myRunOnSave;
    }

    public StylelintState withLinterPackage(@NotNull NodePackageRef nodePackage) {
        if (nodePackage == null) {
            StylelintState.$$$reportNull$$$0(7);
        }
        NodePackage constantPackage = nodePackage.getConstantPackage();
        assert (constantPackage != null) : this.getClass().getSimpleName() + " does not support non-constant package refs";
        return new StylelintState(constantPackage, this.myConfigFilePath, this.myFilesPattern, this.myRunOnSave);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StylelintState state = (StylelintState)o;
        return this.myStylelintPackage.equals((Object)state.myStylelintPackage) && this.myConfigFilePath.equals(state.myConfigFilePath) && this.myFilesPattern.equals(state.myFilesPattern) && this.myRunOnSave == state.myRunOnSave;
    }

    public int hashCode() {
        int result = this.myStylelintPackage.hashCode();
        result = 31 * result + this.myConfigFilePath.hashCode();
        result = 31 * result + this.myFilesPattern.hashCode();
        result = 31 * result + (this.myRunOnSave ? 1 : 0);
        return result;
    }

    public String toString() {
        return "StylelintState{myStylelintPackage=" + this.myStylelintPackage + ", myConfigFilePath=" + this.myConfigFilePath + ", myFilesPattern=" + this.myFilesPattern + ", runOnSave='" + this.myRunOnSave + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylelintPackage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesPattern";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/stylelint/StylelintState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/stylelint/StylelintState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylelintPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePackageRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFilePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withLinterPackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

