/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.server;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class KarmaJsSourcesLocator {
    private static final KarmaJsSourcesLocator INSTANCE = new KarmaJsSourcesLocator();
    private static final String KARMA_INTELLIJ_NAME = "karma-intellij";
    private static final String JS_REPORTER_NAME = "js_reporter";
    private final File myKarmaIntellijPackageDir = KarmaJsSourcesLocator.findKarmaIntellijPackageDir();

    private KarmaJsSourcesLocator() {
    }

    @NotNull
    public static KarmaJsSourcesLocator getInstance() {
        KarmaJsSourcesLocator karmaJsSourcesLocator = INSTANCE;
        if (karmaJsSourcesLocator == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(0);
        }
        return karmaJsSourcesLocator;
    }

    @NotNull
    private static File findKarmaIntellijPackageDir() {
        File jsReporterDir = KarmaJsSourcesLocator.getBundledJsReporterDir();
        if (jsReporterDir.isDirectory()) {
            return new File(jsReporterDir, KARMA_INTELLIJ_NAME);
        }
        throw new RuntimeException("Cannot find bundled karma-intellij in " + jsReporterDir.getAbsolutePath());
    }

    private static File getBundledJsReporterDir() {
        String srcDir;
        String jarPath = PathUtil.getJarPathForClass(KarmaJsSourcesLocator.class);
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, JS_REPORTER_NAME);
        }
        if (ApplicationManager.getApplication().isInternal() && new File(srcDir = jarPath.replace('\\', '/').replace("/out/classes/production/intellij.karma", "/contrib/js-karma/resources")).isDirectory()) {
            jarPath = srcDir;
        }
        return new File(jarPath, JS_REPORTER_NAME);
    }

    private File getAppFile(@NotNull String baseName) throws IOException {
        File file;
        if (baseName == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(1);
        }
        if (!(file = new File(this.myKarmaIntellijPackageDir, "lib" + File.separatorChar + baseName)).isFile()) {
            throw new IOException("Cannot locate " + file.getAbsolutePath());
        }
        return file;
    }

    @NotNull
    public File getIntellijConfigFile() throws IOException {
        File file = this.getAppFile("intellij.conf.js");
        if (file == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public File getClientAppFile() throws ExecutionException {
        File file;
        try {
            file = this.getAppFile("intellijRunner.js");
        }
        catch (IOException e) {
            throw new ExecutionException(KarmaBundle.message("execution.cannot_find_intellijRunner.dialog.message", new Object[0]), (Throwable)e);
        }
        if (file == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public File getKarmaIntellijPackageDir() {
        File file = this.myKarmaIntellijPackageDir;
        if (file == null) {
            KarmaJsSourcesLocator.$$$reportNull$$$0(4);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/server/KarmaJsSourcesLocator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/server/KarmaJsSourcesLocator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntellijConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientAppFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKarmaIntellijPackageDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAppFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

