/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.javascript.nodejs.execution.runConfiguration.AbstractNodeRunConfigurationExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodePathMappingsFetcher;
import com.jetbrains.nodejs.remote.NodePathMappingsFieldPeer;
import com.jetbrains.nodejs.remote.NodeRemoteInterpreterUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J%\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\u00072\u0006\u0010\u0006\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/nodejs/remote/NodeSshVagrantRunConfigurationExtension;", "Lcom/intellij/javascript/nodejs/execution/runConfiguration/AbstractNodeRunConfigurationExtension;", "<init>", "()V", "isApplicableFor", "", "configuration", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "shouldExtendMainEditor", "createEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "P", "(Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;)Lcom/intellij/openapi/options/SettingsEditor;", "getEditorTitle", "", "checkConfiguration", "", "RemoteMappingsEditor", "Companion", "intellij.nodeJS.remoteInterpreter"})
public final class NodeSshVagrantRunConfigurationExtension
extends AbstractNodeRunConfigurationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicableFor(@NotNull AbstractNodeTargetRunProfile configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return NodeSshVagrantRunConfigurationExtension.Companion.getRemoteData(configuration) != null;
    }

    public boolean shouldExtendMainEditor() {
        return true;
    }

    @NotNull
    public <P extends AbstractNodeTargetRunProfile> SettingsEditor<P> createEditor(@NotNull P configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return new RemoteMappingsEditor<P>(configuration);
    }

    @Nullable
    public String getEditorTitle() {
        return null;
    }

    public void checkConfiguration(@NotNull AbstractNodeTargetRunProfile configuration) throws RuntimeConfigurationException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        NodeJSRemoteSdkAdditionalData data = NodeSshVagrantRunConfigurationExtension.Companion.getRemoteData(configuration);
        if (data != null) {
            NodePathMappingsFetcher nodePathMappingsFetcher = NodePathMappingsFetcher.getInstance(configuration.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)nodePathMappingsFetcher, (String)"getInstance(...)");
            NodePathMappingsFetcher pathMappingsFetcher = nodePathMappingsFetcher;
            try {
                PathMappingSettings settings = pathMappingsFetcher.calcPathMappingsOrGetLastResult(data, 1000L, TimeUnit.MILLISECONDS);
                if (settings != null && settings.isEmpty()) {
                    throw new RuntimeConfigurationError(NodeJSBundle.message((String)"dialog.message.path.mappings.for.selected.interpreter.are.set", (Object[])new Object[0]));
                }
            }
            catch (ExecutionException e) {
                Object[] objectArray = new Object[]{e.getMessage()};
                throw new RuntimeConfigurationError(NodeJSBundle.message((String)"dialog.message.error.during.checking.remote.mappings", (Object[])objectArray));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/jetbrains/nodejs/remote/NodeSshVagrantRunConfigurationExtension$Companion;", "", "<init>", "()V", "getRemoteData", "Lcom/jetbrains/nodejs/remote/NodeJSRemoteSdkAdditionalData;", "configuration", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "intellij.nodeJS.remoteInterpreter"})
    public static final class Companion {
        private Companion() {
        }

        private final NodeJSRemoteSdkAdditionalData getRemoteData(AbstractNodeTargetRunProfile configuration) {
            try {
                Project project = configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                NodeJSRemoteSdkAdditionalData data = NodeRemoteInterpreterUtil.findRemoteSdkAdditionalData(project, configuration.getInterpreter());
                if (data != null && RemoteSdkUtil.isSshOrVagrantCredentialType(data.getRemoteConnectionType())) {
                    return data;
                }
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0014R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0015\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/nodejs/remote/NodeSshVagrantRunConfigurationExtension$RemoteMappingsEditor;", "T", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "Lcom/intellij/openapi/options/SettingsEditor;", "configuration", "<init>", "(Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;)V", "Lcom/intellij/javascript/nodejs/execution/AbstractNodeTargetRunProfile;", "delayedRemoteProblem", "", "Lorg/jetbrains/annotations/Nls;", "disposable", "Lcom/intellij/openapi/Disposable;", "mappingsFieldPeer", "Lcom/jetbrains/nodejs/remote/NodePathMappingsFieldPeer;", "resetEditorFrom", "", "s", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "disposeEditor", "intellij.nodeJS.remoteInterpreter"})
    private static final class RemoteMappingsEditor<T extends AbstractNodeTargetRunProfile>
    extends SettingsEditor<T> {
        @NotNull
        private final T configuration;
        @Nullable
        private String delayedRemoteProblem;
        private Disposable disposable;
        private NodePathMappingsFieldPeer mappingsFieldPeer;

        public RemoteMappingsEditor(@NotNull T configuration) {
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            this.configuration = configuration;
        }

        protected void resetEditorFrom(@NotNull T s) {
            Intrinsics.checkNotNullParameter(s, (String)"s");
            NodePathMappingsFieldPeer nodePathMappingsFieldPeer = this.mappingsFieldPeer;
            if (nodePathMappingsFieldPeer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mappingsFieldPeer");
                nodePathMappingsFieldPeer = null;
            }
            nodePathMappingsFieldPeer.updateInterpreter(s.getInterpreter());
        }

        protected void applyEditorTo(@NotNull T s) throws ConfigurationException {
            Intrinsics.checkNotNullParameter(s, (String)"s");
            if (this.delayedRemoteProblem != null) {
                throw new RuntimeConfigurationWarning(this.delayedRemoteProblem);
            }
        }

        @NotNull
        protected JComponent createEditor() {
            JBLabel remoteMappingsLabel = new JBLabel(NodeJSBundle.message((String)"label.path.mappings", (Object[])new Object[0]));
            this.disposable = Disposer.newDisposable();
            Project project = this.configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Disposable disposable = this.disposable;
            if (disposable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"disposable");
                disposable = null;
            }
            this.mappingsFieldPeer = NodeRemoteInterpreterUtil.createRemoteMappingsField(project, disposable, (Consumer<String>)((Consumer)arg_0 -> RemoteMappingsEditor.createEditor$lambda$0(this, arg_0)));
            FormBuilder formBuilder = new FormBuilder();
            JComponent jComponent = (JComponent)remoteMappingsLabel;
            NodePathMappingsFieldPeer nodePathMappingsFieldPeer = this.mappingsFieldPeer;
            if (nodePathMappingsFieldPeer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mappingsFieldPeer");
                nodePathMappingsFieldPeer = null;
            }
            formBuilder.addLabeledComponent(jComponent, (JComponent)nodePathMappingsFieldPeer.getMappingsFieldWithBrowseButton());
            JPanel jPanel = formBuilder.getPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
            return jPanel;
        }

        protected void disposeEditor() {
            Disposable disposable = this.disposable;
            if (disposable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"disposable");
                disposable = null;
            }
            Disposer.dispose((Disposable)disposable);
        }

        private static final void createEditor$lambda$0(RemoteMappingsEditor this$0, String it) {
            this$0.delayedRemoteProblem = it;
            this$0.fireEditorStateChanged();
        }
    }
}

