/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTextEditorFactory
implements GridCellEditorFactory {
    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(2);
        }
        if (grid.getDataHookup() instanceof DocumentDataHookUp) {
            return 10;
        }
        return DefaultTextEditorFactory.getCommonSuitability(grid, row, column);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx, @Nullable Object value) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(3);
        }
        if (rowIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(4);
        }
        if (columnIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(5);
        }
        GridCellEditorFactory.ValueFormatter valueFormatter = DefaultTextEditorFactory.getValueFormatter(grid, columnIdx, value);
        if (valueFormatter == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(6);
        }
        return valueFormatter;
    }

    private static GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> columnIdx, @Nullable Object value) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(7);
        }
        if (columnIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(8);
        }
        return new GridCellEditorFactory.DefaultValueToText(grid, columnIdx, value);
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(9);
        }
        if (rowIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(10);
        }
        if (columnIdx == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(11);
        }
        Object initialValue = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(rowIdx, columnIdx);
        String initialText = this.getValueFormatter((DataGrid)grid, rowIdx, columnIdx, (Object)initialValue).format().text;
        GridCellEditorFactory.ValueParser valueParser = (text, document) -> {
            boolean valueChanged = !initialText.equals(text);
            return valueChanged ? text : ObjectUtils.notNull((Object)initialValue, (Object)ReservedCellValue.NULL);
        };
        if (valueParser == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(12);
        }
        return valueParser;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (value, grid, column) -> DefaultTextEditorFactory.isEditable(value);
        if (isEditableChecker == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(13);
        }
        return isEditableChecker;
    }

    protected static boolean isEditable(Object value) {
        return value == null || value instanceof String || value instanceof ReservedCellValue || value instanceof LobInfo && !((LobInfo)value).isTruncated() && (value instanceof LobInfo.ClobInfo || ((LobInfo)value).length == 0L);
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(14);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(15);
        }
        if (column == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(16);
        }
        GridCellEditorFactory.ValueParser parser = this.getValueParser(grid, row, column);
        GridCellEditorFactory.ValueFormatter formatter = this.getValueFormatter(grid, row, column, object);
        return new GridTextCellEditor(grid, row, column, object, initiator, this.getIsEditableChecker(), parser, formatter);
    }

    private static int getCommonSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(17);
        }
        if (row == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(18);
        }
        if (column == null) {
            DefaultTextEditorFactory.$$$reportNull$$$0(19);
        }
        return switch (GridCellEditorHelper.get((CoreGrid)grid).guessJdbcTypeForEditing((CoreGrid)grid, row, column)) {
            case -16, -15, -9, -1, 1, 12, 2005, 2009, 2011 -> 1;
            default -> 0;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueFormatter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
            case 6: 
            case 12: 
            case 13: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSuitability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static class GridTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        private static final Logger LOG = Logger.getInstance(GridTextCellEditor.class);
        private final ModelIndex<GridColumn> myColumnIdx;
        private final GridCellEditorFactory.ValueParser myValueParser;

        private GridTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable Object value, EventObject initiator, @NotNull GridCellEditorFactory.IsEditableChecker editableChecker, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (grid == null) {
                GridTextCellEditor.$$$reportNull$$$0(0);
            }
            if (row == null) {
                GridTextCellEditor.$$$reportNull$$$0(1);
            }
            if (column == null) {
                GridTextCellEditor.$$$reportNull$$$0(2);
            }
            if (editableChecker == null) {
                GridTextCellEditor.$$$reportNull$$$0(3);
            }
            if (valueParser == null) {
                GridTextCellEditor.$$$reportNull$$$0(4);
            }
            if (valueFormatter == null) {
                GridTextCellEditor.$$$reportNull$$$0(5);
            }
            super(grid, row, column, value, initiator, editableChecker, valueFormatter);
            this.myColumnIdx = column;
            this.myValueParser = valueParser;
            if (grid.getDataHookup() instanceof DocumentDataHookUp && ObjectFormatterUtil.isNumericCell((CoreGrid)grid, row, column)) {
                this.myTextField.addSettingsProvider(editor -> GridUtil.configureNumericEditor(grid, (Editor)editor));
            }
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.isValueEditable() ? this.myValueParser.parse(this.myTextField.getText(), this.myTextField.getDocument()) : this.myValue;
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                GridTextCellEditor.$$$reportNull$$$0(6);
            }
            sink.set(LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY, (Object)this);
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                GridTextCellEditor.$$$reportNull$$$0(7);
            }
            this.myValue = GridTextCellEditor.loadValueFromFile(file, GridUtil.getSettings(this.myGrid));
            if (this.myValue == null || this.myValue instanceof LobInfo.FileClobInfo) {
                this.myGrid.stopEditing();
            } else {
                GridCellEditorFactory.ValueFormatterResult result = DefaultTextEditorFactory.getValueFormatter(this.myGrid, this.myColumnIdx, this.myValue).format();
                this.myTextField.setText(result.text);
            }
        }

        @Nullable
        private static Object loadValueFromFile(@NotNull VirtualFile virtualFile, @Nullable DataGridSettings settings) {
            if (virtualFile == null) {
                GridTextCellEditor.$$$reportNull$$$0(8);
            }
            if (settings != null && virtualFile.getLength() > (long)settings.getBytesLimitPerValue()) {
                return GridUtil.clobFromFile(virtualFile);
            }
            try {
                return VfsUtilCore.loadText((VirtualFile)virtualFile);
            }
            catch (IOException e) {
                String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)LOG).replace("\n", "<br>\n");
                String title = DataGridBundle.message((String)"notification.title.cannot.read.file", (Object[])new Object[]{virtualFile.getName()});
                Notifications.Bus.notify((Notification)new Notification("Update Table", title, trace, NotificationType.ERROR));
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editableChecker";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileChosen";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadValueFromFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

