/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.workspaceModel;

import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntity;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntityManager;
import com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonEntityManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "workspaceModel", "Lcom/intellij/platform/backend/workspace/WorkspaceModel;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "packageJsonFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sync", "", "createPackageJsonEntity", "Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonEntity$Builder;", "packageJson", "areEntitiesOutdated", "", "actualEntities", "getWorkspaceModelEntities", "Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonEntity;", "getEntities", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "entitySource", "Lcom/intellij/platform/workspace/storage/EntitySource;", "updateEntities", "PackageJsonEntityWrapper", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nPackageJsonEntityStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageJsonEntityStartupActivity.kt\ncom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,98:1\n1557#2:99\n1628#2,3:100\n1557#2:103\n1628#2,3:104\n1628#2,3:107\n1628#2,3:110\n1557#2:113\n1628#2,3:114\n31#3,2:117\n*S KotlinDebug\n*F\n+ 1 PackageJsonEntityStartupActivity.kt\ncom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer\n*L\n29#1:99\n29#1:100,3\n36#1:103\n36#1:104,3\n48#1:107,3\n49#1:110,3\n70#1:113\n70#1:114,3\n74#1:117,2\n*E\n"})
final class PackageJsonModelSynchronizer {
    @NotNull
    private final Project project;
    @NotNull
    private final WorkspaceModel workspaceModel;
    @NotNull
    private final VirtualFileUrlManager virtualFileUrlManager;
    @NotNull
    private final List<VirtualFile> packageJsonFiles;

    public PackageJsonModelSynchronizer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.workspaceModel = WorkspaceModelKt.getWorkspaceModel((Project)this.project);
        this.virtualFileUrlManager = this.workspaceModel.getVirtualFileUrlManager();
        Set<VirtualFile> set = PackageJsonFileManager.getInstance(this.project).getValidPackageJsonFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
        this.packageJsonFiles = CollectionsKt.toList((Iterable)set);
    }

    public final void sync() {
        PackageJsonEntity.Builder it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.packageJsonFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createPackageJsonEntity((VirtualFile)it, this.virtualFileUrlManager));
        }
        List expectedEntities = (List)destination$iv$iv;
        if (this.areEntitiesOutdated(expectedEntities)) {
            this.updateEntities(expectedEntities);
        } else if (PackageJsonEntityManagerKt.getLOG().isDebugEnabled()) {
            Collection<VirtualFileUrl> collection2;
            $this$map$iv = expectedEntities;
            int n = expectedEntities.size();
            collection = PackageJsonEntityManagerKt.getLOG();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PackageJsonEntity.Builder)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getPackageJsonParentDirUrl());
            }
            collection2 = (List)destination$iv$iv;
            collection.debug("Entities are up-to-date (" + n + "): " + (List)collection2);
        }
    }

    private final PackageJsonEntity.Builder createPackageJsonEntity(VirtualFile packageJson, VirtualFileUrlManager virtualFileUrlManager) {
        VirtualFile virtualFile = packageJson.getParent();
        if (virtualFile == null) {
            throw new IllegalStateException("no parent for " + packageJson);
        }
        VirtualFile packageJsonParentDir = virtualFile;
        return PackageJsonEntityManagerKt.createPackageJsonEntity(VirtualFileUrls.toVirtualFileUrl((VirtualFile)packageJsonParentDir, (VirtualFileUrlManager)virtualFileUrlManager));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areEntitiesOutdated(List<? extends PackageJsonEntity.Builder> actualEntities) {
        void $this$mapTo$iv;
        Collection collection;
        void $this$mapTo$iv2;
        List<PackageJsonEntity> workspaceModelEntities = this.getWorkspaceModelEntities(this.workspaceModel);
        if (workspaceModelEntities.size() != actualEntities.size()) {
            return true;
        }
        Iterable iterable = workspaceModelEntities;
        Iterable destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            void it;
            PackageJsonEntity packageJsonEntity = (PackageJsonEntity)item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new PackageJsonEntityWrapper(it));
        }
        HashSet wrappedWorkspaceModelEntities = (HashSet)destination$iv;
        destination$iv = actualEntities;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            PackageJsonEntity.Builder bl = (PackageJsonEntity.Builder)item$iv;
            collection = destination$iv2;
            boolean bl2 = false;
            collection.add(new PackageJsonEntityWrapper(it));
        }
        HashSet wrappedActualEntities = (HashSet)destination$iv2;
        return !Intrinsics.areEqual((Object)wrappedWorkspaceModelEntities, (Object)wrappedActualEntities);
    }

    private final List<PackageJsonEntity> getWorkspaceModelEntities(WorkspaceModel workspaceModel) {
        return this.getEntities(workspaceModel, PackageJsonEntity.class, PackageJsonEntity.MyEntitySource.INSTANCE);
    }

    private final <T extends WorkspaceEntity> List<T> getEntities(WorkspaceModel workspaceModel, Class<T> entityClass, EntitySource entitySource) {
        Sequence entities = workspaceModel.getCurrentSnapshot().entitiesBySource(arg_0 -> PackageJsonModelSynchronizer.getEntities$lambda$4(entitySource, arg_0));
        Sequence list = SequencesKt.filter((Sequence)entities, arg_0 -> PackageJsonModelSynchronizer.getEntities$lambda$5(entityClass, arg_0));
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)list, arg_0 -> PackageJsonModelSynchronizer.getEntities$lambda$6(entityClass, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEntities(List<? extends PackageJsonEntity.Builder> actualEntities) {
        String string;
        MutableEntityStorage actualEntitiesStorage = PackageJsonEntityManagerKt.createStorageFrom(actualEntities);
        if (PackageJsonEntityManagerKt.getLOG().isDebugEnabled()) {
            Collection<VirtualFileUrl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = actualEntities;
            int n = actualEntities.size();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PackageJsonEntity.Builder builder2 = (PackageJsonEntity.Builder)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPackageJsonParentDirUrl());
            }
            collection = (List)destination$iv$iv;
            string = "Syncing outdated entities, actual entities (" + n + "): " + (List)collection;
        } else {
            string = "Syncing outdated entities, actual entities: " + actualEntities.size();
        }
        String description = string;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<PackageJsonEntityManager> serviceClass$iv = PackageJsonEntityManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PackageJsonEntityManager)object).updateWorkspaceModel$intellij_javascript_impl(description, (Function1<? super MutableEntityStorage, Unit>)((Function1)arg_0 -> PackageJsonModelSynchronizer.updateEntities$lambda$9(actualEntitiesStorage, arg_0)));
    }

    private static final boolean getEntities$lambda$4(EntitySource $entitySource, EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == $entitySource;
    }

    private static final boolean getEntities$lambda$5(Class $entityClass, WorkspaceEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $entityClass.isInstance(it);
    }

    private static final WorkspaceEntity getEntities$lambda$6(Class $entityClass, WorkspaceEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (WorkspaceEntity)$entityClass.cast(it);
    }

    private static final boolean updateEntities$lambda$9$lambda$8(EntitySource it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == PackageJsonEntity.MyEntitySource.INSTANCE;
    }

    private static final Unit updateEntities$lambda$9(MutableEntityStorage $actualEntitiesStorage, MutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        storage.replaceBySource(PackageJsonModelSynchronizer::updateEntities$lambda$9$lambda$8, (EntityStorage)$actualEntitiesStorage);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/nodejs/packageJson/workspaceModel/PackageJsonModelSynchronizer$PackageJsonEntityWrapper;", "", "fileEntity", "<init>", "(Ljava/lang/Object;)V", "packageJsonParentDirUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "equals", "", "other", "hashCode", "", "intellij.javascript.impl"})
    private static final class PackageJsonEntityWrapper {
        @NotNull
        private final VirtualFileUrl packageJsonParentDirUrl;

        public PackageJsonEntityWrapper(@NotNull Object fileEntity) {
            Intrinsics.checkNotNullParameter((Object)fileEntity, (String)"fileEntity");
            PackageJsonEntity packageJsonEntity = fileEntity instanceof PackageJsonEntity ? (PackageJsonEntity)fileEntity : null;
            if (packageJsonEntity == null || (packageJsonEntity = packageJsonEntity.getPackageJsonParentDirUrl()) == null) {
                packageJsonEntity = ((PackageJsonEntity.Builder)fileEntity).getPackageJsonParentDirUrl();
            }
            this.packageJsonParentDirUrl = packageJsonEntity;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.javascript.nodejs.packageJson.workspaceModel.PackageJsonModelSynchronizer.PackageJsonEntityWrapper");
            PackageJsonEntityWrapper cfr_ignored_0 = (PackageJsonEntityWrapper)other;
            return Intrinsics.areEqual((Object)this.packageJsonParentDirUrl, (Object)((PackageJsonEntityWrapper)other).packageJsonParentDirUrl);
        }

        public int hashCode() {
            return this.packageJsonParentDirUrl.hashCode();
        }
    }
}

