/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSNodeVisitor;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSStubElementTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.formatter.blocks.CompositeJSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSDocCommentBlock;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSLocalAlignmentFactory;
import com.intellij.lang.javascript.frameworks.jsx.JSXEmbeddedContentUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.types.JSAttributeListElementType;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.formatter.SpacingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubBlockVisitor
extends JSNodeVisitor {
    private static final TokenSet IMPORT_EXPORT_SPECIFIERS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_SPECIFIER, ES6StubElementTypes.IMPORT_SPECIFIER});
    private static final TokenSet IMPORT_EXPORT_DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DECLARATION, ES6StubElementTypes.IMPORT_DECLARATION});
    private static final TokenSet EXTENDS_IMPLEMENTS_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXTENDS_KEYWORD, JSTokenTypes.IMPLEMENTS_KEYWORD});
    private static final TokenSet TOKENS_WITH_NONE_INDENT = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.XML_START_TAG_LIST, JSTokenTypes.XML_END_TAG_LIST});
    private final List<Block> myBlocks;
    protected final CommonCodeStyleSettings myCommonSettings;
    private final Language myDialect;
    protected final JSCodeStyleSettings myCustomSettings;
    private final JSBlock myBlock;
    private final JSLocalAlignmentFactory myAlignmentFactory;
    private final JSBlockContext myBlockContext;
    protected final FormattingMode myFormattingMode;

    public SubBlockVisitor(@Nullable JSBlock block, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (jsBlockContext == null) {
            SubBlockVisitor.$$$reportNull$$$0(0);
        }
        this.myBlocks = new ArrayList<Block>();
        this.myBlock = block;
        this.myBlockContext = jsBlockContext;
        this.myDialect = jsBlockContext.getDialect();
        this.myCommonSettings = jsBlockContext.getCommonSettings();
        this.myCustomSettings = jsBlockContext.getDialectSettings();
        this.myFormattingMode = jsBlockContext.getFormattingMode();
        this.myAlignmentFactory = this.createLocalAlignmentFactory(jsBlockContext.getTopSettings());
        this.myAlignmentFactory.setSharedAlignmentFactory(alignmentFactory);
    }

    protected JSLocalAlignmentFactory createLocalAlignmentFactory(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SubBlockVisitor.$$$reportNull$$$0(1);
        }
        return new JSLocalAlignmentFactory(this.myCommonSettings, this.myFormattingMode);
    }

    public List<Block> getBlocks() {
        return this.myBlocks;
    }

    @Override
    public void visitElement(ASTNode node) {
        List<ASTNode> children = SubBlockVisitor.getNonEmptyNodes(node);
        IElementType elementType = node.getElementType();
        if (SubBlockVisitor.requiresCompositeBlockForBody(elementType)) {
            int braceStyle = elementType == JSElementTypes.SWITCH_STATEMENT ? this.myCommonSettings.BRACE_STYLE : this.myCommonSettings.CLASS_BRACE_STYLE;
            this.generateBlocksForNodeWithBraces(node, children, braceStyle, JSTokenTypes.LBRACE);
        } else if (elementType == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION || elementType == TypeScriptStubElementTypes.TEMPLATE_LITERAL_TYPE) {
            this.generateBlocksForNodeWithBraces(node, children, 1, JSTokenTypes.DOLLAR);
        } else {
            Indent sharedSmartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
            Wrap sharedChildWrap = JSFormatterUtil.createSharedWrapForChildren(node, this.myCommonSettings, this.myCustomSettings);
            for (ASTNode child : children) {
                this.addBlock(this.createBlockForNode(child, this.getWrap(node, child, sharedChildWrap), this.getIndent(node, child, sharedSmartIndent)));
            }
        }
    }

    @NotNull
    private Block createBlockForNode(@NotNull ASTNode child, @Nullable Wrap wrap, @Nullable Indent childIndent) {
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(2);
        }
        Alignment childAlignment = this.myAlignmentFactory.getAlignment(child);
        Block block = this.myBlockContext.createBlock(child, wrap, childAlignment, childIndent, this.myAlignmentFactory.getSharedAlignmentFactory(), this.myBlock);
        if (block == null) {
            SubBlockVisitor.$$$reportNull$$$0(3);
        }
        return block;
    }

    private void generateBlocksForNodeWithBraces(@NotNull ASTNode node, @NotNull List<ASTNode> children, int braceStyleSetting, @NotNull IElementType lbraceElementType) {
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(4);
        }
        if (children == null) {
            SubBlockVisitor.$$$reportNull$$$0(5);
        }
        if (lbraceElementType == null) {
            SubBlockVisitor.$$$reportNull$$$0(6);
        }
        Indent sharedSmartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        boolean isInBraces = false;
        ArrayList<Object> childrenInBraces = new ArrayList<Block>();
        for (ASTNode child : children) {
            Block childBlock = this.createBlockForNode(child, this.getWrap(node, child, null), this.getIndent(node, child, sharedSmartIndent));
            if (child.getElementType() == lbraceElementType) {
                isInBraces = true;
                childrenInBraces.add(childBlock);
                continue;
            }
            if (child.getElementType() == JSTokenTypes.RBRACE) {
                Indent indent = braceStyleSetting == 4 || braceStyleSetting == 3 ? Indent.getNormalIndent() : Indent.getNoneIndent();
                childrenInBraces.add(childBlock);
                isInBraces = false;
                this.addBlock((Block)new CompositeJSBlock(childrenInBraces, (SpacingStrategy)this.myBlockContext.createSpacingStrategy(node), indent, node.getElementType(), this.myBlockContext));
                childrenInBraces = new ArrayList();
                continue;
            }
            if (isInBraces) {
                childrenInBraces.add(childBlock);
                continue;
            }
            this.addBlock(childBlock);
        }
        for (Block block : childrenInBraces) {
            this.addBlock(block);
        }
    }

    @NotNull
    private static List<ASTNode> getNonEmptyNodes(@NotNull ASTNode node) {
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(7);
        }
        ArrayList<ASTNode> result2 = new ArrayList<ASTNode>();
        for (PsiElement elt = node.getPsi().getFirstChild(); elt != null; elt = elt.getNextSibling()) {
            ASTNode child = elt.getNode();
            assert (child != null);
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
            result2.add(child);
        }
        ArrayList<ASTNode> arrayList = result2;
        if (arrayList == null) {
            SubBlockVisitor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    public void visitDocComment(ASTNode node) {
        ASTNode child = node.getFirstChildNode();
        if (child != null && child.getElementType() == JSTokenTypes.DOC_COMMENT) {
            this.visit(child);
        } else {
            super.visitDocComment(node);
        }
    }

    @Override
    public void visitComment(ASTNode node) {
        if (this.myCustomSettings.REFORMAT_C_STYLE_COMMENTS) {
            this.buildCommentBlocks(node);
        }
    }

    protected void addBlock(Block block) {
        this.myBlocks.add(block);
    }

    private void buildCommentBlocks(ASTNode node) {
        String commentText = node.getText();
        int pos = 0;
        while (pos < commentText.length()) {
            int nextPos = commentText.indexOf(10, pos);
            if (nextPos < 0) {
                nextPos = commentText.length();
            }
            if (pos != nextPos) {
                Indent childIndent = pos == 0 ? Indent.getNoneIndent() : Indent.getSpaceIndent((int)1);
                this.addBlock(new JSDocCommentBlock(node, pos, nextPos, childIndent));
            }
            for (pos = nextPos + 1; pos < commentText.length() && (commentText.charAt(pos) == ' ' || commentText.charAt(pos) == '\t' || commentText.charAt(pos) == '\n'); ++pos) {
            }
        }
    }

    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        ASTNode prevSibling;
        int braceStyle;
        ASTNode prevNode;
        IElementType parentNodeType;
        IElementType nodeElementType = node.getElementType();
        if (nodeElementType instanceof JSFileElementType || nodeElementType instanceof EmbeddingElementType || node.getPsi() instanceof JSFile) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSTokenTypes.DOC_COMMENT || nodeElementType == JSDocTokenTypes.DOC_TAG || nodeElementType == JSDocTokenTypes.DOC_INLINE_TAG || nodeElementType == JSDocTokenTypes.DOC_TAG_NAMEPATH || nodeElementType == JSDocTokenTypes.DOC_TAG_TYPE || nodeElementType == JSDocTokenTypes.DOC_DESCRIPTION) {
            if (SubBlockVisitor.prevNodeHasNewLine(child) && (nodeElementType == JSTokenTypes.DOC_COMMENT || !SubBlockVisitor.prevNodeHasNewLine(node))) {
                return Indent.getSpaceIndent((int)1);
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != node.getFirstChildNode()) {
            return sharedSmartIndent;
        }
        if (nodeElementType == ES6StubElementTypes.IMPORT_DECLARATION && child.getElementType() == ES6StubElementTypes.NAMED_IMPORTS) {
            return Indent.getNoneIndent();
        }
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeType = parentNode != null ? parentNode.getElementType() : null;
        if (childElementType == JSTokenTypes.END_OF_LINE_COMMENT && (prevNode = child.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace && prevNode.getText().endsWith("\n") && this.myCommonSettings.KEEP_FIRST_COLUMN_COMMENT) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.RETURN_STATEMENT) {
            if (node.getFirstChildNode() == child) {
                return Indent.getNoneIndent();
            }
            return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)false);
        }
        if (nodeElementType == ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptStubElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.DESTRUCTURING_OBJECT) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION) {
            if (JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return null;
            }
            return Indent.getNoneIndent();
        }
        if (!(nodeElementType != ES6StubElementTypes.CLASS && nodeElementType != FlowJSStubElementTypes.FLOW_JS_CLASS || childElementType != JSStubElementTypes.CALL_SIGNATURE && childElementType != JSStubElementTypes.FUNCTION_SIGNATURE && childElementType != FlowJSStubElementTypes.FLOW_FUNCTION_SIGNATURE && childElementType != TypeScriptStubElementTypes.PROPERTY_SIGNATURE)) {
            return Indent.getNormalIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(nodeElementType) && JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(childElementType)) {
            return Indent.getContinuationIndent();
        }
        if ((JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType == TypeScriptStubElementTypes.OBJECT_TYPE) && (braceStyle = this.getBraceStyle(parentNode)) == 3) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || nodeElementType == TypeScriptStubElementTypes.OBJECT_TYPE || IMPORT_EXPORT_DECLARATIONS.contains(nodeElementType) || ES6StubElementTypes.NAMED_IMPORTS == nodeElementType) {
            if (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.OR_RBRACE || childElementType == JSTokenTypes.LBRACE_OR || childElementType == JSTokenTypes.IMPORT_KEYWORD || childElementType == JSTokenTypes.EXPORT_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSTokenTypes.COMMA) {
                return this.getCommaIndent(Indent.Type.NORMAL);
            }
            return Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true);
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType) && parentNodeType == JSElementTypes.ARGUMENT_LIST) {
            if (childElementType == JSTokenTypes.FUNCTION_KEYWORD || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            ASTNode next = TreeUtil.skipElements((ASTNode)child.getTreeNext(), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.WHITE_SPACE}));
            if (next != null && next.getElementType() == JSTokenTypes.EQGT) {
                return Indent.getNoneIndent();
            }
        }
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType)) {
            if (childElementType == JSTokenTypes.COLON || TypeScriptElementTypes.TYPESCRIPT_TYPES.contains(childElementType)) {
                return Indent.getContinuationIndent();
            }
            if (!JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType) && childElementType == JSTokenTypes.FUNCTION_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(nodeElementType)) {
            if (JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) {
                return sharedSmartIndent;
            }
            if (childElementType == JSTokenTypes.RPAR || node.getFirstChildNode() == child) {
                return Indent.getNoneIndent();
            }
            return sharedSmartIndent;
        }
        if (nodeElementType == JSElementTypes.ARGUMENT_LIST) {
            if (JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) {
                return sharedSmartIndent;
            }
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR) {
                return Indent.getNoneIndent();
            }
            return sharedSmartIndent;
        }
        if (nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT && !JSSpacingProcessor.NOT_A_PACKAGE_CONTENT.contains(childElementType)) {
            if (this.myCustomSettings.INDENT_PACKAGE_CHILDREN == 1) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(nodeElementType) || JSStubElementTypes.ATTRIBUTE_LISTS.contains(childElementType)) {
            return Indent.getNoneIndent();
        }
        if ((nodeElementType instanceof JSPropertyElementType || JSElementTypes.FUNCTION_PROPERTIES.contains(nodeElementType)) && (child == ((JSProperty)node.getPsi()).getNameIdentifier() || childElementType == ES6StubElementTypes.COMPUTED_NAME || JSTokenTypes.COMMENTS.contains(childElementType) || child.getPsi() instanceof JSReferenceExpression)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.SPREAD_EXPRESSION && childElementType == JSTokenTypes.DOT_DOT_DOT) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(nodeElementType)) {
            if (JSTokenTypes.VAR_MODIFIERS.contains(childElementType) || SubBlockVisitor.isStatementLevelComment(child) || childElementType == JSTokenTypes.SEMICOLON) {
                return Indent.getNoneIndent();
            }
            if (parentNodeType == JSStubElementTypes.TYPESCRIPT_ENUM) {
                return Indent.getNoneIndent();
            }
            if (JSElementTypes.BODY_VARIABLES.contains(childElementType)) {
                IElementType prevElementType;
                ASTNode prev = child.getTreePrev();
                IElementType iElementType2 = prevElementType = prev != null ? prev.getElementType() : null;
                if (prev == null || parentNodeType instanceof JSClassElementTypeBase && !FlexSupportLoader.ECMA_SCRIPT_L4.is(this.myDialect) || prevElementType instanceof JSAttributeListElementType || JSTokenTypes.VAR_MODIFIERS.contains(prevElementType)) {
                    return Indent.getNoneIndent();
                }
            }
            if (childElementType == JSTokenTypes.COMMA) {
                return this.getCommaIndent(Indent.Type.CONTINUATION);
            }
            return sharedSmartIndent;
        }
        if (JSElementTypes.BODY_VARIABLES.contains(nodeElementType) && childElementType == JSTokenTypes.IDENTIFIER) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE && childElementType == TypeScriptStubElementTypes.OBJECT_TYPE) {
            int braceStyle2 = this.getBraceStyle(node);
            if (braceStyle2 == 3 || braceStyle2 == 4) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
            int braceStyle3 = this.getBraceStyle(node);
            if (braceStyle3 == 3 || braceStyle3 == 4) {
                return Indent.getNormalIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM || nodeElementType instanceof TypeScriptModuleElementType) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (childElementType == JSElementTypes.CATCH_BLOCK) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(childElementType)) {
            return this.myCommonSettings.INDENT_CASE_FROM_SWITCH && this.myCommonSettings.BRACE_STYLE != 3 ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(nodeElementType)) {
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.SWITCH_STATEMENT && (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.IF_STATEMENT) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.IF_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR)) {
                return Indent.getContinuationIndent();
            }
            if (childElementType == JSTokenTypes.ELSE_KEYWORD || JSTokenTypes.COMMENTS.contains(childElementType) && FormatterUtil.isFollowedBy((ASTNode)child, (IElementType)JSTokenTypes.ELSE_KEYWORD)) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSElementTypes.IF_STATEMENT && this.myCommonSettings.SPECIAL_ELSE_IF_TREATMENT && ((JSIfStatement)node.getPsi()).getElseBranch() == child.getPsi()) {
                return Indent.getNoneIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType)) {
                return Indent.getNormalIndent();
            }
        }
        if (nodeElementType == JSElementTypes.FOR_STATEMENT) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.FOR_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (node.getLastChildNode() == child) {
                return JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType) ? Indent.getNoneIndent() : Indent.getNormalIndent();
            }
            return Indent.getContinuationIndent();
        }
        if (nodeElementType == JSElementTypes.WITH_STATEMENT && JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType)) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.DOWHILE_STATEMENT && childElementType == JSTokenTypes.WHILE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if ((nodeElementType == JSElementTypes.DOWHILE_STATEMENT || nodeElementType == JSElementTypes.WHILE_STATEMENT) && (prevSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child)) != null && prevSibling.getElementType() == JSTokenTypes.LPAR) {
            return sharedSmartIndent;
        }
        if (nodeElementType == JSElementTypes.TRY_STATEMENT && childElementType == JSTokenTypes.FINALLY_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT || nodeElementType instanceof TypeScriptModuleElementType || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM || nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE) {
            if (SubBlockVisitor.requiresCompositeBlockForBody(nodeElementType) && (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE || this.myCommonSettings.CLASS_BRACE_STYLE == 3)) {
                return Indent.getNoneIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType) && (childElementType != JSTokenTypes.DOC_COMMENT || node.getFirstChildNode() != child)) {
                return Indent.getNormalIndent();
            }
            if (child instanceof OuterLanguageElement) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (node.getPsi() instanceof JSLoopStatement && child.getPsi() == ((JSLoopStatement)node.getPsi()).getBody()) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION || nodeElementType == JSStubElementTypes.DESTRUCTURING_ARRAY || nodeElementType == TypeScriptStubElementTypes.TUPLE_TYPE) {
            if (childElementType == JSTokenTypes.LBRACKET || childElementType == JSTokenTypes.RBRACKET) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.EMBEDDED_EXPRESSION) {
            if (JSTokenTypes.LBRACES.contains(childElementType) || JSTokenTypes.RBRACES.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (nodeElementType == JSElementTypes.EXPRESSION_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.PARENTHESIZED_EXPRESSION || nodeElementType == FlowJSStubElementTypes.TYPE_CAST) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR) {
                return Indent.getNoneIndent();
            }
            if (SubBlockVisitor.shouldIndentParenthesized(node, JSTokenTypes.RPAR)) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
        }
        if (nodeElementType == JSElementTypes.BINARY_EXPRESSION && childElementType != JSElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        if (childElementType == JSTokenTypes.GET_KEYWORD || childElementType == JSTokenTypes.SET_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (childElementType == JSElementTypes.ARGUMENT_LIST || childElementType == JSElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.PARAMETERS.contains(nodeElementType)) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    public static boolean shouldIndentParenthesized(@NotNull ASTNode node, IElementType closeElement) {
        ASTNode prev;
        ASTNode lastChild;
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(9);
        }
        return (lastChild = node.getLastChildNode()) != null && lastChild.getElementType() == closeElement && (prev = lastChild.getTreePrev()) != null && prev.getPsi() instanceof PsiWhiteSpace && prev.textContains('\n');
    }

    private static boolean prevNodeHasNewLine(@NotNull ASTNode node) {
        ASTNode treePrev;
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(10);
        }
        return (treePrev = node.getTreePrev()) != null && treePrev.getPsi() instanceof PsiWhiteSpace && treePrev.textContains('\n');
    }

    private static boolean requiresCompositeBlockForBody(@Nullable IElementType nodeElementType) {
        return nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT || nodeElementType instanceof TypeScriptModuleElementType || nodeElementType == JSElementTypes.SWITCH_STATEMENT || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM;
    }

    private static boolean isStatementLevelComment(@NotNull ASTNode child) {
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(11);
        }
        if (JSTokenTypes.COMMENTS.contains(child.getElementType())) {
            ASTNode parent = child.getTreeParent();
            return parent == null || parent.getFirstChildNode() == child;
        }
        return false;
    }

    @Nullable
    protected Wrap getWrap(ASTNode node, ASTNode child, @Nullable Wrap sharedWrap) {
        WrapType wrapType = null;
        IElementType nodeElementType = node.getElementType();
        if (child.getElementType() == JSTokenTypes.COMMA && !this.myCustomSettings.COMMA_ON_NEW_LINE) {
            wrapType = WrapType.NONE;
        } else if (nodeElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)node.getPsi();
            if (child.getElementType() == assignment.getOperationSign() && this.myCommonSettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE || child.getPsi() == assignment.getROperand() && !this.myCommonSettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                wrapType = WrappingUtil.getWrapType((int)this.myCommonSettings.ASSIGNMENT_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.BINARY_EXPRESSION) {
            JSBinaryExpression binary = (JSBinaryExpression)node.getPsi();
            if (child.getElementType() == binary.getOperationSign() && this.myCommonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE || child.getPsi() == binary.getROperand() && !this.myCommonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return this.getCurrentWrap(sharedWrap, this.myCommonSettings.BINARY_OPERATION_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR)) {
                wrapType = this.myCommonSettings.PARENTHESES_EXPRESSION_LPAREN_WRAP ? WrapType.ALWAYS : WrapType.NONE;
            } else if (child == node.findChildByType(JSTokenTypes.RPAR)) {
                wrapType = this.myCommonSettings.PARENTHESES_EXPRESSION_RPAREN_WRAP ? WrapType.ALWAYS : WrapType.NONE;
            }
        } else if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            IElementType childType = child.getElementType();
            if (childType != JSTokenTypes.LBRACKET && childType != JSTokenTypes.RBRACKET && !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LBRACKET)) {
                return this.getCurrentWrap(sharedWrap, this.myCommonSettings.ARRAY_INITIALIZER_WRAP);
            }
        } else {
            if (nodeElementType == JSElementTypes.CONDITIONAL_EXPRESSION) {
                return this.getWrapForConditional(node, child, sharedWrap);
            }
            if (JSElementTypes.PARAMETER_LISTS.contains(nodeElementType) && WrappingUtil.shouldWrap((int)this.myCommonSettings.METHOD_PARAMETERS_WRAP)) {
                ASTNode firstChild = node.getFirstChildNode();
                if (firstChild == null || firstChild.getElementType() != JSTokenTypes.LPAR) {
                    return null;
                }
                if (!this.myCustomSettings.COMMA_ON_NEW_LINE ? !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && child.getElementType() != JSTokenTypes.LPAR && child.getElementType() != JSTokenTypes.RPAR : child.getElementType() == JSTokenTypes.COMMA) {
                    return this.getCurrentWrap(sharedWrap, this.myCommonSettings.METHOD_PARAMETERS_WRAP);
                }
            } else if (nodeElementType == JSElementTypes.FOR_STATEMENT || nodeElementType == JSElementTypes.FOR_IN_STATEMENT) {
                if (!FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) {
                    return this.getCurrentWrap(sharedWrap, this.myCommonSettings.FOR_STATEMENT_WRAP);
                }
            } else if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
                if (this.hasWrapInBraces(child, JSExtendedLanguagesTokenSetProvider.PROPERTIES, true)) {
                    return this.getCurrentWrap(sharedWrap, this.myCustomSettings.OBJECT_LITERAL_WRAP);
                }
            } else if (nodeElementType == JSStubElementTypes.DESTRUCTURING_OBJECT) {
                if (this.hasWrapInBraces(child, JSStubElementTypes.DESTRUCTURING_PROPERTIES, true)) {
                    return this.getCurrentWrap(sharedWrap, this.myCustomSettings.OBJECT_LITERAL_WRAP);
                }
            } else if (IMPORT_EXPORT_DECLARATIONS.contains(nodeElementType) && child.getElementType() == ES6StubElementTypes.FROM_CLAUSE) {
                if (!FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)ES6StubElementTypes.NAMED_IMPORTS) && this.myCustomSettings.IMPORTS_WRAP != 0) {
                    return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
                }
            } else if (nodeElementType == ES6StubElementTypes.NAMED_IMPORTS || nodeElementType == ES6StubElementTypes.EXPORT_DECLARATION) {
                boolean needed = (this.myCustomSettings.IMPORTS_WRAP & 1) != 0;
                if (this.hasWrapInBraces(child, IMPORT_EXPORT_SPECIFIERS, !needed)) {
                    return this.getCurrentWrap(sharedWrap, this.myCustomSettings.IMPORTS_WRAP);
                }
            } else if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(nodeElementType)) {
                if (child.getElementType() == JSStubElementTypes.EXTENDS_LIST_MEMBER && !FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)EXTENDS_IMPLEMENTS_KEYWORDS)) {
                    return this.getCurrentWrap(sharedWrap, this.myCommonSettings.EXTENDS_LIST_WRAP);
                }
                if (EXTENDS_IMPLEMENTS_KEYWORDS.contains(child.getElementType())) {
                    return Wrap.createWrap((int)this.myCommonSettings.EXTENDS_KEYWORD_WRAP, (boolean)true);
                }
            } else if (JSStubElementTypes.VAR_STATEMENT == nodeElementType) {
                if (JSElementTypes.BODY_VARIABLES.contains(child.getElementType()) && !FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)JSTokenTypes.VAR_MODIFIERS)) {
                    IElementType parentElementType;
                    ASTNode parentNode = node.getTreeParent();
                    IElementType iElementType = parentElementType = parentNode != null ? parentNode.getElementType() : null;
                    if ((parentElementType == JSElementTypes.FOR_IN_STATEMENT || parentElementType == JSElementTypes.FOR_STATEMENT) && this.myCommonSettings.FOR_STATEMENT_WRAP == 0) {
                        return null;
                    }
                    return this.getCurrentWrap(sharedWrap, this.myCustomSettings.VAR_DECLARATION_WRAP);
                }
            } else if (nodeElementType == JSStubElementTypes.ATTRIBUTE_LIST) {
                PsiElement psiElement;
                IElementType parentElementType;
                ASTNode parentNode = node.getTreeParent();
                IElementType iElementType = parentElementType = parentNode != null ? parentNode.getElementType() : null;
                if (JSElementTypes.FUNCTIONS.contains(parentElementType)) {
                    return SubBlockVisitor.getWrapForAttributeList(child, this.myCustomSettings.CLASS_METHOD_DECORATOR_WRAP);
                }
                if (JSExtendedLanguagesTokenSetProvider.PARAMETERS.contains(parentElementType)) {
                    return SubBlockVisitor.getWrapForAttributeList(child, this.myCustomSettings.FUNCTION_PARAMETER_DECORATOR_WRAP);
                }
                if (parentElementType == ES6StubElementTypes.FIELD_STATEMENT) {
                    return SubBlockVisitor.getWrapForAttributeList(child, this.myCustomSettings.CLASS_FIELD_DECORATOR_WRAP);
                }
                if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(parentElementType)) {
                    return SubBlockVisitor.getWrapForAttributeList(child, this.myCustomSettings.CLASS_DECORATOR_WRAP);
                }
                if (parentNode != null && (psiElement = parentNode.getPsi()) instanceof ES6ExportDefaultAssignment) {
                    IElementType exprType;
                    ES6ExportDefaultAssignment exportDefault = (ES6ExportDefaultAssignment)psiElement;
                    JSExpression expr = exportDefault.getExpression();
                    IElementType iElementType2 = exprType = expr != null ? expr.getNode().getElementType() : null;
                    if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(exprType)) {
                        return SubBlockVisitor.getWrapForAttributeList(child, this.myCustomSettings.CLASS_DECORATOR_WRAP);
                    }
                    if (JSElementTypes.FUNCTIONS.contains(exprType)) {
                        return SubBlockVisitor.getWrapForAttributeList(child, this.myCustomSettings.CLASS_METHOD_DECORATOR_WRAP);
                    }
                }
            } else {
                if (JSElementTypes.FUNCTIONS.contains(nodeElementType)) {
                    return SubBlockVisitor.getWrapAfterDecorator(child, this.myCustomSettings.CLASS_METHOD_DECORATOR_WRAP);
                }
                if (JSExtendedLanguagesTokenSetProvider.PARAMETERS.contains(nodeElementType)) {
                    return SubBlockVisitor.getWrapAfterDecorator(child, this.myCustomSettings.FUNCTION_PARAMETER_DECORATOR_WRAP);
                }
                if (nodeElementType == ES6StubElementTypes.FIELD_STATEMENT) {
                    return SubBlockVisitor.getWrapAfterDecorator(child, this.myCustomSettings.CLASS_FIELD_DECORATOR_WRAP);
                }
                if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(nodeElementType)) {
                    return SubBlockVisitor.getWrapAfterDecorator(child, this.myCustomSettings.CLASS_DECORATOR_WRAP);
                }
                PsiElement parentNode = node.getPsi();
                if (parentNode instanceof ES6ExportDefaultAssignment) {
                    IElementType exprType;
                    ES6ExportDefaultAssignment exportDefault = (ES6ExportDefaultAssignment)parentNode;
                    JSExpression expr = exportDefault.getExpression();
                    IElementType iElementType = exprType = expr != null ? expr.getNode().getElementType() : null;
                    if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(exprType)) {
                        return SubBlockVisitor.getWrapAfterDecorator(child, this.myCustomSettings.CLASS_DECORATOR_WRAP);
                    }
                    if (JSElementTypes.FUNCTIONS.contains(exprType)) {
                        return SubBlockVisitor.getWrapAfterDecorator(child, this.myCustomSettings.CLASS_METHOD_DECORATOR_WRAP);
                    }
                }
            }
        }
        return wrapType == null ? null : Wrap.createWrap((WrapType)wrapType, (boolean)true);
    }

    private static Wrap getWrapForAttributeList(@NotNull ASTNode child, int wrapType) {
        IElementType prevElementType;
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(12);
        }
        if (child.getElementType() == JSStubElementTypes.ES6_DECORATOR) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        ASTNode prev = TreeUtil.skipWhitespaceAndComments((ASTNode)child.getTreePrev(), (boolean)false);
        IElementType iElementType = prevElementType = prev != null ? prev.getElementType() : null;
        if (prevElementType == JSStubElementTypes.ES6_DECORATOR) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return null;
    }

    private static Wrap getWrapAfterDecorator(@NotNull ASTNode child, int wrapType) {
        ASTNode lastChild;
        ASTNode prev;
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(13);
        }
        if ((prev = TreeUtil.skipWhitespaceAndComments((ASTNode)child.getTreePrev(), (boolean)false)) != null && prev.getElementType() == JSStubElementTypes.ATTRIBUTE_LIST && (lastChild = prev.getLastChildNode()) != null && lastChild.getElementType() == JSStubElementTypes.ES6_DECORATOR) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return null;
    }

    @Nullable
    protected Wrap getWrapForConditional(@NotNull ASTNode node, @NotNull ASTNode child, @Nullable Wrap sharedWrap) {
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(14);
        }
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(15);
        }
        IElementType elementType = child.getElementType();
        if (this.myCommonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && (elementType == JSTokenTypes.QUEST || elementType == JSTokenTypes.COLON) || !this.myCommonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && child.getPsi() instanceof JSExpression && node.getFirstChildNode() != child) {
            return this.getCurrentWrap(sharedWrap, this.myCommonSettings.TERNARY_OPERATION_WRAP);
        }
        return null;
    }

    protected boolean hasWrapInBraces(ASTNode child, TokenSet properties, boolean checkLBrace) {
        return !this.myCustomSettings.COMMA_ON_NEW_LINE ? (!checkLBrace || !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LBRACE)) && properties.contains(child.getElementType()) : child.getElementType() == JSTokenTypes.COMMA;
    }

    private int getBraceStyle(@Nullable ASTNode node) {
        IElementType nodeElementType;
        IElementType iElementType = nodeElementType = node != null ? node.getElementType() : null;
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType)) {
            return this.myCommonSettings.METHOD_BRACE_STYLE;
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType)) {
            return this.myCustomSettings.FUNCTION_EXPRESSION_BRACE_STYLE;
        }
        if (nodeElementType instanceof JSClassElementTypeBase || JSStubElementTypes.TYPESCRIPT_INTERFACE == nodeElementType) {
            return this.myCommonSettings.CLASS_BRACE_STYLE;
        }
        return this.myCommonSettings.BRACE_STYLE;
    }

    protected Wrap getCurrentWrap(@Nullable Wrap sharedWrap, int type) {
        return (Wrap)ObjectUtils.coalesce((Object)sharedWrap, (Object)Wrap.createWrap((int)type, (boolean)true));
    }

    private Indent getCommaIndent(Indent.Type baseType) {
        int indentSize;
        int commaIndentSize;
        CommonCodeStyleSettings.IndentOptions indentOptions;
        if (this.myCustomSettings.COMMA_ON_NEW_LINE && (baseType == Indent.Type.CONTINUATION || baseType == Indent.Type.NORMAL) && (indentOptions = this.myCommonSettings.getIndentOptions()) != null && (commaIndentSize = (indentSize = baseType == Indent.Type.CONTINUATION ? indentOptions.CONTINUATION_INDENT_SIZE : indentOptions.INDENT_SIZE) - (this.myCommonSettings.SPACE_AFTER_COMMA ? 1 : 0) - 1) >= 0) {
            return Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)commaIndentSize, (boolean)false, (boolean)false);
        }
        return Indent.getIndent((Indent.Type)baseType, (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsBlockContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockForNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createLocalAlignmentFactory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBlockForNode";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateBlocksForNodeWithBraces";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyNodes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndentParenthesized";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prevNodeHasNewLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStatementLevelComment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getWrapForAttributeList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getWrapAfterDecorator";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getWrapForConditional";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }

    public static class JSXmlBlock
    extends XmlBlock
    implements BlockEx {
        private final Wrap myWrap;
        private final Alignment myAlignment;
        private final Indent myIndent;
        @Nullable
        protected final JSBlock myOuterJsBlock;

        public JSXmlBlock(ASTNode child, Wrap wrap, Alignment alignment, Indent indent, XmlFormattingPolicy policy, boolean preserveSpace, @Nullable TextRange range, @Nullable JSBlock outerJsBlock) {
            super(child, wrap, alignment, policy, indent, range, preserveSpace);
            this.myWrap = wrap;
            this.myAlignment = alignment;
            this.myIndent = indent;
            this.myOuterJsBlock = outerJsBlock;
        }

        @Nullable
        public Language getLanguage() {
            return this.myOuterJsBlock instanceof BlockEx ? ((BlockEx)this.myOuterJsBlock).getLanguage() : JavascriptLanguage.INSTANCE;
        }

        protected List<Block> splitAttribute(ASTNode node, XmlFormattingPolicy formattingPolicy) {
            ASTNode child = node.getFirstChildNode();
            if (child != null && JSXEmbeddedContentUtil.isEmbeddedContent(child.getElementType()) && this.myOuterJsBlock != null) {
                Block block = this.myOuterJsBlock.myBlockContext.createBlock(child, this.myWrap, this.myAlignment, this.myIndent, this.myOuterJsBlock.mySharedAlignmentFactory, this.myOuterJsBlock);
                return Collections.singletonList(block);
            }
            return super.splitAttribute(node, formattingPolicy);
        }

        @NotNull
        protected XmlBlock createSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable TextRange range) {
            if (child == null) {
                JSXmlBlock.$$$reportNull$$$0(0);
            }
            return new JSXmlBlock(child, wrap, alignment, indent, this.myXmlFormattingPolicy, this.isPreserveSpace(), range, this.myOuterJsBlock);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor$JSXmlBlock", "createSimpleChild"));
        }
    }

    private static final class JSXmlSyntheticBlock
    extends SyntheticBlock {
        private JSXmlSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
            super(subBlocks, parent, indent, policy, childIndent);
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            if (child2 == null) {
                JSXmlSyntheticBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof AbstractXmlBlock)) {
                return null;
            }
            IElementType type1 = ((AbstractXmlBlock)child1).getNode().getElementType();
            if ((type1 == XmlTokenType.XML_NAME || type1 == XmlTokenType.XML_TAG_NAME) && child2 instanceof AnotherLanguageBlockWrapper && ((AnotherLanguageBlockWrapper)child2).getNode().getElementType() == TypeScriptElementTypes.TSX_TAG_TYPE_ARGUMENTS_LIST) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor$JSXmlSyntheticBlock", "getSpacing"));
        }
    }

    public static class JSXmlTagBlock
    extends XmlTagBlock {
        @Nullable
        protected final JSBlock myOuterJsBlock;

        public JSXmlTagBlock(ASTNode child, Wrap wrap, Alignment childAlignment, XmlFormattingPolicy policy, Indent childIndent, @Nullable JSBlock outerJSBlock) {
            this(child, wrap, childAlignment, policy, childIndent, false, outerJSBlock);
        }

        private JSXmlTagBlock(ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, boolean space, @Nullable JSBlock outerJsBlock) {
            super(child, wrap, alignment, policy, indent, space);
            this.myOuterJsBlock = outerJsBlock;
        }

        protected XmlTagBlock createTagBlock(@NotNull ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            if (child == null) {
                JSXmlTagBlock.$$$reportNull$$$0(0);
            }
            return new JSXmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace(), this.myOuterJsBlock);
        }

        @NotNull
        protected XmlBlock createSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable TextRange range) {
            if (child == null) {
                JSXmlTagBlock.$$$reportNull$$$0(1);
            }
            return new JSXmlBlock(child, wrap, alignment, indent, this.myXmlFormattingPolicy, this.isPreserveSpace(), range, this.myOuterJsBlock);
        }

        protected boolean useMyFormatter(@NotNull Language myLanguage, @NotNull Language childLanguage, @NotNull PsiElement childPsi) {
            IElementType type;
            if (myLanguage == null) {
                JSXmlTagBlock.$$$reportNull$$$0(2);
            }
            if (childLanguage == null) {
                JSXmlTagBlock.$$$reportNull$$$0(3);
            }
            if (childPsi == null) {
                JSXmlTagBlock.$$$reportNull$$$0(4);
            }
            if (this.isEmbeddedContent(type = childPsi.getNode().getElementType())) {
                return false;
            }
            if (childPsi instanceof XmlElement) {
                return true;
            }
            if (type == JSTokenTypes.XML_START_TAG_LIST || type == JSTokenTypes.XML_END_TAG_LIST) {
                return true;
            }
            return super.useMyFormatter(myLanguage, childLanguage, childPsi);
        }

        protected boolean isEmbeddedContent(IElementType type) {
            return JSXEmbeddedContentUtil.isEmbeddedContent(type) || type == TypeScriptElementTypes.TSX_TAG_TYPE_ARGUMENTS_LIST;
        }

        protected Alignment chooseAlignment(@NotNull ASTNode child, Alignment attrAlignment, Alignment textAlignment) {
            ASTNode startEnd;
            if (child == null) {
                JSXmlTagBlock.$$$reportNull$$$0(5);
            }
            if (JSXEmbeddedContentUtil.isEmbeddedContent(child.getElementType()) && this.isXmlTag(child.getTreeParent()) && (startEnd = (ASTNode)ObjectUtils.coalesce((Object)XmlChildRole.START_TAG_END_FINDER.findChild(child.getTreeParent()), (Object)XmlChildRole.EMPTY_TAG_END_FINDER.findChild(child.getTreeParent()))) != null && startEnd.getStartOffset() >= child.getTextRange().getEndOffset()) {
                Alignment alignment = this.myXmlFormattingPolicy.getShouldAlignAttributes() ? attrAlignment : null;
                child.putUserData(JavascriptFormattingModelBuilder.BLOCK_ALIGNMENT, (Object)alignment);
                return alignment;
            }
            return super.chooseAlignment(child, attrAlignment, textAlignment);
        }

        protected boolean isTagListStart(IElementType elementType) {
            return elementType == JSTokenTypes.XML_START_TAG_LIST;
        }

        protected boolean isTagListEnd(IElementType elementType) {
            return elementType == JSTokenTypes.XML_END_TAG_LIST;
        }

        @Nullable
        protected ASTNode processChild(@NotNull List<Block> result2, @NotNull ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
            if (result2 == null) {
                JSXmlTagBlock.$$$reportNull$$$0(6);
            }
            if (child == null) {
                JSXmlTagBlock.$$$reportNull$$$0(7);
            }
            if (TOKENS_WITH_NONE_INDENT.contains(child.getElementType())) {
                indent = Indent.getNoneIndent();
            }
            return super.processChild(result2, child, wrap, alignment, indent);
        }

        protected Block createSyntheticBlock(@NotNull ArrayList<Block> localResult, @Nullable Indent childrenIndent) {
            if (localResult == null) {
                JSXmlTagBlock.$$$reportNull$$$0(8);
            }
            return new JSXmlSyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myLanguage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childLanguage";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childPsi";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localResult";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor$JSXmlTagBlock";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTagBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSimpleChild";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "useMyFormatter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseAlignment";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processChild";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSyntheticBlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

