/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.javascript.JSParameterInfoHandlerKt;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public class JSNamedElementNode
extends JSChooserElementNode {
    public JSNamedElementNode(JSPsiNamedElementBase node) {
        super((PsiElement)node, JSNamedElementNode.buildTextFor(node), JSNamedElementNode.buildIcon(node));
    }

    private static Icon buildIcon(JSPsiNamedElementBase node) {
        JSFunction function;
        Icon accessIcon;
        Icon icon = node.getIcon(1);
        if (node instanceof JSFunction && (accessIcon = (function = (JSFunction)node).isGetProperty() ? PlatformIcons.VARIABLE_READ_ACCESS : (function.isSetProperty() ? PlatformIcons.VARIABLE_WRITE_ACCESS : null)) != null) {
            icon = JSNamedElementNode.mergeWithAccessIcon(icon, accessIcon);
        }
        return icon;
    }

    @NlsSafe
    private static String buildTextFor(JSPsiNamedElementBase node) {
        String propertyName = JSPsiImplUtils.getNameOrComputedPropertyName(node, false);
        StringBuilder text = new StringBuilder(propertyName == null ? "" : propertyName);
        if (node instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)node)).isOptional()) {
            text.append("?");
        }
        if (node instanceof JSFunction) {
            JSFunction function = (JSFunction)node;
            text.append("(");
            JSParameterList parameterList = function.getParameterList();
            if (parameterList != null) {
                JSParameterListElement[] parameters = parameterList.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    JSParameterListElement p = parameters[i];
                    if (i != 0) {
                        text.append(", ");
                    }
                    text.append(JSParameterInfoHandlerKt.getSignatureForParameter(p, null, t -> t.getTypeText(JSType.TypeTextFormat.PRESENTABLE)));
                }
            }
            text.append(")");
            JSType type = function.getReturnType();
            if (type != null) {
                text.append(": ").append(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
            }
        } else if (node instanceof JSTypeOwner) {
            JSNamedElementNode.appendType(text, ((JSTypeOwner)((Object)node)).getJSType(), (PsiElement)node);
        }
        return text.toString();
    }

    private static void appendType(StringBuilder text, JSType type, PsiElement node) {
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type, node);
        if (expanded instanceof JSFunctionType) {
            type = expanded;
        }
        String typeString = null;
        if (type != null) {
            typeString = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }
        if (typeString != null) {
            text.append(": ").append(typeString);
        }
    }
}

