/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.actions.JSImportDescriptorBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportScope;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleReferenceExpressionInfo;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.imports.ES6ImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExportedCandidatesProvider;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSResolveBasedCandidatesProvider
extends JSImportCandidatesBase {
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;

    public JSResolveBasedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo, @NotNull ModuleReferenceInfo info) {
        if (placeInfo == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(0);
        }
        if (info == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(1);
        }
        super(placeInfo);
        this.myModuleReferenceInfo = info;
    }

    @Override
    public void processCandidates(@NotNull String ref2, @NotNull JSCandidatesProcessor processor) {
        Collection<JSImportCandidate> candidates;
        if (ref2 == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(3);
        }
        if (!ref2.equals(this.myModuleReferenceInfo.getContextName())) {
            return;
        }
        Object[] results = this.myPlaceInfo.getResolveResults();
        if (results.length > 0) {
            SmartList result2 = new SmartList();
            Set resolveResultElements = ((StreamEx)StreamEx.of((Object[])results).map(el -> (JSResolveResult)ObjectUtils.tryCast((Object)el, JSResolveResult.class)).nonNull().filter(el -> el.isValidResult() || JSResolveResult.ProblemKind.JS_NEED_TO_BE_IMPORTED == el.getResolveProblemKind())).map(JSResolveResult::getElement).nonNull().toSet();
            Iterator iterator = resolveResultElements.iterator();
            while (iterator.hasNext()) {
                PsiElement element = (PsiElement)iterator.next();
                ContainerUtil.addIfNotNull((Collection)result2, (Object)this.processCandidate(ref2, element, true));
            }
            result2.forEach(processor::processCandidate);
        } else if (this.myPlaceInfo.getPlace() instanceof JSReferenceExpression && ((JSReferenceExpression)this.myPlaceInfo.getPlace()).getQualifier() == null) {
            Collection<JSPsiElementBase> exports = this.collectCommonJSExports(ref2);
            for (JSPsiElementBase element : exports) {
                JSImportCandidate candidate = this.processCandidate(ref2, (PsiElement)element, true);
                if (candidate == null) continue;
                processor.processCandidate(candidate);
            }
        }
        if (processor.hasElements()) {
            return;
        }
        String name = this.myModuleReferenceInfo.getParentName();
        if (name != null && !(candidates = this.processVariantsForQualifiedReference(ref2)).isEmpty()) {
            candidates.forEach(processor::processCandidate);
        }
    }

    @NotNull
    private Collection<JSPsiElementBase> collectCommonJSExports(@NotNull String ref2) {
        if (ref2 == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(4);
        }
        JSImportScope scope2 = new JSImportScope(this.myPlaceInfo.getProject(), this.myPlaceInfo.getFile(), JSResolveUtil.getResolveScope(this.myPlaceInfo.getPlace()), JSModuleStatusOwner.ModuleStatus.COMMONJS);
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit("exports." + ref2, (GlobalSearchScope)scope2, JSClassResolver.IncludeLocalMembersOptions.ALL, (Processor<? super JSPsiElementBase>)processor);
        JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(ref2, (GlobalSearchScope)scope2, JSClassResolver.IncludeLocalMembersOptions.ALL, (Processor<? super JSPsiElementBase>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    private JSImportCandidate processCandidate(@NotNull String refName, @NotNull PsiElement element, boolean isUnqualifiedReference) {
        JSImportCandidate candidate;
        JSElement detectParentElement;
        JSFile jsFile;
        PsiFile file;
        block12: {
            block11: {
                if (refName == null) {
                    JSResolveBasedCandidatesProvider.$$$reportNull$$$0(6);
                }
                if (element == null) {
                    JSResolveBasedCandidatesProvider.$$$reportNull$$$0(7);
                }
                if (!((file = element.getContainingFile()) instanceof JSFile)) break block11;
                jsFile = (JSFile)file;
                if (element.isValid() && file.isValid()) break block12;
            }
            return null;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return null;
        }
        if (!this.myPlaceInfo.isAcceptable(element)) {
            return null;
        }
        if (!isUnqualifiedReference && (detectParentElement = JSResolveBasedCandidatesProvider.detectParentElement(element, this.myModuleReferenceInfo)) != null && (candidate = this.processCandidate(refName, (PsiElement)detectParentElement, true)) != null) {
            return candidate;
        }
        JSImportCandidate candidate2 = this.processModuleExports(refName, jsFile, (JSQualifiedNamedElement)element, isUnqualifiedReference);
        if (candidate2 != null) {
            return candidate2;
        }
        if (!this.isES6Context(file)) {
            return null;
        }
        if (isUnqualifiedReference) {
            return this.processUnqualifiedES6Exports(refName, element);
        }
        return this.processQualifiedES6Exports(refName, (JSQualifiedNamedElement)element);
    }

    @Nullable
    private JSImportCandidate processUnqualifiedES6Exports(@NotNull String refName, @NotNull PsiElement element) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(9);
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return null;
        }
        JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)element;
        boolean isDefault = namedElement.isExportedWithDefault();
        boolean isExported = namedElement.isExported();
        if (isExported || isDefault) {
            return new ES6ImportCandidate(refName, (PsiElement)namedElement, this.myPlaceInfo.getPlace());
        }
        return null;
    }

    private JSImportCandidate processModuleExports(@NotNull String refName, @NotNull JSFile jsFile, @NotNull JSQualifiedNamedElement element, boolean isUnqualifiedReference) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(10);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(11);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(12);
        }
        if (isUnqualifiedReference && CommonJSUtil.isExportedWithModuleExports(element)) {
            return this.addFixFromFile(refName, (PsiElement)element, jsFile, null, ES6ImportPsiUtil.ImportExportType.DEFAULT);
        }
        JSQualifiedName elementNamespace = element.getJSNamespace().getQualifiedName();
        if (elementNamespace == null) {
            return null;
        }
        String namespaceName = elementNamespace.getName();
        if (JSResolveBasedCandidatesProvider.isExports(namespaceName) || JSResolveBasedCandidatesProvider.isExportsViaAlias(namespaceName, jsFile)) {
            if (isUnqualifiedReference) {
                return this.addModuleExportsWithNameFixForUnqualifiedReference(refName, jsFile, element);
            }
            return this.addModuleExportsWithNameFixForQualifiedReference(refName, jsFile, element);
        }
        return null;
    }

    @Nullable
    private static JSElement detectParentElement(@NotNull PsiElement element, @NotNull ModuleReferenceInfo moduleReferenceInfo) {
        Object context2;
        JSClass parentClass;
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(13);
        }
        if (moduleReferenceInfo == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(14);
        }
        if ((parentClass = JSUtils.getMemberContainingClass(element)) != null && element instanceof JSQualifiedNamedElement && (context2 = ((JSQualifiedNamedElement)element).getJSContext()) != moduleReferenceInfo.getContext()) {
            return null;
        }
        context2 = element.getContext();
        if (context2 == null) {
            return null;
        }
        if (context2 instanceof JSExpression && !(context2 instanceof JSQualifiedNamedElement)) {
            JSExpression initializer;
            PsiElement superParent = context2.getContext();
            if (superParent instanceof ES6ExportDefaultAssignment) {
                return (JSElement)context2;
            }
            if (superParent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)superParent).getInitializerOrStub()) == context2) {
                context2 = superParent;
            }
        }
        return context2 instanceof JSQualifiedNamedElement ? (JSElement)context2 : null;
    }

    private static boolean isExports(String text) {
        return "exports".equals(text) || "module.exports".equals(text);
    }

    @NotNull
    private Collection<JSImportCandidate> processVariantsForQualifiedReference(@NotNull String refName) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(15);
        }
        Collection<PsiElement> results = this.myModuleReferenceInfo.getResolvedParent();
        SmartList candidates = new SmartList();
        for (PsiElement resolveResult : results) {
            ContainerUtil.addIfNotNull((Collection)candidates, (Object)this.processCandidate(refName, resolveResult, false));
        }
        if (!candidates.isEmpty()) {
            SmartList smartList = candidates;
            if (smartList == null) {
                JSResolveBasedCandidatesProvider.$$$reportNull$$$0(16);
            }
            return smartList;
        }
        String parentRefName = this.myModuleReferenceInfo.getParentName();
        if (parentRefName != null) {
            List<JSImportCandidate> list = this.searchWithSymbolNameIndex(refName, this.getProject(), parentRefName);
            if (list == null) {
                JSResolveBasedCandidatesProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<JSImportCandidate> list = Collections.emptyList();
        if (list == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(18);
        }
        return list;
    }

    private List<JSImportCandidate> searchWithSymbolNameIndex(@NotNull String refName, @NotNull Project project, @NotNull String parentName) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(19);
        }
        if (project == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(20);
        }
        if (parentName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(21);
        }
        ArrayList elementsToProcess = new ArrayList();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)parentName, project, this.getModulesOnlyScope(), JSElement.class, Processors.cancelableCollectProcessor(elementsToProcess));
        if (elementsToProcess.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        for (JSElement element : elementsToProcess) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)this.processCandidate(refName, (PsiElement)element, false));
        }
        return result2;
    }

    @NotNull
    private GlobalSearchScope getModulesOnlyScope() {
        return new JSImportScope(this.myPlaceInfo.getProject(), this.myPlaceInfo.getFile(), JSResolveUtil.getResolveScope(this.myPlaceInfo.getPlace()), null);
    }

    @Nullable
    JSImportCandidate addModuleExportsWithNameFixForUnqualifiedReference(@NotNull String refName, @NotNull JSFile jsFile, @NotNull JSQualifiedNamedElement element) {
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(22);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(23);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(24);
        }
        return this.addFixFromFile(refName, (PsiElement)element, jsFile, element.getName(), ES6ImportPsiUtil.ImportExportType.SPECIFIER);
    }

    @Nullable
    private JSImportCandidate addModuleExportsWithNameFixForQualifiedReference(@NotNull String refName, @NotNull JSFile jsFile, @NotNull JSQualifiedNamedElement element) {
        JSModuleNameInfo info;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(25);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(26);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(27);
        }
        if ((info = ES6CreateImportUtil.getModuleInfo(this.myPlaceInfo.getPlace(), (PsiElement)element, jsFile)) == null) {
            return null;
        }
        return new JSImportCandidateDescriptor(info, refName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.DEFAULT);
    }

    private static boolean isExportsViaAlias(@NotNull String elementNamespace, @NotNull JSFile jsFile) {
        if (elementNamespace == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(28);
        }
        if (jsFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(29);
        }
        List<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements(jsFile);
        for (PsiElement psiElement : exportedElements) {
            JSType alias = psiElement instanceof JSTypeOwner ? ((JSTypeOwner)psiElement).getJSType() : null;
            String aliasText = alias instanceof JSReferenceType ? ((JSReferenceType)alias).getReferenceName() : null;
            if (!elementNamespace.equals(aliasText)) continue;
            return true;
        }
        return false;
    }

    private boolean isES6Context(@NotNull PsiFile file) {
        if (file == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(30);
        }
        return (DialectDetector.isES6((PsiElement)file) || DialectDetector.isTypeScript((PsiElement)file)) && ES6ExportedCandidatesProvider.isES6ImportAllowed(this.myPlaceInfo.getPlace());
    }

    private JSImportCandidate processQualifiedES6Exports(@NotNull String refName, @NotNull JSQualifiedNamedElement element) {
        PsiElement module;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(31);
        }
        if (element == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(32);
        }
        if (element.isExportedWithDefault()) {
            return null;
        }
        if (!element.isExportedWithDefault() && element.isExported() && (module = ES6PsiUtil.findExternalModule((PsiElement)element)) != null) {
            JSImportExportType type;
            JSImportDescriptor descriptor;
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (file != null && (descriptor = ES6CreateImportUtil.getImportDescriptor(element.getName(), (PsiElement)element, file, this.myPlaceInfo.getPlace(), false)) != null && (type = descriptor.getImportType()).isSpecifier()) {
                return new JSImportCandidateDescriptor(descriptor.getModuleDescriptor(), refName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
            }
            return this.addFixFromFile(refName, module, module.getContainingFile(), null, ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
        }
        return null;
    }

    private JSImportCandidate addFixFromFile(@NotNull String refName, @Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile, @Nullable String nameInExports, @NotNull ES6ImportPsiUtil.ImportExportType type) {
        PsiElement module;
        VirtualFile targetFile;
        VirtualFile file;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(33);
        }
        if (targetPsiFile == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(34);
        }
        if (type == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(35);
        }
        if (Objects.equals(file = PsiUtilCore.getVirtualFile((PsiElement)this.myPlaceInfo.getPlace()), targetFile = targetPsiFile.getVirtualFile())) {
            return null;
        }
        ES6ImportExportDeclaration.ImportExportPrefixKind kind = JSImportDescriptorBuilder.detectPrefixKind(importedElement, (PsiElement)targetPsiFile);
        if (importedElement != null && (module = ES6PsiUtil.findExternalModule(importedElement)) instanceof TypeScriptModule && !((TypeScriptModule)module).isAugmentation()) {
            return JSResolveBasedCandidatesProvider.addForTypeScriptExternalModule(refName, (TypeScriptModule)module, nameInExports, type, kind);
        }
        JSModuleNameInfo info = ES6CreateImportUtil.getModuleInfo(this.myPlaceInfo.getPlace(), importedElement, targetPsiFile);
        if (info == null) {
            return null;
        }
        return new JSImportCandidateDescriptor(info, refName, nameInExports, kind, (JSImportExportType)type);
    }

    @Nullable
    private static JSImportCandidate addForTypeScriptExternalModule(@NotNull String refName, @NotNull TypeScriptModule module, @Nullable String nameInExports, @NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull ES6ImportExportDeclaration.ImportExportPrefixKind kind) {
        String text;
        if (refName == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(36);
        }
        if (module == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(37);
        }
        if (type == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(38);
        }
        if (kind == null) {
            JSResolveBasedCandidatesProvider.$$$reportNull$$$0(39);
        }
        if ((text = module.getExternalModuleText()) == null) {
            return null;
        }
        JSModuleDescriptor.SimpleModuleDescriptor descriptor = new JSModuleDescriptor.SimpleModuleDescriptor(module, StringUtil.unquoteString((String)text));
        return new JSImportCandidateDescriptor(descriptor, refName, nameInExports, kind, (JSImportExportType)type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 24: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementNamespace";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommonJSExports";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "processVariantsForQualifiedReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectCommonJSExports";
                break;
            }
            case 5: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processCandidate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedES6Exports";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processModuleExports";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "detectParentElement";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processVariantsForQualifiedReference";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "searchWithSymbolNameIndex";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addModuleExportsWithNameFixForUnqualifiedReference";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addModuleExportsWithNameFixForQualifiedReference";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isExportsViaAlias";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isES6Context";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedES6Exports";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addFixFromFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addForTypeScriptExternalModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 16, 17, 18 -> new IllegalStateException(string);
        };
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.getImportContext() != JSImportPlaceInfo.ImportContext.SIMPLE || DialectDetector.isTypeScript(placeInfo.getPlace()) || placeInfo.isStrictTypeContext()) {
                return null;
            }
            PsiElement place = placeInfo.getPlace();
            if (!(place instanceof JSReferenceExpression)) {
                return null;
            }
            JSModuleReferenceExpressionInfo info = new JSModuleReferenceExpressionInfo((JSReferenceExpression)place);
            return new JSResolveBasedCandidatesProvider(placeInfo, info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/JSResolveBasedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

