/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6FieldStatementImpl;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeListImpl
extends JSStubElementImpl<JSAttributeListStub>
implements JSAttributeList {
    public static final TokenSet ourModifiersTypeSet = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PUBLIC_KEYWORD, JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PROTECTED_KEYWORD, JSTokenTypes.INTERNAL_KEYWORD, JSTokenTypes.EXPORT_KEYWORD, JSTokenTypes.DECLARE_KEYWORD});
    private static final Key<JSStubElementImpl.StubBuildCachedValue<JSAttributeList.AccessType>> ACCESS_TYPE_KEY = new Key("js.stub.building.access.type");

    public JSAttributeListImpl(ASTNode node) {
        super(node);
    }

    public JSAttributeListImpl(@NotNull JSAttributeListStub stub, @NotNull JSStubElementType<JSAttributeListStub, JSAttributeList> elementType) {
        if (stub == null) {
            JSAttributeListImpl.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            JSAttributeListImpl.$$$reportNull$$$0(1);
        }
        super(stub, elementType);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSAttributeListImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSAttributeList(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public boolean hasExplicitModifier(@NotNull JSAttributeList.ModifierType modifier) {
        if (modifier == null) {
            JSAttributeListImpl.$$$reportNull$$$0(3);
        }
        return this.findModifierNode(modifier) != null;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSStubElementImpl.getCachedValueIfBuildingStubs((PsiElement)this, ACCESS_TYPE_KEY, this, attrList -> {
            JSAttributeList.AccessType explicitAccessType = attrList.getExplicitAccessType();
            if (explicitAccessType != null) {
                return explicitAccessType;
            }
            PsiElement owner = attrList.getContext();
            assert (owner != null);
            return JSUtils.getImplicitAccessType(owner);
        });
        if (accessType == null) {
            JSAttributeListImpl.$$$reportNull$$$0(4);
        }
        return accessType;
    }

    @Override
    @Nullable
    public JSAttributeList.AccessType getExplicitAccessType() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null) {
            return stub.getExplicitAccessType();
        }
        if (this.hasPrivateSharp()) {
            return JSAttributeList.AccessType.PRIVATE;
        }
        ASTNode node = this.getNode().findChildByType(ourModifiersTypeSet);
        if (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType == JSTokenTypes.PUBLIC_KEYWORD || nodeType == JSTokenTypes.EXPORT_KEYWORD) {
                return JSAttributeList.AccessType.PUBLIC;
            }
            if (nodeType == JSTokenTypes.PROTECTED_KEYWORD) {
                return JSAttributeList.AccessType.PROTECTED;
            }
            if (nodeType == JSTokenTypes.PRIVATE_KEYWORD) {
                return JSAttributeList.AccessType.PRIVATE;
            }
            if (nodeType == JSTokenTypes.INTERNAL_KEYWORD) {
                return JSAttributeList.AccessType.PACKAGE_LOCAL;
            }
        }
        return null;
    }

    @Override
    public boolean hasPrivateSharp() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasPrivateSharp();
        }
        Object namedElement = this.getContext();
        if (namedElement instanceof ES6FieldStatementImpl) {
            ES6FieldStatementImpl owner = (ES6FieldStatementImpl)namedElement;
            namedElement = owner.getVariables()[0];
        }
        return JSUtils.isPrivateSharpItem(namedElement);
    }

    @Override
    public PsiElement findAccessTypeElement() {
        ASTNode modifier = this.getNode().findChildByType(ourModifiersTypeSet);
        return modifier != null ? modifier.getPsi() : null;
    }

    @Override
    public boolean hasModifier(@NotNull JSAttributeList.ModifierType modifier) {
        JSAttributeListStub stub;
        if (modifier == null) {
            JSAttributeListImpl.$$$reportNull$$$0(5);
        }
        if ((stub = (JSAttributeListStub)this.getGreenStub()) != null) {
            return stub.hasModifier(modifier);
        }
        return this.hasExplicitModifier(modifier);
    }

    @Nullable
    private ASTNode findModifierNode(JSAttributeList.ModifierType modifier) {
        IElementType type = switch (modifier) {
            default -> throw new IncompatibleClassChangeError();
            case JSAttributeList.ModifierType.DYNAMIC -> JSTokenTypes.DYNAMIC_KEYWORD;
            case JSAttributeList.ModifierType.OVERRIDE -> JSTokenTypes.OVERRIDE_KEYWORD;
            case JSAttributeList.ModifierType.NATIVE -> JSTokenTypes.NATIVE_KEYWORD;
            case JSAttributeList.ModifierType.STATIC -> JSTokenTypes.STATIC_KEYWORD;
            case JSAttributeList.ModifierType.PROTO -> JSTokenTypes.PROTO_KEYWORD;
            case JSAttributeList.ModifierType.FINAL -> JSTokenTypes.FINAL_KEYWORD;
            case JSAttributeList.ModifierType.VIRTUAL -> JSTokenTypes.VIRTUAL_KEYWORD;
            case JSAttributeList.ModifierType.DECLARE -> JSTokenTypes.DECLARE_KEYWORD;
            case JSAttributeList.ModifierType.ASYNC -> JSTokenTypes.ASYNC_KEYWORD;
            case JSAttributeList.ModifierType.CONST -> JSTokenTypes.CONST_KEYWORD;
            case JSAttributeList.ModifierType.ABSTRACT -> JSTokenTypes.ABSTRACT_KEYWORD;
            case JSAttributeList.ModifierType.READONLY -> JSTokenTypes.READONLY_KEYWORD;
            case JSAttributeList.ModifierType.EXPORT -> JSTokenTypes.EXPORT_KEYWORD;
            case JSAttributeList.ModifierType.GENERATOR -> JSTokenTypes.MULT;
            case JSAttributeList.ModifierType.GET -> JSTokenTypes.GET_KEYWORD;
            case JSAttributeList.ModifierType.SET -> JSTokenTypes.SET_KEYWORD;
            case JSAttributeList.ModifierType.IN -> JSTokenTypes.IN_KEYWORD;
            case JSAttributeList.ModifierType.OUT -> JSTokenTypes.OUT_KEYWORD;
            case JSAttributeList.ModifierType.ACCESSOR -> JSTokenTypes.ACCESSOR_KEYWORD;
        };
        return this.getNode().findChildByType(type);
    }

    @Override
    @Nullable
    public PsiElement findModifierElement(@NotNull JSAttributeList.ModifierType modifier) {
        ASTNode node;
        if (modifier == null) {
            JSAttributeListImpl.$$$reportNull$$$0(6);
        }
        return (node = this.findModifierNode(modifier)) != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSAttributeListImpl.$$$reportNull$$$0(7);
        }
        return JSChangeUtil.doDoAddAfter((PsiElement)this, element, this.getLastChild());
    }

    @Override
    public ES6Decorator @NotNull [] getDecorators() {
        ES6Decorator[] eS6DecoratorArray = (ES6Decorator[])this.getStubOrPsiChildren(JSStubElementTypes.ES6_DECORATOR, ES6Decorator.ARRAY_FACTORY);
        if (eS6DecoratorArray == null) {
            JSAttributeListImpl.$$$reportNull$$$0(8);
        }
        return eS6DecoratorArray;
    }

    @Override
    public JSAttribute @NotNull [] getAttributes() {
        if (JSAttribute.EMPTY_ARRAY == null) {
            JSAttributeListImpl.$$$reportNull$$$0(9);
        }
        return JSAttribute.EMPTY_ARRAY;
    }

    @Override
    public JSAttribute @NotNull [] getAttributesByName(@NotNull String name) {
        if (name == null) {
            JSAttributeListImpl.$$$reportNull$$$0(10);
        }
        if (JSAttribute.EMPTY_ARRAY == null) {
            JSAttributeListImpl.$$$reportNull$$$0(11);
        }
        return JSAttribute.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public JSAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            JSAttributeListImpl.$$$reportNull$$$0(12);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorators";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModifierElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

