/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.filters;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilterProvider;
import com.intellij.lang.javascript.psi.resolve.JSDefaultPlaceFilters;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceListFilterProvider
implements JSCompletionPlaceFilterProvider {
    @Override
    @Nullable
    public JSCompletionPlaceFilter forPlace(@NotNull PsiElement place) {
        String className;
        boolean isImplements;
        if (place == null) {
            JSReferenceListFilterProvider.$$$reportNull$$$0(0);
        }
        if (!(place instanceof JSReferenceExpression) || !(place.getParent() instanceof JSReferenceListMember)) {
            return null;
        }
        PsiElement parent = place.getParent().getParent();
        IElementType parentNodeType = parent.getNode().getElementType();
        PsiElement possibleJSClass = parent.getParent();
        boolean isExtends = JSElementTypes.EXTENDS_LISTS.contains(parentNodeType);
        boolean bl = isImplements = parentNodeType == JSStubElementTypes.IMPLEMENTS_LIST;
        if (possibleJSClass instanceof JSClass && (className = ((JSClass)possibleJSClass).getName()) != null) {
            if (isExtends) {
                return (((JSClass)possibleJSClass).isInterface() ? JSDefaultPlaceFilters.INTERFACE_FILTER : JSDefaultPlaceFilters.CLASS_FILTER).chain((Condition<? super JSPsiElementBase>)((Condition)e -> !JSReferenceListFilterProvider.skipSameClass(className, e)));
            }
            if (isImplements) {
                return this.getImplementsFilter().chain((Condition<? super JSPsiElementBase>)((Condition)e -> !JSReferenceListFilterProvider.skipSameClass(className, e)));
            }
        }
        return isExtends ? JSDefaultPlaceFilters.CLASS_FILTER : (isImplements ? this.getImplementsFilter() : JSDefaultPlaceFilters.ANY);
    }

    @NotNull
    protected JSCompletionPlaceFilter getImplementsFilter() {
        JSCompletionPlaceFilter jSCompletionPlaceFilter = JSDefaultPlaceFilters.IMPLEMENTS_FILTER;
        if (jSCompletionPlaceFilter == null) {
            JSReferenceListFilterProvider.$$$reportNull$$$0(1);
        }
        return jSCompletionPlaceFilter;
    }

    @Contract(value="null, _ -> false")
    public static boolean skipSameClass(@Nullable String className, @NotNull JSPsiElementBase element) {
        if (element == null) {
            JSReferenceListFilterProvider.$$$reportNull$$$0(2);
        }
        if (className == null) {
            return false;
        }
        if (element instanceof JSClass) {
            return className.equals(element.getName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/filters/JSReferenceListFilterProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/filters/JSReferenceListFilterProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forPlace";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "skipSameClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

