/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public abstract class JSDestructuringVisitor
extends JSElementVisitor {
    public static final TokenSet VAR_AND_CONTAINERS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.VARIABLES, JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS, JSElementTypes.DESTRUCTURING_CONTAINERS, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_ARRAY_REST})});

    @Override
    public final void visitJSDestructuringObject(@NotNull JSDestructuringObject node) {
        JSDestructuringProperty[] properties;
        if (node == null) {
            JSDestructuringVisitor.$$$reportNull$$$0(0);
        }
        for (JSDestructuringProperty property : properties = node.getProperties()) {
            JSInitializerOwner element = property.getDestructuringElement();
            if (element == null) continue;
            element.accept(this);
        }
    }

    @Override
    public final void visitJSDestructuringArray(@NotNull JSDestructuringArray node) {
        JSInitializerOwner[] elements;
        if (node == null) {
            JSDestructuringVisitor.$$$reportNull$$$0(1);
        }
        for (JSInitializerOwner element : elements = node.getElements()) {
            if (element == null) continue;
            element.accept(this);
        }
        JSDestructuringArrayRestElement rest = node.getRestElement();
        if (rest != null) {
            if (rest.getVariable() != null) {
                rest.getVariable().accept(this);
            }
            if (rest.getPattern() != null) {
                rest.getPattern().accept(this);
            }
        }
    }

    @Override
    public final void visitJSParameterList(@NotNull JSParameterList node) {
        if (node == null) {
            JSDestructuringVisitor.$$$reportNull$$$0(2);
        }
        this.acceptChildren(node);
    }

    @Override
    public final void visitJSVarStatement(@NotNull JSVarStatement node) {
        if (node == null) {
            JSDestructuringVisitor.$$$reportNull$$$0(3);
        }
        this.acceptChildren(node);
    }

    private void acceptChildren(JSElement node) {
        if (node instanceof StubBasedPsiElementBase) {
            PsiElement[] children;
            for (PsiElement child : children = ((StubBasedPsiElementBase)node).getStubOrPsiChildren(VAR_AND_CONTAINERS, PsiElement.ARRAY_FACTORY)) {
                child.accept((PsiElementVisitor)this);
            }
        } else {
            PsiElement[] children;
            for (PsiElement child : children = node.getChildren()) {
                if (child == null) continue;
                child.accept((PsiElementVisitor)this);
            }
        }
    }

    @Override
    public abstract void visitJSParameter(@NotNull JSParameter var1);

    @Override
    public abstract void visitJSVariable(@NotNull JSVariable var1);

    @Override
    public void visitJSDestructuringElement(@NotNull JSDestructuringElement destructuringElement) {
        JSDestructuringContainer target;
        if (destructuringElement == null) {
            JSDestructuringVisitor.$$$reportNull$$$0(4);
        }
        if ((target = destructuringElement.getTarget()) != null) {
            target.accept(this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDestructuringObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDestructuringArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSParameterList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSVarStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDestructuringElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

