/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBox;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;

public class JSEditorComboBox
extends EditorComboBox {
    private Computable<Integer> myHeightProvider;

    public JSEditorComboBox(Document document, Project project) {
        super(document, project, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
    }

    public void setHeightProvider(Computable<Integer> heightProvider) {
        this.myHeightProvider = heightProvider;
    }

    public Dimension getPreferredSize() {
        Dimension result2 = new Dimension(super.getPreferredSize());
        if (this.myHeightProvider != null) {
            result2.height = (Integer)this.myHeightProvider.compute();
        }
        return result2;
    }

    protected ComboboxEditorTextField createEditorTextField(final Document document, final Project project, FileType fileType, boolean isViewer) {
        return new ComboboxEditorTextField(document, project, fileType, isViewer){

            @NotNull
            protected EditorEx createEditor() {
                EditorEx e = super.createEditor();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                e.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file.getName()));
                EditorEx editorEx = e;
                if (editorEx == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/ui/JSEditorComboBox$1", "createEditor"));
            }
        };
    }
}

