/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConstructorChecker {
    @NotNull
    protected final JSAnnotatorProblemReporter myProblemReporter;

    public JSConstructorChecker(@NotNull JSAnnotatorProblemReporter problemReporter) {
        if (problemReporter == null) {
            JSConstructorChecker.$$$reportNull$$$0(0);
        }
        this.myProblemReporter = problemReporter;
    }

    public void checkConstructor(@NotNull JSFunction constructor, @NotNull JSClass jsClass) {
        if (constructor == null) {
            JSConstructorChecker.$$$reportNull$$$0(1);
        }
        if (jsClass == null) {
            JSConstructorChecker.$$$reportNull$$$0(2);
        }
        if (jsClass.isInterface()) {
            return;
        }
        JSCallExpression baseConstructorCall = this.findAnyBaseConstructorCall(constructor);
        if (!JSConstructorChecker.isDerived(jsClass)) {
            if (JSClassUtils.isES6ClassImplementation(jsClass) && baseConstructorCall != null) {
                String message = JavaScriptBundle.message("javascript.validation.message.base.constructor.in.not.derived", new Object[0]);
                this.myProblemReporter.registerGenericError((PsiElement)baseConstructorCall, message, new IntentionAction[0]);
            }
            return;
        }
        if (this.isBaseConstructorCallValid(constructor, jsClass, baseConstructorCall)) {
            this.checkInstanceMemberAccesses(constructor);
        }
    }

    protected boolean isBaseConstructorCallValid(@NotNull JSFunction constructor, @NotNull JSClass jsClass, @Nullable JSCallExpression baseConstructorCall) {
        if (constructor == null) {
            JSConstructorChecker.$$$reportNull$$$0(3);
        }
        if (jsClass == null) {
            JSConstructorChecker.$$$reportNull$$$0(4);
        }
        boolean isECMA6ClassImplementation = JSClassUtils.isES6ClassImplementation(jsClass);
        JSFunction nontrivialSuperClassConstructor = JSConstructorChecker.getNontrivialSuperClassConstructor(jsClass);
        if ((isECMA6ClassImplementation || nontrivialSuperClassConstructor != null) && baseConstructorCall == null) {
            PsiElement place = JSAnnotatingVisitor.getPlaceForNamedElementProblem(constructor);
            String message = JavaScriptBundle.message("javascript.validation.message.missed.super.constructor.call", new Object[0]);
            this.myProblemReporter.registerGenericError(place, message, JSFixFactory.getInstance().addSuperInvocationFix(constructor, nontrivialSuperClassConstructor));
            return false;
        }
        return true;
    }

    protected void checkInstanceMemberAccesses(@NotNull JSFunction constructor) {
        if (constructor == null) {
            JSConstructorChecker.$$$reportNull$$$0(5);
        }
        InstanceAccessValidatingVisitor visitor = new InstanceAccessValidatingVisitor();
        constructor.acceptChildren(visitor);
        for (JSCallExpression constructorCall : visitor.baseConstructorCalls) {
            new InstanceAccessValidatingVisitor().visitElement((PsiElement)constructorCall.getArgumentList());
        }
    }

    @Contract(value="null -> null")
    protected JSCallExpression findAnyBaseConstructorCall(@Nullable JSFunction jsFunction) {
        if (jsFunction == null) {
            return null;
        }
        final Ref result2 = new Ref();
        JSSingleScopeVisitor visitor = new JSSingleScopeVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result2.get() != null) {
                    return;
                }
                super.visitElement(element);
            }

            @Override
            public void visitJSCallExpression(@NotNull JSCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (JSConstructorChecker.isBaseConstructorCall(node)) {
                    result2.set((Object)node);
                    return;
                }
                super.visitJSCallExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSConstructorChecker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        jsFunction.acceptChildren(visitor);
        return (JSCallExpression)result2.get();
    }

    @Nullable
    public static JSFunction getNontrivialSuperClassConstructor(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSConstructorChecker.$$$reportNull$$$0(6);
        }
        return JSConstructorChecker.getNontrivialSuperClassConstructorRecursively(clazz, new HashSet<JSClass>());
    }

    @Nullable
    private static JSFunction getNontrivialSuperClassConstructorRecursively(@NotNull JSClass clazz, Set<JSClass> processedClasses) {
        JSClass[] classes;
        if (clazz == null) {
            JSConstructorChecker.$$$reportNull$$$0(7);
        }
        if (clazz instanceof TypeScriptClass) {
            for (JSFunction function : ((TypeScriptClass)clazz).getIndirectSuperConstructors()) {
                if (!ValidateTypesUtil.hasRequiredParameters(function)) continue;
                return function;
            }
        }
        for (JSClass aClass : classes = clazz.getSuperClasses()) {
            if (aClass.isInterface()) continue;
            JSFunction constructor = aClass.getConstructor();
            if (constructor != null) {
                return ValidateTypesUtil.hasRequiredParameters(constructor) ? constructor : null;
            }
            if (!processedClasses.add(aClass)) continue;
            return JSConstructorChecker.getNontrivialSuperClassConstructorRecursively(aClass, processedClasses);
        }
        return null;
    }

    private static boolean isBaseConstructorCall(JSCallExpression callExpression) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        return methodExpression instanceof JSSuperExpression;
    }

    protected static boolean isDerived(@NotNull JSClass jsClass) {
        JSReferenceList referenceList;
        if (jsClass == null) {
            JSConstructorChecker.$$$reportNull$$$0(8);
        }
        if ((referenceList = jsClass.getExtendsList()) == null) {
            return false;
        }
        Object[] expressions = referenceList.getExpressions();
        if (ArrayUtil.isEmpty((Object[])expressions)) {
            return false;
        }
        return expressions.length != 1 || !JSConstructorChecker.isNull((JSExpression)expressions[0]);
    }

    private static boolean isNull(JSExpression expression) {
        return expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isNullLiteral();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemReporter";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSConstructorChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isBaseConstructorCallValid";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstanceMemberAccesses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getNontrivialSuperClassConstructor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getNontrivialSuperClassConstructorRecursively";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isDerived";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class InstanceAccessValidatingVisitor
    extends JSSingleScopeVisitor {
        boolean myBaseConstructorVisited;
        public final List<JSCallExpression> baseConstructorCalls = new ArrayList<JSCallExpression>();

        private InstanceAccessValidatingVisitor() {
        }

        @Override
        public void visitJSCallExpression(@NotNull JSCallExpression node) {
            if (node == null) {
                InstanceAccessValidatingVisitor.$$$reportNull$$$0(0);
            }
            if (JSConstructorChecker.isBaseConstructorCall(node)) {
                this.baseConstructorCalls.add(node);
                this.myBaseConstructorVisited = true;
            } else {
                super.visitJSCallExpression(node);
            }
        }

        @Override
        public void visitJSThisExpression(@NotNull JSThisExpression node) {
            if (node == null) {
                InstanceAccessValidatingVisitor.$$$reportNull$$$0(1);
            }
            if (!this.myBaseConstructorVisited) {
                this.registerReferenceError((PsiElement)node, JavaScriptBundle.message("javascript.validation.message.this.before.super.call", new Object[0]));
            }
        }

        @Override
        public void visitJSSuperExpression(@NotNull JSSuperExpression superExpression) {
            if (superExpression == null) {
                InstanceAccessValidatingVisitor.$$$reportNull$$$0(2);
            }
            if (!this.myBaseConstructorVisited) {
                this.registerReferenceError((PsiElement)superExpression, JavaScriptBundle.message("javascript.validation.message.baseMethod.before.super.call", new Object[0]));
            }
        }

        private void registerReferenceError(@NotNull PsiElement target, @NotNull @InspectionMessage String message) {
            PsiElement highlightTarget;
            if (target == null) {
                InstanceAccessValidatingVisitor.$$$reportNull$$$0(3);
            }
            if (message == null) {
                InstanceAccessValidatingVisitor.$$$reportNull$$$0(4);
            }
            highlightTarget = (highlightTarget = PsiTreeUtil.getParentOfType((PsiElement)target, JSReferenceExpression.class)) == null ? target : highlightTarget;
            JSConstructorChecker.this.myProblemReporter.registerGenericError(highlightTarget, message, new IntentionAction[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "superExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/validation/JSConstructorChecker$InstanceAccessValidatingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSThisExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSSuperExpression";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerReferenceError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JSSingleScopeVisitor
    extends JSRecursiveElementVisitor {
        private JSSingleScopeVisitor() {
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                JSSingleScopeVisitor.$$$reportNull$$$0(0);
            }
            if (!JSUtils.isScopeOwner(element)) {
                super.visitElement(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/JSConstructorChecker$JSSingleScopeVisitor", "visitElement"));
        }
    }
}

