/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptDelegatingMethodsUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCreateArgumentStubsFix
extends LocalQuickFixOnPsiElement
implements LowPriorityAction {
    public JSCreateArgumentStubsFix(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)callExpression);
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("javascript.fix.generate.argument.stubs", new Object[0]);
        if (string == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(5);
        }
        JSCallExpression callExpression = (JSCallExpression)startElement;
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSType type = JSResolveUtil.getExpressionJSType(methodExpression);
        Editor editor = PsiEditorUtil.findEditor((PsiElement)startElement);
        if (type == null) {
            JSCreateArgumentStubsFix.showError(project, editor);
            return;
        }
        if (type instanceof JSFunctionTypeImpl) {
            JSCreateArgumentStubsFix.doInvoke(project, editor, callExpression, ((JSFunctionTypeImpl)type).getParameters());
        } else {
            List<JSRecordType.CallSignature> signatures2 = type.asRecordType().getCallSignatures();
            if (signatures2.isEmpty()) {
                JSCreateArgumentStubsFix.showError(project, editor);
                return;
            }
            JSCreateArgumentStubsFix.doInvoke(project, editor, callExpression, signatures2.get(0).getParameterTypeDecorators());
        }
    }

    private static void doInvoke(Project project, Editor editor, JSCallExpression callExpression, List<JSParameterTypeDecorator> parameters) {
        if (editor == null) {
            return;
        }
        JSArgumentList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        int i = 0;
        LinkedList paramNames = new LinkedList();
        TypeScriptDelegatingMethodsUtil.processDelegationCandidates(callExpression, (methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList) -> {
            Ref invertedOrder = Ref.create((Object)false);
            JSFunction from = TypeScriptDelegatingMethodsUtil.getMethodToTakeParametersFrom(methodExpression, container, candidateFunction, parameterList, candidateFunctionParameterList, (Ref<? super Boolean>)invertedOrder, false);
            if (from != null && Arrays.stream(container.getParameters()).allMatch(p -> p instanceof JSParameter)) {
                for (JSParameterListElement parameter : container.getParameters()) {
                    paramNames.add(parameter.getName());
                }
            }
        }, false);
        for (JSParameterTypeDecorator parameter : parameters) {
            if (i != 0) {
                template.addTextSegment(", ");
            }
            String defaultValue = i < paramNames.size() ? (String)paramNames.get(i) : JSRefactoringUtil.defaultValueOfType(parameter.getInferredType());
            template.addVariable("p" + i++, (Expression)new ConstantNode(defaultValue), (Expression)new ConstantNode(defaultValue), true);
        }
        editor.getCaretModel().moveToOffset(argumentList.getTextOffset() + 1);
        manager.startTemplate(editor, template);
    }

    private static void showError(@NotNull Project project, @Nullable Editor editor) {
        if (project == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(6);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaScriptBundle.message("dialog.message.cannot.create.argument.stubs.invoked.method.function", new Object[0]), (String)"", null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.fix.generate.argument.stubs", new Object[0]);
        if (string == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(9);
        }
        if (startElement == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(10);
        }
        if (endElement == null) {
            JSCreateArgumentStubsFix.$$$reportNull$$$0(11);
        }
        return super.isAvailable(project, file, startElement, endElement) && startElement instanceof JSCallExpression && ((JSCallExpression)startElement).getArgumentList() != null && PsiEditorUtil.findEditor((PsiElement)startElement) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSCreateArgumentStubsFix";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSCreateArgumentStubsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }
}

