/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.TypeScriptImplementMembersHandler;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImplementAllMembersFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    private final boolean myImplementAbstract;
    private final boolean myImplementOnlyRequired;

    public TypeScriptImplementAllMembersFix(@Nullable PsiElement element, boolean implementAbstract, boolean implementOnlyRequired) {
        super(element);
        this.myImplementAbstract = implementAbstract;
        this.myImplementOnlyRequired = implementOnlyRequired;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(3);
        }
        if (editor == null || !FileModificationService.getInstance().prepareFileForWrite(startElement.getContainingFile())) {
            return;
        }
        TypeScriptImplementMembersHandler handler = new TypeScriptImplementMembersHandler(false, this.myImplementOnlyRequired ? BaseJSGenerateHandler.ElementsToSelect.OnlyRequired : BaseJSGenerateHandler.ElementsToSelect.All, this.myImplementAbstract);
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)file, () -> handler.invokeOnElement(editor, startElement, startElement.getContainingFile()));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(4);
        }
        if (file == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(7);
        }
        if (!(startElement instanceof JSObjectLiteralExpression)) {
            return true;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)startElement, JSExpectedTypeKind.CONTEXTUAL);
        return expectedType != null && !TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral((JSObjectLiteralExpression)startElement, expectedType, false).isEmpty();
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message(this.myImplementAbstract ? "javascript.implement.members.abstract" : (this.myImplementOnlyRequired ? "javascript.implement.required.interfaces" : "javascript.implement.all.interfaces"), new Object[0]);
        if (string == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myImplementOnlyRequired ? PriorityAction.Priority.TOP : PriorityAction.Priority.HIGH;
        if (priority == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(9);
        }
        return priority;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            TypeScriptImplementAllMembersFix.$$$reportNull$$$0(11);
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementAllMembersFix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/TypeScriptImplementAllMembersFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

