/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.structuralsearch.JSStructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.XmlMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JSMatchingVisitor
extends JSElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;
    private XmlMatchingVisitor myXmlMatchingVisitor = null;

    JSMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
    }

    private PsiElement extractOnlyStatement(PsiElement element) {
        JSBlockStatement blockStatement;
        block5: {
            block4: {
                if (!(element instanceof JSBlockStatement)) break block4;
                blockStatement = (JSBlockStatement)element;
                if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) break block5;
            }
            return element;
        }
        if (blockStatement.getParent() instanceof JSFunction) {
            return blockStatement;
        }
        JSSourceElement[] statements = blockStatement.getStatementListItems();
        return statements.length == 1 ? statements[0] : blockStatement;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            JSMatchingVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof XmlElement) {
            this.visitXml(element);
            return;
        }
        PsiElement other = this.myMatchingVisitor.getElement();
        PsiElement statement = this.extractOnlyStatement(other);
        if (statement != other) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(element, statement));
            return;
        }
        super.visitElement(element);
        if (JSStructuralSearchProfile.canBePatternVariable(element)) {
            if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(element)) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement(element, other));
            } else {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchText(element, other));
            }
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(SsrFilteringNodeIterator.create((PsiElement)element.getFirstChild()), SsrFilteringNodeIterator.create((PsiElement)other.getFirstChild())));
        }
    }

    @Override
    public void visitJSEmbeddedContent(@NotNull JSEmbeddedContent embeddedContent) {
        if (embeddedContent == null) {
            JSMatchingVisitor.$$$reportNull$$$0(1);
        }
        JSEmbeddedContent other = (JSEmbeddedContent)this.myMatchingVisitor.getElement(JSEmbeddedContent.class);
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(embeddedContent.getFirstChild(), other.getFirstChild()));
    }

    private void visitXml(PsiElement element) {
        if (this.myXmlMatchingVisitor == null) {
            this.myXmlMatchingVisitor = new XmlMatchingVisitor(this.myMatchingVisitor);
        }
        element.accept((PsiElementVisitor)this.myXmlMatchingVisitor);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression expression) {
        boolean multiMatch;
        PsiElement other;
        if (expression == null) {
            JSMatchingVisitor.$$$reportNull$$$0(2);
        }
        if ((other = this.myMatchingVisitor.getElement()) instanceof LeafElement && ((LeafElement)other).getElementType() == JSTokenTypes.IDENTIFIER && other.getParent() instanceof JSReferenceExpression) {
            this.myMatchingVisitor.setResult(false);
            return;
        }
        JSExpression qualifier = expression.getQualifier();
        boolean typedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)expression);
        boolean bl = multiMatch = expression.getContainingFile() == other.getContainingFile();
        if ((qualifier != null || !typedVar) && other instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)other;
            if (!multiMatch) {
                if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(expression.getReferenceNameElement(), referenceExpression.getReferenceNameElement()))) return;
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)qualifier, (PsiElement)referenceExpression.getQualifier()));
                return;
            }
        }
        super.visitJSReferenceExpression(expression);
    }

    @Override
    public void visitJSAttributeNameValuePair(@NotNull JSAttributeNameValuePair attributeNameValuePair) {
        if (attributeNameValuePair == null) {
            JSMatchingVisitor.$$$reportNull$$$0(3);
        }
        JSAttributeNameValuePair other = (JSAttributeNameValuePair)this.myMatchingVisitor.getElement();
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(attributeNameValuePair.getNameIdentifier(), other.getNameIdentifier()))) {
            return;
        }
        ASTNode valueNode = attributeNameValuePair.getValueNode();
        if (valueNode == null) {
            return;
        }
        PsiElement value2 = other.getLastChild();
        MatchingHandler handler = (MatchingHandler)valueNode.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            String text = value2.getText();
            int offset = 0;
            int length = text.length();
            if (StringUtil.isQuotedString((String)text)) {
                ++offset;
                --length;
            }
            this.myMatchingVisitor.setResult(((SubstitutionHandler)handler).handle(value2, offset, length, this.myMatchingVisitor.getMatchContext()));
        } else if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match(attributeNameValuePair.getLastChild(), value2, this.myMatchingVisitor.getMatchContext()));
        } else {
            String text1 = StringUtil.unquoteString((String)valueNode.getText());
            String text2 = StringUtil.unquoteString((String)value2.getText());
            boolean caseSensitiveMatch = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
            this.myMatchingVisitor.setResult(caseSensitiveMatch ? text1.equals(text2) : text1.equalsIgnoreCase(text2));
        }
    }

    @Override
    public void visitJSXmlLiteralExpression(@NotNull JSXmlLiteralExpression node) {
        if (node == null) {
            JSMatchingVisitor.$$$reportNull$$$0(4);
        }
        this.visitXml((PsiElement)node);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void visitJSLiteralExpression(@NotNull JSLiteralExpression patternLiteral) {
        JSLiteralExpression matchLiteral;
        if (patternLiteral == null) {
            JSMatchingVisitor.$$$reportNull$$$0(5);
        }
        if ((matchLiteral = (JSLiteralExpression)this.myMatchingVisitor.getElement(JSLiteralExpression.class)) == null) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(patternLiteral.isQuotedLiteral() == matchLiteral.isQuotedLiteral() && patternLiteral.isRegExpLiteral() == matchLiteral.isRegExpLiteral())) {
            return;
        }
        MatchingHandler handler = (MatchingHandler)patternLiteral.getUserData(CompiledPattern.HANDLER_KEY);
        if (handler instanceof SubstitutionHandler) {
            SubstitutionHandler substitutionHandler = (SubstitutionHandler)handler;
            int offset = 0;
            int length = matchLiteral.getTextLength();
            if (matchLiteral.isQuotedLiteral() || matchLiteral.isRegExpLiteral()) {
                --length;
                ++offset;
            }
            this.myMatchingVisitor.setResult(substitutionHandler.handle((PsiElement)matchLiteral, offset, length, this.myMatchingVisitor.getMatchContext()));
            return;
        }
        if (handler != null) {
            this.myMatchingVisitor.setResult(handler.match((PsiElement)patternLiteral, (PsiElement)matchLiteral, this.myMatchingVisitor.getMatchContext()));
            return;
        }
        Object value1 = patternLiteral.getValue();
        Object value2 = matchLiteral.getValue();
        if (value1 instanceof String) {
            String string1 = (String)value1;
            if (value2 instanceof String) {
                String string2 = (String)value2;
                boolean caseSensitiveMatch = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
                this.myMatchingVisitor.setResult(caseSensitiveMatch ? string1.equals(string2) : string1.equalsIgnoreCase(string2));
                return;
            }
        }
        if (value1 != null && value2 != null) {
            this.myMatchingVisitor.setResult(value1.equals(value2));
            return;
        }
        this.myMatchingVisitor.setResult(false);
    }

    @Override
    public void visitJSFunctionDeclaration(@NotNull JSFunction f1) {
        if (f1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(6);
        }
        JSFunction f2 = (JSFunction)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(f1.getKind() == f2.getKind() && this.myMatchingVisitor.match(f1.getNameIdentifier(), f2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)f1.getAttributeList(), (PsiElement)f2.getAttributeList()) && this.myMatchingVisitor.matchSons((PsiElement)f1.getParameterList(), (PsiElement)f2.getParameterList()) && this.myMatchingVisitor.matchOptionally(f1.getReturnTypeElement(), f2.getReturnTypeElement()) && this.myMatchingVisitor.matchOptionally((PsiElement)f1.getBlock(), (PsiElement)f2.getBlock()));
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression functionExpression) {
        JSFunctionExpression other;
        if (functionExpression == null) {
            JSMatchingVisitor.$$$reportNull$$$0(7);
        }
        if ((other = (JSFunctionExpression)this.myMatchingVisitor.getElement(JSFunctionExpression.class)) == null) {
            return;
        }
        if (!this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSonsOptionally((PsiElement)functionExpression.getAttributeList(), (PsiElement)other.getAttributeList()) && this.myMatchingVisitor.matchSons((PsiElement)functionExpression.getParameterList(), (PsiElement)other.getParameterList()))) {
            return;
        }
        PsiElement body1 = this.getElementToMatch(JSMatchingVisitor.getBody(functionExpression));
        PsiElement body2 = this.getElementToMatch(JSMatchingVisitor.getBody(other));
        if (body1 instanceof JSExpression && (body2 == null || body2 instanceof JSStatement || body2 instanceof PsiComment)) {
            PsiElement parent1 = body1.getParent();
            this.myMatchingVisitor.setResult(parent1 instanceof JSStatement ? this.myMatchingVisitor.matchSequentially(parent1, body2) : this.myMatchingVisitor.matchSequentially(body1, body2 == null ? JSMatchingVisitor.getBody(other) : body2.getParent()));
        } else {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(body1, body2));
        }
    }

    private static PsiElement getBody(JSFunctionExpression other) {
        JSBlockStatement block = other.getBlock();
        if (block != null) {
            return block;
        }
        PsiElement lastChild = other.getLastChild();
        return lastChild instanceof JSExpression ? lastChild : null;
    }

    private PsiElement getElementToMatch(PsiElement element) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            if (element instanceof JSBlockStatement) {
                List list = PsiTreeUtil.getChildrenOfAnyType((PsiElement)element, (Class[])new Class[]{JSStatement.class, PsiComment.class});
                if (list.isEmpty()) {
                    return null;
                }
                element = (PsiElement)list.get(0);
                if (list.size() > 1) {
                    return element;
                }
            }
            if (element instanceof JSReturnStatement) {
                JSReturnStatement returnStatement = (JSReturnStatement)element;
                return returnStatement.getExpression();
            }
            if (element instanceof JSExpressionStatement) {
                JSExpressionStatement expressionStatement = (JSExpressionStatement)element;
                return expressionStatement.getExpression();
            }
        }
        return element;
    }

    @Override
    public void visitJSClass(@NotNull JSClass c1) {
        JSClass c2;
        if (c1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(8);
        }
        if ((c2 = (JSClass)this.myMatchingVisitor.getElement(JSClass.class)) == null) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(c1.getNameIdentifier(), c2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)c1.getAttributeList(), (PsiElement)c2.getAttributeList()) && this.myMatchingVisitor.matchSonsInAnyOrder((PsiElement)c1.getExtendsList(), (PsiElement)c2.getExtendsList()) && this.myMatchingVisitor.matchSonsInAnyOrder((PsiElement)c1.getImplementsList(), (PsiElement)c2.getImplementsList()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])c1.getFields(), (PsiElement[])c2.getFields()) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])c1.getFunctions(), (PsiElement[])c2.getFunctions()));
    }

    @Override
    public void visitJSVarStatement(@NotNull JSVarStatement vs1) {
        if (vs1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(9);
        }
        JSVarStatement vs2 = (JSVarStatement)this.myMatchingVisitor.getElement();
        PsiElement firstChild1 = vs1.getFirstChild();
        PsiElement firstChild2 = vs2.getFirstChild();
        if (!this.myMatchingVisitor.setResult(!(firstChild1 instanceof JSAttributeList) || firstChild1.getTextLength() <= 0 || firstChild2 instanceof JSAttributeList && this.myMatchingVisitor.match(firstChild1, firstChild2))) {
            return;
        }
        JSVarStatement.VarKeyword keyword = vs1.getVarKeyword();
        if (!(keyword != JSVarStatement.VarKeyword.CONST && keyword != JSVarStatement.VarKeyword.LET || this.myMatchingVisitor.setResult(vs2.getVarKeyword() == keyword))) {
            return;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially((PsiElement[])vs1.getVariables(), (PsiElement[])vs2.getVariables()));
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable variable1) {
        if (variable1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(10);
        }
        JSVariable variable2 = (JSVariable)this.myMatchingVisitor.getElement();
        JSAttributeList attributeList = variable1.getAttributeList();
        if (attributeList != null && attributeList.getFirstChild() == null) {
            attributeList = null;
        }
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match(variable1.getNameIdentifier(), variable2.getNameIdentifier()) && this.myMatchingVisitor.matchSonsOptionally((PsiElement)attributeList, (PsiElement)variable2.getAttributeList()) && this.myMatchingVisitor.matchOptionally(variable1.getTypeElement(), variable2.getTypeElement()) && this.myMatchingVisitor.matchOptionally((PsiElement)variable1.getInitializerOrStub(), (PsiElement)variable2.getInitializerOrStub()));
    }

    @Override
    public void visitJSIfStatement(@NotNull JSIfStatement if1) {
        if (if1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(11);
        }
        JSIfStatement if2 = (JSIfStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)if1.getCondition(), (PsiElement)if2.getCondition()) && this.matchBody((PsiElement)if1.getThenBranch(), (PsiElement)if2.getThenBranch()) && this.matchBody((PsiElement)if1.getElseBranch(), (PsiElement)if2.getElseBranch()));
    }

    @Override
    public void visitJSForStatement(@NotNull JSForStatement for1) {
        if (for1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(12);
        }
        JSForStatement for2 = (JSForStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getVarDeclaration(), (PsiElement)for2.getVarDeclaration()) && this.myMatchingVisitor.match((PsiElement)for1.getInitialization(), (PsiElement)for2.getInitialization()) && this.myMatchingVisitor.match((PsiElement)for1.getCondition(), (PsiElement)for2.getCondition()) && this.myMatchingVisitor.match((PsiElement)for1.getUpdate(), (PsiElement)for2.getUpdate()) && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    @Override
    public void visitJSForInStatement(@NotNull JSForInStatement for1) {
        if (for1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(13);
        }
        JSForInStatement for2 = (JSForInStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)for1.getVarDeclaration(), (PsiElement)for2.getVarDeclaration()) && this.myMatchingVisitor.match((PsiElement)for1.getVariableExpression(), (PsiElement)for2.getVariableExpression()) && this.myMatchingVisitor.match((PsiElement)for1.getCollectionExpression(), (PsiElement)for1.getCollectionExpression()) && for1.isForEach() == for2.isForEach() && for1.isForAwait() == for2.isForAwait() && this.matchBody((PsiElement)for1.getBody(), (PsiElement)for2.getBody()));
    }

    @Override
    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement while1) {
        if (while1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(14);
        }
        JSDoWhileStatement while2 = (JSDoWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    @Override
    public void visitJSWhileStatement(@NotNull JSWhileStatement while1) {
        if (while1 == null) {
            JSMatchingVisitor.$$$reportNull$$$0(15);
        }
        JSWhileStatement while2 = (JSWhileStatement)this.myMatchingVisitor.getElement();
        this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)while1.getCondition(), (PsiElement)while2.getCondition()) && this.matchBody((PsiElement)while1.getBody(), (PsiElement)while2.getBody()));
    }

    @Override
    public void visitJSBlock(@NotNull JSBlockStatement patternBlock) {
        PsiElement matchElement;
        if (patternBlock == null) {
            JSMatchingVisitor.$$$reportNull$$$0(16);
        }
        if ((matchElement = this.myMatchingVisitor.getElement()) instanceof JSBlockStatement) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSons((PsiElement)patternBlock, matchElement));
        } else {
            List patternChildren = PsiTreeUtil.getChildrenOfAnyType((PsiElement)patternBlock, (Class[])new Class[]{JSStatement.class, PsiComment.class});
            if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching() && patternChildren.size() == 1) {
                this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)patternChildren.get(0), matchElement));
            } else {
                this.myMatchingVisitor.setResult(false);
            }
        }
    }

    private boolean matchBody(PsiElement patternElement, PsiElement matchElement) {
        if (this.myMatchingVisitor.getMatchContext().getOptions().isLooseMatching()) {
            List<PsiElement> matchElements;
            if (patternElement == null) {
                return true;
            }
            if (matchElement instanceof JSBlockStatement) {
                List<PsiElement> children = PsiTreeUtil.getChildrenOfAnyType((PsiElement)matchElement, (Class[])new Class[]{JSStatement.class, PsiComment.class});
                matchElements = patternElement instanceof JSBlockStatement || children.size() == 1 ? children : Collections.singletonList(matchElement);
            } else {
                matchElements = Collections.singletonList(matchElement);
            }
            List patternElements = patternElement instanceof JSBlockStatement ? PsiTreeUtil.getChildrenOfAnyType((PsiElement)patternElement, (Class[])new Class[]{JSStatement.class, PsiComment.class}) : Collections.singletonList(patternElement);
            return this.myMatchingVisitor.matchSequentially(patternElements.toArray(PsiElement.EMPTY_ARRAY), matchElements.toArray(PsiElement.EMPTY_ARRAY));
        }
        return this.myMatchingVisitor.matchSequentially(patternElement, matchElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedContent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeNameValuePair";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternLiteral";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vs1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "if1";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "for1";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "while1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternBlock";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/JSMatchingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSEmbeddedContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSReferenceExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSAttributeNameValuePair";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSXmlLiteralExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSLiteralExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSFunctionExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSVarStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSVariable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSIfStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForInStatement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDoWhileStatement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSWhileStatement";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

