/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.SuspendContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J?\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010\u001eJ/\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010%J<\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0014\u0010(\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010$\u001a\u00020!H\u0016J\n\u0010)\u001a\u0006\u0012\u0002\b\u00030 J\u0019\u0010*\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0010J\u0015\u0010/\u001a\u00020-2\u0006\u0010$\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 2\u0006\u0010$\u001a\u00020!H\u0016J\u0014\u00102\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u00103\u001a\u00020-H\u0016J\u0014\u00104\u001a\u00020\u001d2\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00067"}, d2={"Lorg/jetbrains/debugger/BreakpointManagerBase;", "T", "Lorg/jetbrains/debugger/BreakpointBase;", "Lorg/jetbrains/debugger/BreakpointManager;", "<init>", "()V", "breakpoints", "", "getBreakpoints", "()Ljava/util/Set;", "breakpointDuplicationByTarget", "Ljava/util/concurrent/ConcurrentMap;", "getBreakpointDuplicationByTarget", "()Ljava/util/concurrent/ConcurrentMap;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/debugger/BreakpointListener;", "getDispatcher", "()Lcom/intellij/util/EventDispatcher;", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;IZ)Lorg/jetbrains/debugger/BreakpointBase;", "doSetBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "breakpoint", "(Lorg/jetbrains/debugger/BreakpointTarget;Lcom/intellij/util/Url;Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "setBreakpoint", "Lorg/jetbrains/debugger/BreakpointManager$SetBreakpointResult;", "remove", "removeAll", "doClearBreakpoint", "(Lorg/jetbrains/debugger/BreakpointBase;)Lorg/jetbrains/concurrency/Promise;", "addBreakpointListener", "", "listener", "notifyBreakpointResolvedListener", "(Lorg/jetbrains/debugger/BreakpointBase;)V", "flush", "enableBreakpoints", "setBreakOnFirstStatement", "isBreakOnFirstStatement", "context", "Lorg/jetbrains/debugger/SuspendContext;", "intellij.javascript.debugger.backend"})
public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    @NotNull
    private final Set<T> breakpoints;
    @NotNull
    private final ConcurrentMap<T, T> breakpointDuplicationByTarget;
    @NotNull
    private final EventDispatcher<BreakpointListener> dispatcher;

    public BreakpointManagerBase() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.breakpoints = set;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)new HashingStrategy<T>(){

            public int hashCode(T b) {
                if (b == null) {
                    return 0;
                }
                int result = ((BreakpointBase)b).getLine();
                result *= 31 + ((BreakpointBase)b).getColumn();
                if (((BreakpointBase)b).getCondition() != null) {
                    String string = ((BreakpointBase)b).getCondition();
                    Intrinsics.checkNotNull((Object)string);
                    result *= 31 + string.hashCode();
                }
                return result *= 31 + ((BreakpointBase)b).getTarget().hashCode();
            }

            public boolean equals(T b1, T b2) {
                if (b1 == b2) {
                    return true;
                }
                return b1 != null && b2 != null && Intrinsics.areEqual(((BreakpointBase)b1).getTarget().getClass(), ((BreakpointBase)b2).getTarget().getClass()) && Intrinsics.areEqual((Object)((BreakpointBase)b1).getTarget(), (Object)((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && Intrinsics.areEqual((Object)((BreakpointBase)b1).getCondition(), (Object)((BreakpointBase)b2).getCondition());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.breakpointDuplicationByTarget = concurrentMap;
        EventDispatcher eventDispatcher = EventDispatcher.create(BreakpointListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.dispatcher = eventDispatcher;
    }

    @NotNull
    public Set<T> getBreakpoints() {
        return this.breakpoints;
    }

    @NotNull
    protected final ConcurrentMap<T, T> getBreakpointDuplicationByTarget() {
        return this.breakpointDuplicationByTarget;
    }

    @NotNull
    protected final EventDispatcher<BreakpointListener> getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    protected abstract T createBreakpoint(@NotNull BreakpointTarget var1, int var2, int var3, @Nullable String var4, int var5, boolean var6);

    @NotNull
    protected abstract Promise<? extends Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget var1, @Nullable Url var2, @NotNull T var3);

    @NotNull
    public BreakpointManager.SetBreakpointResult setBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable Url url, @Nullable String condition, int ignoreCount) {
        Promise promise2;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        T breakpoint = this.createBreakpoint(target, line, column, condition, ignoreCount, true);
        BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
        if (existingBreakpoint != null && !existingBreakpoint.getPendingRemove()) {
            return (BreakpointManager.SetBreakpointResult)new BreakpointManager.BreakpointExist((Breakpoint)existingBreakpoint);
        }
        this.getBreakpoints().add(breakpoint);
        Function0 set = () -> BreakpointManagerBase.setBreakpoint$lambda$2(this, target, url, breakpoint);
        BreakpointBase breakpointBase = existingBreakpoint;
        boolean bl = breakpointBase != null ? breakpointBase.getPendingRemove() : false;
        if (bl) {
            Promise promise3 = existingBreakpoint.vmRegistered().thenAsync(arg_0 -> BreakpointManagerBase.setBreakpoint$lambda$3(new Function1((Function0<? extends Promise<Breakpoint>>)set){
                final /* synthetic */ Function0<Promise<Breakpoint>> $set;
                {
                    this.$set = $set;
                }

                public final Promise<Breakpoint> invoke(Object it) {
                    return (Promise)this.$set.invoke();
                }
            }, arg_0));
            promise2 = promise3;
            Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"thenAsync(...)");
        } else {
            promise2 = (Promise)set.invoke();
        }
        Promise promise4 = promise2;
        return (BreakpointManager.SetBreakpointResult)new BreakpointManager.BreakpointCreated((Breakpoint)breakpoint, promise4);
    }

    @NotNull
    public Promise<?> remove(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        BreakpointBase b = (BreakpointBase)breakpoint;
        b.setPendingRemove(true);
        Promise promise2 = b.vmRegistered().then(arg_0 -> BreakpointManagerBase.remove$lambda$4(new Function1(this, b){
            final /* synthetic */ BreakpointManagerBase<T> this$0;
            final /* synthetic */ T $b;
            {
                this.this$0 = $receiver;
                this.$b = $b;
            }

            public final Promise<T> invoke(Object it) {
                this.this$0.doClearBreakpoint(this.$b);
                this.this$0.getBreakpoints().remove(this.$b);
                return Promises.resolvedPromise(this.this$0.getBreakpointDuplicationByTarget().remove(this.$b));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    public final Promise<?> removeAll() {
        List list = CollectionsKt.toList((Iterable)this.getBreakpoints());
        this.getBreakpoints().clear();
        this.breakpointDuplicationByTarget.clear();
        SmartList promises = new SmartList();
        for (BreakpointBase b : list) {
            promises.add(this.remove(b));
        }
        return Promises.all((Collection)((Collection)promises));
    }

    @NotNull
    protected abstract Promise<?> doClearBreakpoint(@NotNull T var1);

    public final void addBreakpointListener(@NotNull BreakpointListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    protected final void notifyBreakpointResolvedListener(@NotNull T breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (((BreakpointBase)breakpoint).isResolved()) {
            ((BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }

    @NotNull
    public Promise<? extends Breakpoint> flush(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        return ((BreakpointBase)breakpoint).flush(this);
    }

    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        return Promises.rejectedPromise((String)"Unsupported");
    }

    public void setBreakOnFirstStatement() {
    }

    public boolean isBreakOnFirstStatement(@NotNull SuspendContext<?> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        return false;
    }

    private static final Unit setBreakpoint$lambda$2$lambda$0(BreakpointManagerBase this$0, BreakpointBase $breakpoint, Throwable it) {
        BreakpointListener breakpointListener = (BreakpointListener)this$0.dispatcher.getMulticaster();
        Breakpoint breakpoint = $breakpoint;
        String string = it.getMessage();
        if (string == null) {
            string = it.toString();
        }
        breakpointListener.errorOccurred(breakpoint, string);
        return Unit.INSTANCE;
    }

    private static final void setBreakpoint$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Promise setBreakpoint$lambda$2(BreakpointManagerBase this$0, BreakpointTarget $target, Url $url, BreakpointBase $breakpoint) {
        Promise promise2 = this$0.doSetBreakpoint($target, $url, $breakpoint).onError(arg_0 -> BreakpointManagerBase.setBreakpoint$lambda$2$lambda$1(arg_0 -> BreakpointManagerBase.setBreakpoint$lambda$2$lambda$0(this$0, $breakpoint, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)promise2, (String)"null cannot be cast to non-null type org.jetbrains.concurrency.Promise<org.jetbrains.debugger.Breakpoint>");
        return promise2;
    }

    private static final Promise setBreakpoint$lambda$3(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise remove$lambda$4(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }
}

