"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Servers = void 0;
var react_1 = __importDefault(require("react"));
var Server_1 = require("./Server");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var Servers = function () {
    var servers = (0, contexts_1.useSpec)().servers();
    var config = (0, contexts_1.useConfig)();
    if (!Object.keys(servers).length) {
        return null;
    }
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('servers', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.SERVERS_TEXT),
        react_1.default.createElement("ul", null, Object.entries(servers).map(function (_a) {
            var serverName = _a[0], server = _a[1];
            return (react_1.default.createElement("li", { className: "mb-4", key: serverName, id: "".concat(helpers_1.CommonHelpers.getIdentifier("server-".concat(serverName), config)) },
                react_1.default.createElement(Server_1.Server, { serverName: serverName, server: server, key: serverName })));
        }))));
};
exports.Servers = Servers;
//# sourceMappingURL=Servers.js.map