.TH XScreenSaver 1 "25-Aug-2008" "X Version 11"
.SH NAME
jigsaw \- permute an image like a jigsaw puzzle
.SH SYNOPSIS
.B jigsaw
[\-\-display \fIhost:display.screen\fP]
[\-\-delay \fIusecs\fP]
[\-\-speed \fIratio\fP]
[\-\-complexity \fIratio\fP]
[\-\-resolution \fIint\fP]
[\-\-thickness \fIfloat\fP]
[\-\-no\-wobble]
[\-\-fps]
[\-\-visual \fIvisual\fP]
[\-\-window]
[\-\-root]
[\-\-window\-id \fInumber\fP]
.SH DESCRIPTION
The \fIjigsaw\fP program loads an image, carves it up into
a jigsaw puzzle, shuffles it, and then solves it.

The image that it manipulates will be grabbed from the portion of
the screen underlying the window, or from the system's video input,
or from a random file on disk, as indicated by
the \fIgrabDesktopImages\fP, \fIgrabVideoFrames\fP,
and \fIchooseRandomImages\fP options in the \fI~/.xscreensaver\fP
file; see
.BR xscreensaver\-settings (1)
for more details.
.SH OPTIONS
.I jigsaw
accepts the following options:
.TP 8
.B \-\-delay \fImicroseconds\fP
How long to wait between animation frames; default 20000.
.TP 8
.B \-\-speed \fIratio\fP
Less than 1 for slower, greater than 1 for faster.  Default 1.
.TP 8
.B \-\-complexity \fIratio\fP
Less than 1 for simpler puzzles (fewer pieces), greater than 1 for
more complex puzzles (more pieces).  Default 1.
.TP 8
.B \-\-resolution \fIratio\fP
Smoothness of the edges of the pieces.  Less than 1 for rougher pieces
(fewer polygons), greater than 1 for more smoother pieces (more polygons).
Default 1.
.TP 8
.B \-\-thickness \fIfloat\fP
Thickness of the puzzle pieces (relative to their width).
Default 0.06.
.TP 8
.B \-\-no\-wobble
Keep the display stationary instead of very slowly wobbling back and forth.
.TP 8
.B \-\-fps
Display the current frame rate, polygon count, and CPU load.
.TP 8
.B \-\-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-\-root
Draw on the root window.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-install
Install a private colormap for the window.
.TP 8
.B \-\-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xscreensaver\-settings (1),
.BR xscreensaver\-getimage (MANSUFFIX)
.SH COPYRIGHT
Copyright \(co 1997 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 25-Nov-97.
