/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

public class LiteralStringNode
extends Node {
    public String value;
    private static final int SINGLE_QUOTE_DELIMITER = 2;
    private static final int DOUBLE_QUOTE_DELIMITER = 1;
    private static final int OTHER_DELIMITER = 0;
    private int delimiterType;
    public boolean void_result = false;

    public boolean isSingleQuote() {
        return this.delimiterType == 2;
    }

    public boolean isDoubleQuote() {
        return this.delimiterType == 1;
    }

    public LiteralStringNode(String value) {
        this.value = value.intern();
        this.delimiterType = 0;
    }

    public LiteralStringNode(String value, boolean singleQuoted) {
        this(value, singleQuoted, true);
    }

    public LiteralStringNode(String value, boolean singleQuoted, boolean intern) {
        if (intern) {
            this.value = value.intern();
        } else {
            assert (value.intern() == value);
            this.value = value;
        }
        this.delimiterType = singleQuoted ? 2 : 1;
    }

    @Override
    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public void voidResult() {
        this.void_result = true;
    }

    @Override
    public String toString() {
        return "LiteralString";
    }
}

