// -*- mode: c++; c-file-style: "linux"; c-basic-offset: 2; indent-tabs-mode: nil -*-
//
//  Copyright (C) 2014-2018 Gunter Königsmann <wxMaxima@physikbuch.de>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
//
//  SPDX-License-Identifier: GPL-2.0+

/*!\file

  This file defines the class EventIDs that contains unique IDs for many events
  wxMaxima needs.
*/
#include "Configuration.h"
#include "EventIDs.h"
#include <wx/utils.h>
#include <wx/window.h>
const wxWindowIDRef EventIDs::menu_pane_hideall(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_math(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_history(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_structure(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_xmlInspector(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_format(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_greek(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_unicode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_variables(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_draw(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_help(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_symbols(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_stats(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_wizard(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_toolbar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_console(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pane_dockAll(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::input_line_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::refresh_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_batch_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_load_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sconsole_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_interrupt_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve_to_poly(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve_num(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_allroots(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_bfallroots(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_realroots(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve_lin(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve_algsys(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_eliminate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve_ode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_ivp_1(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_ivp_2(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rk(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_bvp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_genmatrix(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_gen_mat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_gen_mat_lambda(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_enter_mat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_csv2mat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_mat2csv(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_csv2list(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list2csv(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_row(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_col(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_row_list(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_col_list(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_submatrix(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_multiply(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_exponent(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_hadamard_product(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_hadamard_exponent(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_loadLapack(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dgeev_eigenvaluesOnly(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dgeev(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zgeev_eigenvaluesOnly(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zgeev(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dgeqrf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dgesv(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dgesvd(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dgesvd_valuesOnly(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dlange_max(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dlange_one(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dlange_inf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_dlange_frobenius(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zlange_max(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zlange_one(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zlange_inf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zlange_frobenius(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_matrix_zheev(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_invert_mat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_cpoly(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_determinant(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rank(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_eigen(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_eigvect(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_fun_def(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_gensym(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_adjoint_mat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_transpose(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_map_mat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_map(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_map_lambda(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copymatrix(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_ratsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_radsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_scanmapfactor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_factor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_horner(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_collapse(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_optimize(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_mainvar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_grind(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_gfactor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_expand(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_expandwrt(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_expandwrt_denom(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_setposition(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_getposition(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_flush_output(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_flength(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_close(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_opena(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_openr(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_openw(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_printf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_readline(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_readchar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_readbyte(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_writebyte(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_charp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_alphacharp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_alphanumericp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_digitcharp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_constituent(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_uppercasep(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_lowercasep(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_create_ascii(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_cequal(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_cequalignore(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_clessp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_clesspignore(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_cgreaterp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_cgreaterpignore(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sequal(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sequalignore(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_ascii(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_cint(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_unicode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_unicode_to_utf8(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_utf8_to_unicode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_charat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_charlist(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_simplode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sinsert(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_eval_string(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_parse_string(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_scopy(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sdowncase(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_slength(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_smake(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_smismatch(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_split(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sposition(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sremove(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_sremovefirst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_tokens(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_ssearch(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_ssort(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_ssubstfirst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_strim(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_striml(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_strimr(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_number_to_octets(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_octets_to_number(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_octets_to_string(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringproc_string_to_octets(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_load(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_regex_compile(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_regex_match_pos(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_regex_match(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_regex_split(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_subst_first(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_regex_subst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sregex_string_to_regex(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_load(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_chdir(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_mkdir(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_rmdir(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_getcurrentdirectory(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_copy_file(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_rename_file(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_delete_file(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_getenv(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_directory(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_pathname_directory(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_pathname_name(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsyst_pathname_type(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_scsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_xthru(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_talg(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_tellrat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_modulus(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_trigsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_trigreduce(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_trigexpand(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_trigrat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rectform(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_polarform(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_demoivre(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_exponentialize(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_num_out(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringdisp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_to_float(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_to_bfloat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_to_numer(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rationalize(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_guess_exact_value(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qag(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qags(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qagi(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qawc(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qawf_sin(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qawf_cos(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qawo_sin(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qawo_cos(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qaws1(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qaws2(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qaws3(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qaws4(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quad_qagp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_num_domain(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_set_precision(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_set_displayprecision(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_engineeringFormat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_engineeringFormatSetup(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_functions(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_variables(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_arrays(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_macros(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_labels(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_myoptions(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rules(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_aliases(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_structs(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_dependencies(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_gradefs(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_let_rule_packages(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_wxmaxima_uses_help_sidebar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_wxmaxima_uses_help_browser(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_maxima_uses_internal_help(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_maxima_uses_html_help(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_maxima_uses_wxmaxima_help(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_goto_url(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_clear_var(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_clear_fun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_integrate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_risch(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_laplace(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_ilt(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_continued_fraction(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_gcd(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_lcm(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_divide(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_partfrac(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_sum(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_simpsum(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_limit(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_lbfgs(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_taylor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_powerseries(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_fourier(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_pade(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_diff(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_solve_de(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_atvalue(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_lhs(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_rhs(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_wxmaximahelp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_maximahelp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_example(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_apropos(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_product(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_time(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_factsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_factcomb(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_realpart(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_imagpart(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_subst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_psubst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_ratsubst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_fullratsubst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_at(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_substinpart(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_opsubst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_jumptoerror(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_math_as_1D_ASCII(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_math_as_2D_ASCII(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_math_as_2D_UNICODE(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_math_as_graphics(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::internalRepresentation(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wxMathML(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_logexpand_false(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_logexpand_true(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_logexpand_all(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_logexpand_super(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_noAutosubscript(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_defaultAutosubscript(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_alwaysAutosubscript(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_autosubscriptIndividual(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_declareAutosubscript(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_noAutosubscriptIndividual(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_roundedMatrixParens(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_squareMatrixParens(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_straightMatrixParens(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_angledMatrixParens(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_noMatrixParens(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_2d(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_3d(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_explicit(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_implicit(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_parametric(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_points(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_fgcolor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_fillcolor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_title(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_key(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_grid(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_axis(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_accuracy(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_draw_contour(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_license(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_changelog(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_factor_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_solve(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_solve_ode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_limit(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_taylor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_expand(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_ratsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_radcan(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_trigsimp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_trigexpand(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_trigreduce(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_trigrat(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_integrate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_diff(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_sum(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_product(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_button_constant(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_factor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_subst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_plot2(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_plot3(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_rectform(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_map(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gp_plot2(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gp_plot3(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_animationautostart(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_animationframerate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_display(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_soft_restart(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_dependencies(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_values(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_functions(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_arrays(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_myoptions(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_rules(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_aliases(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_structures(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_labels(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_gradefs(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_props(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_macros(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_kill_let_rule_packages(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_garbage_collect(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_room(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_plot_format(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_build_info(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_bug_report(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_path(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_evaluate_all_visible(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_evaluate_all(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_show_tip(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_show_cellbrackets(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_print_cellbrackets(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_matlab_from_worksheet(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_tex_from_worksheet(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_text_from_worksheet(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_logcontract(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_logexpand(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_to_fact(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_to_gamma(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_texform(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_debugmode(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_debugmode_off(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_debugmode_lisp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_debugmode_all(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_for(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_while(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_block(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_block_noLocal(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_local(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_return(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_trace(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_lambda(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quotequote(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quote(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_quoteblock(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_def_fun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_def_macro(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_def_variable(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_compile(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_paramType(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_structdef(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_structnew(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_structuse(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_saveLisp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_loadLisp(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_maximatostring(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stringtomaxima(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::button_enter(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_zoom_80(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_zoom_120(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_zoom_150(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_zoom_200(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_zoom_300(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_as_bitmap(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_as_svg(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_save_as_svg(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_as_emf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_save_as_emf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_as_rtf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_copy_to_file(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_export_html(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_change_var(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_change_var_evaluate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_nouns(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_evaluate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_code(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_comment(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_comment(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_subsubsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_heading5(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_heading6(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_subsubsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_heading5(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_heading6(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_subsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_subsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_section(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_section(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_title(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_convert_to_title(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_add_pagebreak(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_fold_all_cells(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_unfold_all_cells(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_insert_input(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_insert_previous_input(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_insert_previous_output(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_autocomplete(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_autocomplete_templates(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_paste_input(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_fullscreen(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_show_logwindow(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_remove_output(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_create_from_elements(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_create_from_rule(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_create_from_list(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_create_from_args(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_list2matrix(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_matrix2list(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_actual_values_storage(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_sort(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_remove_duplicates(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_length(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_push(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_pop(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_reverse(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_first(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_last(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_lastn(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_rest(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_restN(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_nth(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_map(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_use_actual_values(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_extract_value(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_as_function_arguments(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_do_for_each_element(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_remove_element(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_append_item_start(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_append_item_end(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_append_list(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_list_interleave(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_recent_packages(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_recent_package_0(wxWindow::NewControlId(NumberOfRecentFiles));
const wxWindowIDRef EventIDs::menu_unsaved_documents(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_recent_document_0(wxWindow::NewControlId(NumberOfRecentFiles));
const wxWindowIDRef EventIDs::menu_recent_documents(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_unsaved_document_0(wxWindow::NewControlId(NumberOfRecentFiles));
const wxWindowIDRef EventIDs::menu_construct_fraction(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_insert_image(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_mean(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_median(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_var(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_dev(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_tt1(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_tt2(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_tnorm(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_linreg(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_lsquares(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_histogram(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_scatterplot(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_barsplot(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_piechart(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_boxplot(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_readm(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_enterm(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_stats_subsample(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_code(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_text(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_heading6(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_heading5(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_subsubsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_subsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_section(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_title(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_image(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_format_pagebreak(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_tutorials(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_maxima_homepage(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_demo_for_command(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_tutorials_start(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_solving(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_casvsprogramming(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_diffequations(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_numberformats(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_tolerances(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_listaccess(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_memoizing(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_2d(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_3d(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_varnames(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_fittingData(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_help_tutorials_end(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_regex_isRegex(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_regex_isTextSearch(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_history_previous(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_history_next(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_check_updates(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gentran_load(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gentran_lang_c(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gentran_lang_fortran(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gentran_lang_ratfor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gentran_to_stdout(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gentran_to_file(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::socket_client_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::socket_server_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::gnuplot_query_terminals_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_additionalSymbols(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::enable_unicodePane(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_showLatinGreekLookalikes(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_showGreekMu(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::menu_invertWorksheetBackground(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_comment_selection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_divide_cell(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_image(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_animation(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_svg(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_emf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_rtf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_add_watch(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_add_watch_label(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_special_constant_percent(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_changeasterisk(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_hideasterisk(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_delete(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_simplify(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_expand(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_factor(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_solve(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_solve_num(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_integrate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_diff(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_subst(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_plot2d(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_plot3d(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_float(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_edit(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_add_comment(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_input(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_matlab(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_tex(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_text(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_copy_mathml(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_labels_disable(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_labels_user(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_labels_useronly(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_labels_autogenerated(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_inputlabels_hide(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_labelwidth(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_labelwidth1(wxWindow::NewControlId(LABELWIDTH_MAX - LABELWIDTH_MIN));
const wxWindowIDRef EventIDs::popid_digits_20(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_digits_50(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_digits_100(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_digits_all(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_digits_all_linebreak(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_image(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_change_image(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_svg(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_emf(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_animation_save(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_animation_start(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_evaluate(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_evaluate_section(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_merge_cells(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_text(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_title(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_section(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_subsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_subsubsection(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_heading5(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_insert_heading6(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_auto_answer(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_autocomplete_keyword1(wxWindow::NewControlId(NumberOfAutocompleteKeywords));
const wxWindowIDRef EventIDs::popid_never_autoanswer(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_popup_gnuplot(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_fold(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_unfold(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_maxsizechooser(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_resolutionchooser(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_reloadimage(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_hide_tooltipMarker(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_hide_tooltipMarkerForThisMessage(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_real(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_imaginary(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_complex(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_additive(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_alphabetic(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_bindtest(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_antisymmetric(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_commutative(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_symmetric(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_constant(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_even(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_odd(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_evenfun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_oddfun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_increasing(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_decreasing(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_integer(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_noninteger(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_integervalued(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_lassociative(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_rassociative(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_linear(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_mainvar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_multiplicative(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_nary(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_nonarray(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_nonscalar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_scalar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_noun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_outative(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_posfun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_rational(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_irrational(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_greaterThan(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_evfun(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_evflag(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_property_atvalue(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_Fold(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_Unfold(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_SelectTocChapter(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_EvalTocChapter(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_ToggleTOCshowsSectionNumbers(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_tocLevel1(wxWindow::NewControlId(NumberOfTocLevels));
const wxWindowIDRef EventIDs::popid_tocdnd(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_tocMoveIn(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_tocMoveOut(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_var_newVar(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_var_addAll(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::popid_addToSymbols(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wizard_parametric_plot(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wizard_discrete_plot(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wizard_special_from(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wizard_special_to(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wizard_definite_id(wxWindow::NewControlId());
const wxWindowIDRef EventIDs::wizard_numeric_id(wxWindow::NewControlId());

EventIDs::EventIDs()
{
}
