%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x3FF0000000000000", "0x3FF0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0x4000000000000000", "0x4000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2":  ["0x4008000000000000", "0x4008000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x4010000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x3FF0000000000000", "0x3FF0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x4000000000000000", "0x4000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0x4008000000000000", "0x4008000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x4010000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000"],
    "XMM9":  ["0x4000000000000000", "0x4000000000000000", "0x4000000000000000", "0x4000000000000000"],
    "XMM10": ["0x4008000000000000", "0x4008000000000000", "0x4008000000000000", "0x4008000000000000"],
    "XMM11": ["0x4010000000000000", "0x4010000000000000", "0x4010000000000000", "0x4010000000000000"],
    "XMM12": ["0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000"],
    "XMM13": ["0x4000000000000000", "0x4000000000000000", "0x4000000000000000", "0x4000000000000000"],
    "XMM14": ["0x4008000000000000", "0x4008000000000000", "0x4008000000000000", "0x4008000000000000"],
    "XMM15": ["0x4010000000000000", "0x4010000000000000", "0x4010000000000000", "0x4010000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]
vmovapd ymm4, [rdx + 32 * 4]
vmovapd ymm5, [rdx + 32 * 4]
vmovapd ymm6, [rdx + 32 * 4]
vmovapd ymm7, [rdx + 32 * 4]
vmovapd ymm8, [rdx + 32 * 0]
vmovapd ymm9, [rdx + 32 * 1]
vmovapd ymm10, [rdx + 32 * 2]
vmovapd ymm11, [rdx + 32 * 3]

; 128-bit registers
vsqrtpd xmm0, xmm0
vsqrtpd xmm1, xmm1
vsqrtpd xmm2, xmm2
vsqrtpd xmm3, xmm3

; 256-bit registers
vsqrtpd ymm8, ymm8
vsqrtpd ymm9, ymm9
vsqrtpd ymm10, ymm10
vsqrtpd ymm11, ymm11

; 128-bit memory operand
vsqrtpd xmm4, [rdx + 32 * 0]
vsqrtpd xmm5, [rdx + 32 * 1]
vsqrtpd xmm6, [rdx + 32 * 2]
vsqrtpd xmm7, [rdx + 32 * 3]

; 256-bit memory operand
vsqrtpd ymm12, [rdx + 32 * 0]
vsqrtpd ymm13, [rdx + 32 * 1]
vsqrtpd ymm14, [rdx + 32 * 2]
vsqrtpd ymm15, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x3FF0000000000000 ; 1.0
dq 0x3FF0000000000000
dq 0x3FF0000000000000
dq 0x3FF0000000000000

dq 0x4010000000000000 ; 4.0
dq 0x4010000000000000
dq 0x4010000000000000
dq 0x4010000000000000

dq 0x4022000000000000 ; 9.0
dq 0x4022000000000000
dq 0x4022000000000000
dq 0x4022000000000000

dq 0x4030000000000000 ; 16.0
dq 0x4030000000000000
dq 0x4030000000000000
dq 0x4030000000000000

dq 0x4039000000000000 ; 25.0
dq 0x4039000000000000
dq 0x4039000000000000
dq 0x4039000000000000
