/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.events.root;

import org.apiguardian.api.API;
import org.opentest4j.reporting.events.api.Context;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;

import java.time.Instant;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * The {@code reported} element of the events namespace.
 *
 * @since 0.1.0
 */
@API(status = EXPERIMENTAL, since = "0.1.0")
public final class Reported extends Event {

	/**
	 * Qualified name of the {@code reported} element.
	 */
	public static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_EVENTS, "reported");

	Reported(Context context) {
		super(context, ELEMENT);
	}

	@Override
	Reported withId(String id) {
		super.withId(id);
		return this;
	}

	@Override
	Reported withTime(Instant time) {
		super.withTime(time);
		return this;
	}
}
