/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.core.converter;

import org.apiguardian.api.API;

import java.nio.file.Path;

import static org.apiguardian.api.API.Status.EXPERIMENTAL;

/**
 * Converter for event-based reports into the hierarchical format.
 *
 * @since 0.1.0
 */
@API(status = EXPERIMENTAL, since = "0.1.0")
public interface Converter {

	/**
	 * Convert the supplied event-based report into the hierarchical format.
	 *
	 * @param eventsXmlFile       the source file
	 * @param hierarchicalXmlFile the target file
	 * @throws Exception if an error occurs converting or writing to the target file
	 */
	void convert(Path eventsXmlFile, Path hierarchicalXmlFile) throws Exception;

}
