/*
 * Copyright 2021-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opentest4j.reporting.tooling.core.util;

import org.junit.jupiter.api.Test;
import org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.schema.QualifiedName;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import static org.junit.jupiter.api.Assertions.*;

class DomUtilsTest {

	@Test
	void matchesCompatibleNamespaces() {
		assertAll( //
			() -> assertTrue(DomUtils.matches(QualifiedName.of(Namespace.of("https://foo/1.2.3"), "a"),
				element("https://foo/1.2", "a"))), //
			() -> assertTrue(DomUtils.matches(QualifiedName.of(Namespace.of("https://foo/1.2.3"), "a"),
				element("https://foo/1.2.3", "a"))), //
			() -> assertFalse(DomUtils.matches(QualifiedName.of(Namespace.of("https://foo/1.2.3"), "a"),
				element("https://foo/1.2.3", "b"))), //
			() -> assertFalse(DomUtils.matches(QualifiedName.of(Namespace.of("https://foo/1.2.3"), "a"),
				element("https://foo/1.2.4", "a"))), //
			() -> assertFalse(DomUtils.matches(QualifiedName.of(Namespace.of("https://foo/1.2.3"), "a"),
				element("https://bar/1.2.3", "a"))) //
		);
	}

	private static Element element(String namespaceURI, String qualifiedName) throws ParserConfigurationException {
		return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createElementNS(namespaceURI,
			qualifiedName);
	}
}
