%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM2":  ["0x41DEADBEEFBAD0DA", "0x0041414141414141", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x41BEEFDEADFAD0CA", "0x0041414141414141", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x41DEADBEEFBAD0DA", "0x0041414141414141", "0x41DEADBEEFBAD0DA", "0x0041414141414141"],
    "XMM5":  ["0x41BEEFDEADFAD0CA", "0x0041414141414141", "0x41DEADBEEFBAD0DA", "0x0041414141414141"],
    "XMM6":  ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x4141414141414141", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0x4141414141414141", "0x0000000000000000", "0x4141414141414141", "0x0000000000000000"],
    "XMM10": ["0xDEADBEEFBAD0DAD1", "0x4141414141414141", "0x0000000000000000", "0x0000000000000000"],
    "XMM11": ["0xBEEFDEADFAD0CAD1", "0x4141414141414141", "0xDEADBEEFBAD0DAD1", "0x4141414141414141"]
  }
}
%endif

lea rdx, [rel .data]

vmovaps ymm0, [rdx]
vmovaps ymm1, [rdx + 32]

vpsrldq xmm2, xmm0, 1
vpsrldq xmm3, xmm1, 1
vpsrldq ymm4, ymm0, 1
vpsrldq ymm5, ymm1, 1

vpsrldq xmm6, xmm0, 16
vpsrldq ymm7, ymm1, 16

vpsrldq xmm8, xmm0, 8
vpsrldq ymm9, ymm1, 8

vpsrldq xmm10, xmm0, 0
vpsrldq ymm11, ymm1, 0

hlt

align 32
.data:
dq 0xDEADBEEFBAD0DAD1
dq 0x4141414141414141
dq 0xDEADBEEFBAD0DAD1
dq 0x4141414141414141

dq 0xBEEFDEADFAD0CAD1
dq 0x4141414141414141
dq 0xDEADBEEFBAD0DAD1
dq 0x4141414141414141
