/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.cts.registry.AbstractProjRegistry;
import org.cts.registry.Registry;
import org.cts.registry.RegistryException;

public class ESRIRegistry
extends AbstractProjRegistry
implements Registry {
    static final Pattern ESRI_REGEX = Pattern.compile("\\s+|no_defs <>");

    @Override
    public String getRegistryName() {
        return "esri";
    }

    @Override
    public Map<String, String> getParameters(String code) throws RegistryException {
        try {
            return this.projParser.readParameters(code, ESRI_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the ESRI registry", ex);
        }
    }

    @Override
    public Set<String> getSupportedCodes() throws RegistryException {
        try {
            return this.projParser.getSupportedCodes(ESRI_REGEX);
        }
        catch (IOException ex) {
            throw new RegistryException("Cannot load the ESRI registry", ex);
        }
    }
}

