/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.json.psi.JsonFile;
import com.intellij.micronaut.config.Caching;
import com.intellij.micronaut.config.MnConfigKeyDeclarationPsiElement;
import com.intellij.micronaut.config.MnMetaConfigKey;
import com.intellij.microservices.jvm.config.ConfigKeyDocumentationProviderBase;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.microservices.jvm.config.utils.MetaConfigFileUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00140\u0013J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0011\u001a\u00020\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J8\u0010 \u001a\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010$\u0018\u00010!2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010$H\u0002J8\u0010(\u001a\u0018\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010$\u0018\u00010!2\u0006\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010)\u001a\u00020\u0010H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/micronaut/config/MnConfigurationMetadataParser;", "", "jsonPsiFile", "Lcom/intellij/json/psi/JsonFile;", "<init>", "(Lcom/intellij/json/psi/JsonFile;)V", "localModule", "Lcom/intellij/openapi/module/Module;", "localJsonFile", "Ljava/io/File;", "(Lcom/intellij/openapi/module/Module;Ljava/io/File;)V", "libraryName", "", "caching", "Lcom/intellij/micronaut/config/Caching;", "processKeys", "", "module", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "processExtraMetadataKeys", "", "findR2dbcUrlKeyIfExists", "Lcom/intellij/micronaut/config/MnMetaConfigKey;", "openReader", "Lcom/google/gson/stream/JsonReader;", "pathRef", "Lcom/intellij/openapi/util/Ref;", "parseProperty", "property", "Lcom/google/gson/JsonObject;", "getDeclaration", "Lkotlin/Triple;", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$DeclarationResolveResult;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiType;", "entry", "configKeyName", "type", "getFallbackDeclaration", "unresolvedSourceTypeClass", "Companion", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnConfigurationMetadataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnConfigurationMetadataParser.kt\ncom/intellij/micronaut/config/MnConfigurationMetadataParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1232#2,2:258\n1#3:260\n*S KotlinDebug\n*F\n+ 1 MnConfigurationMetadataParser.kt\ncom/intellij/micronaut/config/MnConfigurationMetadataParser\n*L\n156#1:258,2\n*E\n"})
public final class MnConfigurationMetadataParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final JsonFile jsonPsiFile;
    @Nullable
    private final File localJsonFile;
    @NotNull
    private final String libraryName;
    @NotNull
    private Caching caching;
    @NotNull
    private static final String PROPERTIES = "properties";
    @NotNull
    private static final String NAME = "name";
    @NotNull
    private static final String SOURCE_TYPE = "sourceType";
    @NotNull
    private static final String TYPE = "type";
    @NotNull
    private static final String DESCRIPTION = "description";
    @NotNull
    private static final String DEFAULT_VALUE = "defaultValue";
    @NotNull
    private static final String UNKNOWN_LIBRARY_NAME = "<unknown>";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Pair<PsiType, MetaConfigKey.AccessType> DUMMY_TYPE;

    public MnConfigurationMetadataParser(@NotNull JsonFile jsonPsiFile) {
        Intrinsics.checkNotNullParameter((Object)jsonPsiFile, (String)"jsonPsiFile");
        this.jsonPsiFile = jsonPsiFile;
        this.localJsonFile = null;
        Project project = jsonPsiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = jsonPsiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        String string = MetaConfigFileUtilsKt.getLibraryOrContainingJarName((Project)project, (VirtualFile)virtualFile);
        if (string == null) {
            string = UNKNOWN_LIBRARY_NAME;
        }
        this.libraryName = string;
        GlobalSearchScope globalSearchScope = jsonPsiFile.getResolveScope();
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
        this.caching = new Caching(globalSearchScope);
    }

    public MnConfigurationMetadataParser(@NotNull Module localModule, @NotNull File localJsonFile) {
        Intrinsics.checkNotNullParameter((Object)localModule, (String)"localModule");
        Intrinsics.checkNotNullParameter((Object)localJsonFile, (String)"localJsonFile");
        this.jsonPsiFile = null;
        this.localJsonFile = localJsonFile;
        String string = localModule.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.libraryName = string;
        GlobalSearchScope globalSearchScope = localModule.getModuleRuntimeScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleRuntimeScope(...)");
        this.caching = new Caching(globalSearchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean processKeys(@NotNull Module module, @NotNull Processor<? super MetaConfigKey> processor2) {
        boolean bl;
        block13: {
            void $this$all$iv;
            Closeable closeable;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            Ref ref = Ref.create();
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
            Ref path = ref;
            try {
                JsonReader reader;
                closeable = (Closeable)this.openReader((Ref<String>)path);
                Throwable throwable = null;
                try {
                    reader = (JsonReader)closeable;
                    boolean bl2 = false;
                    reader.setLenient(true);
                    JsonElement parse = JsonParser.parseReader((JsonReader)reader);
                    if (!parse.isJsonObject()) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    reader = parse.getAsJsonObject();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                closeable = reader;
            }
            catch (ProcessCanceledException ignored) {
                return true;
            }
            catch (Throwable e) {
                LOG.info("Error parsing Spring Boot metadata JSON from " + path.get(), e);
                return true;
            }
            Closeable rootObject = closeable;
            JsonElement jsonElement = rootObject.get(PROPERTIES);
            if (jsonElement == null) {
                return true;
            }
            JsonElement propertiesElement = jsonElement;
            JsonArray jsonArray = propertiesElement.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Sequence e = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)jsonArray)), arg_0 -> MnConfigurationMetadataParser.processKeys$lambda$1(this, module, arg_0));
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                MetaConfigKey it = (MetaConfigKey)element$iv;
                boolean bl4 = false;
                if (processor2.process((Object)it)) continue;
                bl = false;
                break block13;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public final List<MetaConfigKey> processExtraMetadataKeys(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        MnMetaConfigKey mnMetaConfigKey = this.findR2dbcUrlKeyIfExists(module);
        if (mnMetaConfigKey == null) {
            return CollectionsKt.emptyList();
        }
        MnMetaConfigKey r2dbcKey = mnMetaConfigKey;
        return CollectionsKt.listOf((Object)((Object)r2dbcKey));
    }

    private final MnMetaConfigKey findR2dbcUrlKeyIfExists(Module module) {
        if (!StringsKt.contains$default((CharSequence)this.libraryName, (CharSequence)"io.micronaut.r2dbc", (boolean)false, (int)2, null)) {
            return null;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair pair = MnConfigurationMetadataParser.Companion.getPsiTypeToAccessType(project, "java.lang.String");
        PsiType type = (PsiType)pair.component1();
        MetaConfigKey.AccessType accessType = (MetaConfigKey.AccessType)pair.component2();
        PsiClass psiClass = this.caching.getCachedClasses().get("io.micronaut.r2dbc.DefaultBasicR2dbcProperties");
        if (psiClass == null) {
            return null;
        }
        PsiClass sourceTypeClass = psiClass;
        PsiMethod[] psiMethodArray = sourceTypeClass.findMethodsByName("newConnectionFactoryOptionsBuilder", false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        PsiMethod psiMethod = (PsiMethod)ArraysKt.firstOrNull((Object[])psiMethodArray);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod method = psiMethod;
        String configKeyName = "r2dbc.datasources.*.url";
        PsiElement psiElement = (PsiElement)sourceTypeClass;
        PsiElement psiElement2 = (PsiElement)method;
        String string = sourceTypeClass.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        MnConfigKeyDeclarationPsiElement declaration = new MnConfigKeyDeclarationPsiElement(this.libraryName, psiElement, psiElement2, configKeyName, string, type);
        return new MnMetaConfigKey((PsiElement)declaration, MetaConfigKey.DeclarationResolveResult.PROPERTY, configKeyName, new MetaConfigKey.DescriptionText("Sets r2dbc url"), null, type, accessType);
    }

    private final JsonReader openReader(Ref<String> pathRef) {
        JsonReader jsonReader;
        if (this.jsonPsiFile != null) {
            VirtualFile file = this.jsonPsiFile.getVirtualFile();
            pathRef.set((Object)file.getPath());
            String string = VfsUtilCore.loadText((VirtualFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String content = string;
            jsonReader = new JsonReader((Reader)new CharSequenceReader((CharSequence)content));
        } else {
            boolean bl;
            boolean bl2 = bl = this.localJsonFile != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            File file = this.localJsonFile;
            Intrinsics.checkNotNull((Object)file);
            pathRef.set((Object)file.getPath());
            jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.localJsonFile)), StandardCharsets.UTF_8));
        }
        return jsonReader;
    }

    private final MetaConfigKey parseProperty(JsonObject property, Module module) {
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        String configKeyName = MnConfigurationMetadataParser.Companion.getStringLiteral(property, NAME);
        CharSequence charSequence = configKeyName;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String it = MnConfigurationMetadataParser.Companion.getStringLiteral(property, TYPE);
        boolean bl = false;
        String typeLiteral = Intrinsics.areEqual((Object)"java.util.Properties", (Object)it) ? "java.util.Map<java.lang.String,java.lang.String>" : it;
        Project project2 = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Pair typeWithAccess = MnConfigurationMetadataParser.Companion.getPsiTypeToAccessType(project2, typeLiteral);
        PsiType type = Intrinsics.areEqual((Object)typeWithAccess.getFirst(), (Object)DUMMY_TYPE.getFirst()) ? null : (PsiType)typeWithAccess.getFirst();
        Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> triple = this.getDeclaration(property, configKeyName, type);
        if (triple == null) {
            return null;
        }
        Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> declaration = triple;
        if (declaration.getThird() != null) {
            type = (PsiType)declaration.getThird();
        }
        ((PsiElement)declaration.getSecond()).putUserData(ConfigKeyDocumentationProviderBase.CONFIG_KEY_DECLARATION_MODULE, (Object)module);
        PsiElement psiElement = (PsiElement)declaration.getSecond();
        MetaConfigKey.DeclarationResolveResult declarationResolveResult = (MetaConfigKey.DeclarationResolveResult)declaration.getFirst();
        String string = RelaxedNames.camelCaseToHyphen((String)configKeyName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"camelCaseToHyphen(...)");
        return (MetaConfigKey)new MnMetaConfigKey(psiElement, declarationResolveResult, string, MnConfigurationMetadataParser.Companion.getDescription(property), MnConfigurationMetadataParser.Companion.getValueAsString(property, DEFAULT_VALUE), type, (MetaConfigKey.AccessType)typeWithAccess.getSecond());
    }

    private final Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> getDeclaration(JsonObject entry, String configKeyName, PsiType type) {
        String sourceTypeText = MnConfigurationMetadataParser.Companion.getStringLiteral(entry, SOURCE_TYPE);
        CharSequence charSequence = sourceTypeText;
        if (charSequence == null || charSequence.length() == 0) {
            return this.getFallbackDeclaration(configKeyName, type, false);
        }
        PsiClass psiClass = this.caching.getCachedClasses().get(sourceTypeText);
        if (psiClass == null) {
            return this.getFallbackDeclaration(configKeyName, type, true);
        }
        PsiClass sourceTypeClass = psiClass;
        Pair target = MnConfigurationMetadataParser.Companion.findPropertyNavigationTarget(sourceTypeClass, configKeyName);
        return new Triple((Object)MetaConfigKey.DeclarationResolveResult.PROPERTY, (Object)new MnConfigKeyDeclarationPsiElement(this.libraryName, (PsiElement)sourceTypeClass, (PsiElement)target.getFirst(), configKeyName, sourceTypeText, type), target.getSecond());
    }

    private final Triple<MetaConfigKey.DeclarationResolveResult, PsiElement, PsiType> getFallbackDeclaration(String configKeyName, PsiType type, boolean unresolvedSourceTypeClass) {
        if (this.jsonPsiFile == null) {
            return null;
        }
        MetaConfigKey.DeclarationResolveResult declarationResolveResult = unresolvedSourceTypeClass ? MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE : MetaConfigKey.DeclarationResolveResult.JSON;
        MnConfigKeyDeclarationPsiElement declarationElement = new MnConfigKeyDeclarationPsiElement(this.libraryName, (PsiElement)this.jsonPsiFile, (PsiElement)this.jsonPsiFile, configKeyName, configKeyName, type);
        return new Triple((Object)declarationResolveResult, (Object)declarationElement, null);
    }

    private static final MetaConfigKey processKeys$lambda$1(MnConfigurationMetadataParser this$0, Module $module, JsonElement it) {
        JsonObject jsonObject = it.getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
        return this$0.parseProperty(jsonObject, $module);
    }

    static {
        Logger logger = Logger.getInstance(MnConfigurationMetadataParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        DUMMY_TYPE = new Pair((Object)PsiTypes.nullType(), (Object)MetaConfigKey.AccessType.NORMAL);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J&\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J&\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/micronaut/config/MnConfigurationMetadataParser$Companion;", "", "<init>", "()V", "PROPERTIES", "", "NAME", "SOURCE_TYPE", "TYPE", "DESCRIPTION", "DEFAULT_VALUE", "UNKNOWN_LIBRARY_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "DUMMY_TYPE", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiType;", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;", "getDescription", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$DescriptionText;", "property", "Lcom/google/gson/JsonObject;", "getStringLiteral", "jsonObject", "propertyName", "getValueAsString", "findPropertyNavigationTarget", "Lcom/intellij/psi/PsiElement;", "sourceTypeClass", "Lcom/intellij/psi/PsiClass;", "configKeyName", "getPsiTypeToAccessType", "project", "Lcom/intellij/openapi/project/Project;", "type", "intellij.micronaut"})
    @SourceDebugExtension(value={"SMAP\nMnConfigurationMetadataParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnConfigurationMetadataParser.kt\ncom/intellij/micronaut/config/MnConfigurationMetadataParser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final MetaConfigKey.DescriptionText getDescription(JsonObject property) {
            MetaConfigKey.DescriptionText descriptionText;
            String descriptionText2;
            String string = descriptionText2 = this.getStringLiteral(property, MnConfigurationMetadataParser.DESCRIPTION);
            if (string != null) {
                String it = string;
                boolean bl = false;
                descriptionText = new MetaConfigKey.DescriptionText(it);
            } else {
                MetaConfigKey.DescriptionText descriptionText3 = MetaConfigKey.DescriptionText.NONE;
                descriptionText = descriptionText3;
                Intrinsics.checkNotNullExpressionValue((Object)descriptionText3, (String)"NONE");
            }
            return descriptionText;
        }

        private final String getStringLiteral(JsonObject jsonObject, String propertyName) {
            JsonElement jsonElement = jsonObject.get(propertyName);
            return jsonElement != null ? jsonElement.getAsString() : null;
        }

        private final String getValueAsString(JsonObject jsonObject, String propertyName) {
            JsonElement jsonElement = jsonObject.get(propertyName);
            if (jsonElement == null) {
                return null;
            }
            JsonElement propertyElement = jsonElement;
            if (propertyElement.isJsonPrimitive()) {
                return propertyElement.getAsJsonPrimitive().getAsString();
            }
            if (!propertyElement.isJsonArray()) {
                return null;
            }
            JsonArray array = propertyElement.getAsJsonArray();
            List valueList = (List)new SmartList();
            Iterator iterator = array.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement jsonValue = (JsonElement)iterator2.next();
                if (!jsonValue.isJsonPrimitive()) continue;
                String string = jsonValue.getAsJsonPrimitive().getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                valueList.add(string);
            }
            return StringUtil.join((Collection)valueList, (String)", ");
        }

        private final Pair<PsiElement, PsiType> findPropertyNavigationTarget(PsiClass sourceTypeClass, String configKeyName) {
            String propertyName = RelaxedNames.dashedPropertyNameToCamelCase((String)configKeyName);
            PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false);
            if (setter != null) {
                PsiParameter psiParameter = setter.getParameterList().getParameter(0);
                Intrinsics.checkNotNull((Object)psiParameter);
                PsiType psiType = psiParameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
                PsiType type = psiType;
                return new Pair((Object)setter, (Object)type);
            }
            PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)sourceTypeClass, (String)propertyName, (boolean)false, (boolean)false, (boolean)true);
            return getter != null ? new Pair((Object)getter, (Object)getter.getReturnType()) : new Pair((Object)sourceTypeClass, null);
        }

        private final Pair<PsiType, MetaConfigKey.AccessType> getPsiTypeToAccessType(Project project, String type) {
            if (type == null) {
                return DUMMY_TYPE;
            }
            Map cachedTypes = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> Companion.getPsiTypeToAccessType$lambda$0(project));
            Pair pair = (Pair)cachedTypes.get(type);
            if (pair == null) {
                throw new IllegalStateException("cached types factory map got null value".toString());
            }
            return pair;
        }

        private static final CachedValueProvider.Result getPsiTypeToAccessType$lambda$0(Project $project) {
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)$project).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getElementFactory(...)");
            PsiElementFactory elementFactory = psiElementFactory;
            ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> Companion.getPsiTypeToAccessType$lambda$0$1(arg_0 -> Companion.getPsiTypeToAccessType$lambda$0$0(elementFactory, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
            Map factoryMap = concurrentMap;
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)factoryMap, (Object[])objectArray);
        }

        private static final Pair getPsiTypeToAccessType$lambda$0$0(PsiElementFactory $elementFactory, String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            try {
                PsiType psiType = $elementFactory.createTypeFromText(StringsKt.replace$default((String)key, (char)'$', (char)'.', (boolean)false, (int)4, null), null);
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"createTypeFromText(...)");
                PsiType psiType2 = psiType;
                return new Pair((Object)psiType2, (Object)MetaConfigKey.AccessType.forPsiType((PsiType)psiType2));
            }
            catch (IncorrectOperationException e) {
                return DUMMY_TYPE;
            }
        }

        private static final Pair getPsiTypeToAccessType$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Pair)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

