/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.datasource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.micronaut.config.datasource.MnConfigPropertyValueSearcher;
import com.intellij.micronaut.config.datasource.MnMongoDataSourcesKeyTypes;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DataSourcePropertyWithPrefixDataInfo;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.persistence.database.config.impl.CollectingDataSourceConfigProvider;
import com.intellij.persistence.database.config.impl.urlParser.CommonDatabaseUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/micronaut/config/datasource/MnMongoDataSourceConfigProvider;", "Lcom/intellij/persistence/database/config/impl/CollectingDataSourceConfigProvider;", "<init>", "()V", "getConfigs", "", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "propertyInfo", "Lcom/intellij/persistence/database/DataSourcePropertyWithPrefixDataInfo;", "intellij.micronaut"})
public final class MnMongoDataSourceConfigProvider
extends CollectingDataSourceConfigProvider {
    @NotNull
    public List<RecognizedDatabaseConfig> getConfigs(@NotNull ConfigurationFileInfo fileInfo, @NotNull DataSourcePropertyWithPrefixDataInfo propertyInfo) {
        String url;
        CommonDatabaseUrl parsed;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)propertyInfo, (String)"propertyInfo");
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)DatabaseType.MONGODB);
        if (databaseDriver == null) {
            return CollectionsKt.emptyList();
        }
        DatabaseDriver driver = databaseDriver;
        MnConfigPropertyValueSearcher valueSearcher = new MnConfigPropertyValueSearcher(fileInfo, propertyInfo.getDocumentId());
        String string = (String)this.collectValues((List)MnMongoDataSourcesKeyTypes.getEntries(), propertyInfo, valueSearcher).get((Object)MnMongoDataSourcesKeyTypes.MN_MONGO_DATA_SOURCE_URL);
        if (string == null) {
            String string2 = driver.getSampleUrl();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSampleUrl(...)");
        }
        if ((object = (parsed = DatabaseUrlParserKt.parseToCommonDatabaseUrl$default((String)(url = string), (String)propertyInfo.getKeyPrefixInfo().getDatabaseName(), null, null, (int)12, null))) == null || (object = object.toDbDialogUrl()) == null) {
            object = url;
        }
        String string3 = driver.getDriverClass();
        CommonDatabaseUrl commonDatabaseUrl = parsed;
        String string4 = commonDatabaseUrl != null ? commonDatabaseUrl.getUsername() : null;
        CommonDatabaseUrl commonDatabaseUrl2 = parsed;
        String string5 = commonDatabaseUrl2 != null ? commonDatabaseUrl2.getPassword() : null;
        Object object2 = parsed;
        if (object2 == null || (object2 = object2.dataSourceItemName()) == null) {
            CommonDatabaseUrl commonDatabaseUrl3 = parsed;
            object2 = this.guessDefaultDatasourceName(url, commonDatabaseUrl3 != null ? commonDatabaseUrl3.getHost() : null);
        }
        RecognizedDatabaseConfig config = new RecognizedDatabaseConfig((String)object, string3, string4, string5, (String)object2);
        return CollectionsKt.listOf((Object)config);
    }
}

