/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el;

import com.intellij.javaee.el.providers.ElContextProviderEx;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.el.contexts.MnElContextsExtension;
import com.intellij.micronaut.el.psi.MnELContextArray;
import com.intellij.micronaut.el.psi.MnELTypeExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MnElContextProvider
extends ElContextProviderEx {
    protected final PsiElement myHost;

    public MnElContextProvider(PsiElement host) {
        this.myHost = host;
    }

    public Iterator<? extends PsiVariable> getTopLevelElVariables(@Nullable String nameHint) {
        PsiElement psiElement = this.myHost instanceof PsiFile ? ((PsiFile)this.myHost).getOriginalFile() : this.myHost;
        return nameHint == null ? this.getAllVariables(psiElement).iterator() : this.getVariable(nameHint, psiElement);
    }

    @NotNull
    public Collection<PsiMethod> getRootMethods(@Nullable String nameHint) {
        PsiElement psiElement = this.myHost instanceof PsiFile ? ((PsiFile)this.myHost).getOriginalFile() : this.myHost;
        Collection<PsiMethod> collection = this.getAllRootMethods(psiElement);
        if (collection == null) {
            MnElContextProvider.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    protected Iterator<? extends PsiVariable> getVariable(@NotNull String nameHint, @NotNull PsiElement psiElement) {
        if (nameHint == null) {
            MnElContextProvider.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            MnElContextProvider.$$$reportNull$$$0(2);
        }
        PsiVariable contextVariable = this.findVariable(nameHint, psiElement);
        Iterator iterator = ContainerUtil.createMaybeSingletonSet((Object)contextVariable).iterator();
        if (iterator == null) {
            MnElContextProvider.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    @Nullable
    protected PsiVariable findVariable(@NotNull String nameHint, PsiElement psiElement) {
        if (nameHint == null) {
            MnElContextProvider.$$$reportNull$$$0(4);
        }
        for (MnElContextsExtension extension : MnElContextsExtension.getProviders()) {
            PsiVariable contextVariable = extension.findContextVariable(psiElement, nameHint);
            if (contextVariable == null) continue;
            return contextVariable;
        }
        return null;
    }

    @NotNull
    protected Collection<PsiVariable> getAllVariables(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MnElContextProvider.$$$reportNull$$$0(5);
        }
        SmartList vars = new SmartList();
        for (MnElContextsExtension elContextsExtension : MnElContextsExtension.getProviders()) {
            vars.addAll(elContextsExtension.getContextVariables(psiElement));
        }
        SmartList smartList = vars;
        if (smartList == null) {
            MnElContextProvider.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @NotNull
    protected Collection<PsiMethod> getAllRootMethods(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MnElContextProvider.$$$reportNull$$$0(7);
        }
        SmartList vars = new SmartList();
        for (MnElContextsExtension elContextsExtension : MnElContextsExtension.getProviders()) {
            vars.addAll(elContextsExtension.getRootMethods(psiElement));
        }
        SmartList smartList = vars;
        if (smartList == null) {
            MnElContextProvider.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    public boolean shouldProcessFields() {
        return true;
    }

    public boolean acceptMethod(@NotNull PsiMethod method, @NotNull ELExpression parentContext, @NotNull PsiElement element) {
        if (method == null) {
            MnElContextProvider.$$$reportNull$$$0(9);
        }
        if (parentContext == null) {
            MnElContextProvider.$$$reportNull$$$0(10);
        }
        if (element == null) {
            MnElContextProvider.$$$reportNull$$$0(11);
        }
        if (parentContext instanceof MnELContextArray) {
            return !method.hasModifier(JvmModifier.STATIC) && !method.hasModifier(JvmModifier.PRIVATE);
        }
        if (parentContext instanceof MnELTypeExpression) {
            return method.hasModifier(JvmModifier.STATIC) && !method.hasModifier(JvmModifier.PRIVATE);
        }
        return super.acceptMethod(method, parentContext, element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 7, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/el/MnElContextProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMethods";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/el/MnElContextProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllVariables";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllRootMethods";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 7, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

