/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.vmOptions.VMOption;
import com.intellij.execution.vmOptions.VMOptionLookupElementDecorator;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.micronaut.config.MnParametrizedConfigKeyInsertHandler;
import com.intellij.micronaut.run.MnCommandLineState;
import com.intellij.micronaut.run.MnRunConfigurationEditor;
import com.intellij.micronaut.run.MnRunConfigurationFragmentedEditor;
import com.intellij.micronaut.run.MnRunConfigurationKt;
import com.intellij.micronaut.run.MnRunConfigurationOptions;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.properties.AutoPopupTailTypes;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerRunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0014J\n\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0012\u0010&\u001a\u00020\u00182\b\u0010'\u001a\u0004\u0018\u00010%H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000201H\u0016J\u0010\u00103\u001a\u0002012\u0006\u00104\u001a\u000205H\u0016R\u001a\u00106\u001a\u0002078VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006="}, d2={"Lcom/intellij/micronaut/run/MnRunConfiguration;", "Lcom/intellij/microservices/jvm/debugger/scheduled/ScheduledDebuggerRunConfiguration;", "Lcom/intellij/execution/application/ApplicationConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "suggestedName", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "checkClass", "Lcom/intellij/execution/configurations/JavaRunConfigurationModule;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "readExternal", "", "element", "Lorg/jdom/Element;", "writeExternal", "syncOldState", "config", "Lcom/intellij/micronaut/run/MnRunConfiguration$MnRunConfigurationBean;", "setMainClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "getOptions", "Lcom/intellij/micronaut/run/MnRunConfigurationOptions;", "getShortenCommandLine", "Lcom/intellij/execution/ShortenCommandLine;", "setShortenCommandLine", "mode", "getKnownVMOptions", "", "Lcom/intellij/execution/vmOptions/VMOption;", "getLookupElementDecorator", "Lcom/intellij/execution/vmOptions/VMOptionLookupElementDecorator;", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "setEnableScheduledDebugger", "value", "", "isEnableScheduledDebugger", "containsModule", "module", "Lcom/intellij/openapi/module/Module;", "resourceClassLoader", "Ljava/lang/ClassLoader;", "getResourceClassLoader$annotations", "()V", "getResourceClassLoader", "()Ljava/lang/ClassLoader;", "MnRunConfigurationBean", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnRunConfiguration.kt\ncom/intellij/micronaut/run/MnRunConfiguration\n+ 2 StringFun.kt\ncom/intellij/database/util/common/StringFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n148#2:175\n148#2:176\n148#2:177\n148#2:178\n1563#3:179\n1634#3,3:180\n*S KotlinDebug\n*F\n+ 1 MnRunConfiguration.kt\ncom/intellij/micronaut/run/MnRunConfiguration\n*L\n96#1:175\n99#1:176\n102#1:177\n106#1:178\n132#1:179\n132#1:180,3\n*E\n"})
public final class MnRunConfiguration
extends ApplicationConfiguration
implements ScheduledDebuggerRunConfiguration {
    public MnRunConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        super(name, project, factory2);
    }

    @Nullable
    public String suggestedName() {
        return JavaExecutionUtil.getPresentableClassName((String)this.getMainClassName());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        if (Registry.Companion.is("ide.new.run.config", true)) {
            return (SettingsEditor)new MnRunConfigurationFragmentedEditor(this);
        }
        SettingsEditorGroup group = new SettingsEditorGroup();
        String string = ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        group.addEditor(string, (SettingsEditor)new MnRunConfigurationEditor(project));
        JavaRunConfigurationExtensionManager.Companion.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        return (SettingsEditor)group;
    }

    @NotNull
    public JavaRunConfigurationModule checkClass() throws RuntimeConfigurationException {
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass mainClass = configurationModule.checkModuleAndClassName(this.getMainClassName(), MicronautBundle.message("micronaut.run.configuration.class.not.specified", new Object[0]));
        if (!PsiMethodUtil.hasMainMethod((PsiClass)mainClass)) {
            Object[] objectArray = new Object[]{this.getMainClassName()};
            throw new RuntimeConfigurationException(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])objectArray));
        }
        Intrinsics.checkNotNull((Object)configurationModule);
        return configurationModule;
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        MnCommandLineState state = new MnCommandLineState(this, environment);
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module.getSearchScope()));
        return (RunProfileState)state;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        MnRunConfigurationBean config = new MnRunConfigurationBean(null, null, null, false, null, false, 63, null);
        XmlSerializer.deserializeInto((Object)config, (Element)element);
        this.syncOldState(config);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        MnRunConfigurationBean config = new MnRunConfigurationBean(this.getMainClassName(), this.getVMParameters(), this.getProgramParameters(), this.isAlternativeJrePathEnabled(), this.getAlternativeJrePath(), this.isPassParentEnvs());
        XmlSerializer.serializeInto((Object)config, (Element)element);
    }

    private final void syncOldState(MnRunConfigurationBean config) {
        boolean $i$f$isNotNullOrEmpty;
        CharSequence $this$isNotNullOrEmpty$iv;
        CharSequence charSequence = this.getMainClassName();
        if (charSequence == null || charSequence.length() == 0) {
            $this$isNotNullOrEmpty$iv = config.getMainClass();
            $i$f$isNotNullOrEmpty = false;
            if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
                this.setMainClassName(config.getMainClass());
            }
        }
        if (($this$isNotNullOrEmpty$iv = (CharSequence)this.getVMParameters()) == null || $this$isNotNullOrEmpty$iv.length() == 0) {
            $this$isNotNullOrEmpty$iv = config.getVmParameters();
            $i$f$isNotNullOrEmpty = false;
            if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
                this.setVMParameters(config.getVmParameters());
            }
        }
        if (($this$isNotNullOrEmpty$iv = (CharSequence)this.getProgramParameters()) == null || $this$isNotNullOrEmpty$iv.length() == 0) {
            $this$isNotNullOrEmpty$iv = config.getProgramParameters();
            $i$f$isNotNullOrEmpty = false;
            if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
                this.setProgramParameters(config.getProgramParameters());
            }
        }
        this.setAlternativeJrePathEnabled(config.getAlternativeJrePathEnabled());
        $this$isNotNullOrEmpty$iv = this.getAlternativeJrePath();
        if ($this$isNotNullOrEmpty$iv == null || $this$isNotNullOrEmpty$iv.length() == 0) {
            $this$isNotNullOrEmpty$iv = config.getAlternativeJrePath();
            $i$f$isNotNullOrEmpty = false;
            if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
                this.setAlternativeJrePath(config.getAlternativeJrePath());
            }
        }
        this.setPassParentEnvs(config.getPassParentEnvs());
    }

    public void setMainClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(psiClass.getQualifiedName());
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    @NotNull
    protected MnRunConfigurationOptions getOptions() {
        JvmMainMethodRunConfigurationOptions jvmMainMethodRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)jvmMainMethodRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.micronaut.run.MnRunConfigurationOptions");
        return (MnRunConfigurationOptions)jvmMainMethodRunConfigurationOptions;
    }

    @Nullable
    public ShortenCommandLine getShortenCommandLine() {
        return this.getOptions().getShortenCommandLine();
    }

    public void setShortenCommandLine(@Nullable ShortenCommandLine mode) {
        this.getOptions().setShortenCommandLine(mode);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<VMOption> getKnownVMOptions() {
        void $this$mapTo$iv$iv;
        List baseOptions = super.getKnownVMOptions();
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            Intrinsics.checkNotNull((Object)baseOptions);
            return baseOptions;
        }
        Module module2 = module;
        List<MetaConfigKey> keys = MnMetaConfigKeyManager.Companion.getInstance().getAllMetaConfigKeys(module2);
        Iterable $this$map$iv = keys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MetaConfigKey metaConfigKey = (MetaConfigKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiType psiType = it.getType();
            Object object = psiType;
            if (object == null || (object = object.getPresentableText()) == null) {
                object = "String";
            }
            Object type = object;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(VMOption.Companion.property(string, (String)type, it.getDescriptionText().getShortText(), this.getLookupElementDecorator((MetaConfigKey)it)));
        }
        List options = (List)destination$iv$iv;
        List list = ContainerUtil.concat((List)baseOptions, (List)options);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
        return list;
    }

    private final VMOptionLookupElementDecorator getLookupElementDecorator(MetaConfigKey key) {
        TailType tailType;
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        MetaConfigKey.AccessType[] accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
        TailType tailType2 = tailType = key.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length)) ? AutoPopupTailTypes.dotType() : MnRunConfigurationKt.access$getEQUAL_TAIL$p();
        if (!StringsKt.contains$default((CharSequence)name, (CharSequence)".*.", (boolean)false, (int)2, null)) {
            return arg_0 -> MnRunConfiguration.getLookupElementDecorator$lambda$0(tailType, arg_0);
        }
        Intrinsics.checkNotNull((Object)tailType);
        MnParametrizedConfigKeyInsertHandler insertHandler = new MnParametrizedConfigKeyInsertHandler(tailType, name);
        return arg_0 -> MnRunConfiguration.getLookupElementDecorator$lambda$1(insertHandler, arg_0);
    }

    public void setEnableScheduledDebugger(boolean value) {
        this.getOptions().setScheduledDebuggerEnabled(value);
    }

    public boolean isEnableScheduledDebugger() {
        return this.getOptions().getScheduledDebuggerEnabled();
    }

    public boolean containsModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule(), (Object)module);
    }

    @NotNull
    public ClassLoader getResourceClassLoader() {
        ClassLoader classLoader = MicronautBundle.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return classLoader;
    }

    @Deprecated(message="This method is temporary solution to workaround lack of infrastructure of binary agent built")
    public static /* synthetic */ void getResourceClassLoader$annotations() {
    }

    private static final LookupElement getLookupElementDecorator$lambda$0(TailType $tailType, LookupElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)it, (TailType)$tailType);
        Intrinsics.checkNotNullExpressionValue((Object)tailTypeDecorator, (String)"withTail(...)");
        return (LookupElement)tailTypeDecorator;
    }

    private static final LookupElement getLookupElementDecorator$lambda$1(MnParametrizedConfigKeyInsertHandler $insertHandler, LookupElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)it, (InsertHandler)$insertHandler);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementDecorator, (String)"withInsertHandler(...)");
        return (LookupElement)lookupElementDecorator;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BK\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003JM\u0010\"\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017\u00a8\u0006("}, d2={"Lcom/intellij/micronaut/run/MnRunConfiguration$MnRunConfigurationBean;", "", "mainClass", "", "vmParameters", "programParameters", "alternativeJrePathEnabled", "", "alternativeJrePath", "passParentEnvs", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Z)V", "getMainClass", "()Ljava/lang/String;", "setMainClass", "(Ljava/lang/String;)V", "getVmParameters", "setVmParameters", "getProgramParameters", "setProgramParameters", "getAlternativeJrePathEnabled", "()Z", "setAlternativeJrePathEnabled", "(Z)V", "getAlternativeJrePath", "setAlternativeJrePath", "getPassParentEnvs", "setPassParentEnvs", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "intellij.micronaut"})
    private static final class MnRunConfigurationBean {
        @Nullable
        private String mainClass;
        @Nullable
        private String vmParameters;
        @Nullable
        private String programParameters;
        private boolean alternativeJrePathEnabled;
        @Nullable
        private String alternativeJrePath;
        private boolean passParentEnvs;

        public MnRunConfigurationBean(@Nullable String mainClass, @Nullable String vmParameters, @Nullable String programParameters, boolean alternativeJrePathEnabled, @Nullable String alternativeJrePath, boolean passParentEnvs) {
            this.mainClass = mainClass;
            this.vmParameters = vmParameters;
            this.programParameters = programParameters;
            this.alternativeJrePathEnabled = alternativeJrePathEnabled;
            this.alternativeJrePath = alternativeJrePath;
            this.passParentEnvs = passParentEnvs;
        }

        public /* synthetic */ MnRunConfigurationBean(String string, String string2, String string3, boolean bl, String string4, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                string4 = "";
            }
            if ((n & 0x20) != 0) {
                bl2 = true;
            }
            this(string, string2, string3, bl, string4, bl2);
        }

        @Nullable
        public final String getMainClass() {
            return this.mainClass;
        }

        public final void setMainClass(@Nullable String string) {
            this.mainClass = string;
        }

        @Nullable
        public final String getVmParameters() {
            return this.vmParameters;
        }

        public final void setVmParameters(@Nullable String string) {
            this.vmParameters = string;
        }

        @Nullable
        public final String getProgramParameters() {
            return this.programParameters;
        }

        public final void setProgramParameters(@Nullable String string) {
            this.programParameters = string;
        }

        public final boolean getAlternativeJrePathEnabled() {
            return this.alternativeJrePathEnabled;
        }

        public final void setAlternativeJrePathEnabled(boolean bl) {
            this.alternativeJrePathEnabled = bl;
        }

        @Nullable
        public final String getAlternativeJrePath() {
            return this.alternativeJrePath;
        }

        public final void setAlternativeJrePath(@Nullable String string) {
            this.alternativeJrePath = string;
        }

        public final boolean getPassParentEnvs() {
            return this.passParentEnvs;
        }

        public final void setPassParentEnvs(boolean bl) {
            this.passParentEnvs = bl;
        }

        @Nullable
        public final String component1() {
            return this.mainClass;
        }

        @Nullable
        public final String component2() {
            return this.vmParameters;
        }

        @Nullable
        public final String component3() {
            return this.programParameters;
        }

        public final boolean component4() {
            return this.alternativeJrePathEnabled;
        }

        @Nullable
        public final String component5() {
            return this.alternativeJrePath;
        }

        public final boolean component6() {
            return this.passParentEnvs;
        }

        @NotNull
        public final MnRunConfigurationBean copy(@Nullable String mainClass, @Nullable String vmParameters, @Nullable String programParameters, boolean alternativeJrePathEnabled, @Nullable String alternativeJrePath, boolean passParentEnvs) {
            return new MnRunConfigurationBean(mainClass, vmParameters, programParameters, alternativeJrePathEnabled, alternativeJrePath, passParentEnvs);
        }

        public static /* synthetic */ MnRunConfigurationBean copy$default(MnRunConfigurationBean mnRunConfigurationBean, String string, String string2, String string3, boolean bl, String string4, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                string = mnRunConfigurationBean.mainClass;
            }
            if ((n & 2) != 0) {
                string2 = mnRunConfigurationBean.vmParameters;
            }
            if ((n & 4) != 0) {
                string3 = mnRunConfigurationBean.programParameters;
            }
            if ((n & 8) != 0) {
                bl = mnRunConfigurationBean.alternativeJrePathEnabled;
            }
            if ((n & 0x10) != 0) {
                string4 = mnRunConfigurationBean.alternativeJrePath;
            }
            if ((n & 0x20) != 0) {
                bl2 = mnRunConfigurationBean.passParentEnvs;
            }
            return mnRunConfigurationBean.copy(string, string2, string3, bl, string4, bl2);
        }

        @NotNull
        public String toString() {
            return "MnRunConfigurationBean(mainClass=" + this.mainClass + ", vmParameters=" + this.vmParameters + ", programParameters=" + this.programParameters + ", alternativeJrePathEnabled=" + this.alternativeJrePathEnabled + ", alternativeJrePath=" + this.alternativeJrePath + ", passParentEnvs=" + this.passParentEnvs + ")";
        }

        public int hashCode() {
            int result = this.mainClass == null ? 0 : this.mainClass.hashCode();
            result = result * 31 + (this.vmParameters == null ? 0 : this.vmParameters.hashCode());
            result = result * 31 + (this.programParameters == null ? 0 : this.programParameters.hashCode());
            result = result * 31 + Boolean.hashCode(this.alternativeJrePathEnabled);
            result = result * 31 + (this.alternativeJrePath == null ? 0 : this.alternativeJrePath.hashCode());
            result = result * 31 + Boolean.hashCode(this.passParentEnvs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MnRunConfigurationBean)) {
                return false;
            }
            MnRunConfigurationBean mnRunConfigurationBean = (MnRunConfigurationBean)other;
            if (!Intrinsics.areEqual((Object)this.mainClass, (Object)mnRunConfigurationBean.mainClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.vmParameters, (Object)mnRunConfigurationBean.vmParameters)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.programParameters, (Object)mnRunConfigurationBean.programParameters)) {
                return false;
            }
            if (this.alternativeJrePathEnabled != mnRunConfigurationBean.alternativeJrePathEnabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.alternativeJrePath, (Object)mnRunConfigurationBean.alternativeJrePath)) {
                return false;
            }
            return this.passParentEnvs == mnRunConfigurationBean.passParentEnvs;
        }

        public MnRunConfigurationBean() {
            this(null, null, null, false, null, false, 63, null);
        }
    }
}

