/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.action.callback;

import com.intellij.flyway.FlywayCallbackEvent;
import com.intellij.flyway.action.callback.CallbackEventField;
import com.intellij.flyway.msg.FlywayResourceBundle;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.ui.component.CreationSourceFileDialog;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.config.DiffGenerationConfig;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiDirectory;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/flyway/action/callback/FlywaySqlCallbackDialog;", "Lcom/intellij/jpa/jpb/model/ui/component/CreationSourceFileDialog;", "project", "Lcom/intellij/openapi/project/Project;", "directoryPath", "", "selectedResourcesDir", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/psi/PsiDirectory;)V", "callbackEventField", "Lcom/intellij/flyway/action/callback/CallbackEventField;", "getLastSelectedDirectoryPath", "saveSettings", "", "getInitFileName", "completedDirectory", "getFileExt", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "createCenterPanel", "Ljavax/swing/JComponent;", "initFormBuilder", "formBuilder", "Lcom/intellij/util/ui/FormBuilder;", "getPreferredFocusedComponent", "validateFileName", "getFileNameWithoutExt", "getHelpId", "intellij.flyway"})
@SourceDebugExtension(value={"SMAP\nFlywaySqlCallbackDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywaySqlCallbackDialog.kt\ncom/intellij/flyway/action/callback/FlywaySqlCallbackDialog\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,103:1\n106#2:104\n78#2,22:105\n*S KotlinDebug\n*F\n+ 1 FlywaySqlCallbackDialog.kt\ncom/intellij/flyway/action/callback/FlywaySqlCallbackDialog\n*L\n37#1:104\n37#1:105,22\n*E\n"})
public final class FlywaySqlCallbackDialog
extends CreationSourceFileDialog {
    private CallbackEventField callbackEventField;

    public FlywaySqlCallbackDialog(@NotNull Project project, @NotNull String directoryPath, @Nullable PsiDirectory selectedResourcesDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        super(project, directoryPath, selectedResourcesDir);
        this.setTitle(FlywayResourceBundle.message("flyway.sql.callback", new Object[0]));
    }

    @Nullable
    public String getLastSelectedDirectoryPath() {
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return DiffGenerationConfig.Companion.getInstance(project).getFlywayDirectory();
    }

    /*
     * WARNING - void declaration
     */
    public void saveSettings() {
        void $this$trim$iv;
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DiffGenerationConfig diffGenerationConfig = DiffGenerationConfig.Companion.getInstance(project);
        String string = this.getDirectoryField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        DiffGenerationConfig diffGenerationConfig2 = diffGenerationConfig;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        diffGenerationConfig2.setFlywayDirectory(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
    }

    @NotNull
    public String getInitFileName(@Nullable PsiDirectory completedDirectory) {
        return "";
    }

    @NotNull
    public String getFileExt() {
        return "sql";
    }

    @Nullable
    protected ValidationInfo doValidate() {
        CallbackEventField callbackEventField = this.callbackEventField;
        if (callbackEventField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callbackEventField");
            callbackEventField = null;
        }
        if (callbackEventField.getSingleCallback() == null) {
            Object[] objectArray = new Object[]{FlywayResourceBundle.message("callback.event", new Object[0])};
            String string = JpaModelBundle.message((String)"field.required", (Object[])objectArray);
            CallbackEventField callbackEventField2 = this.callbackEventField;
            if (callbackEventField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"callbackEventField");
                callbackEventField2 = null;
            }
            return new ValidationInfo(string, (JComponent)((Object)callbackEventField2));
        }
        return this.validateFileName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        BorderLayoutPanel borderLayoutPanel;
        JComponent jComponent = super.createCenterPanel();
        if (jComponent != null) {
            BorderLayoutPanel borderLayoutPanel2;
            JComponent it = jComponent;
            boolean bl = false;
            BorderLayoutPanel $this$createCenterPanel_u24lambda_u240_u240 = borderLayoutPanel2 = new BorderLayoutPanel();
            boolean bl2 = false;
            $this$createCenterPanel_u24lambda_u240_u240.addToTop((Component)it);
            $this$createCenterPanel_u24lambda_u240_u240.setPreferredSize(new Dimension(500, $this$createCenterPanel_u24lambda_u240_u240.getPreferredSize().height));
            borderLayoutPanel = borderLayoutPanel2;
        } else {
            borderLayoutPanel = null;
        }
        return (JComponent)borderLayoutPanel;
    }

    protected void initFormBuilder(@NotNull FormBuilder formBuilder) {
        Intrinsics.checkNotNullParameter((Object)formBuilder, (String)"formBuilder");
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.callbackEventField = new CallbackEventField(project, (List)FlywayCallbackEvent.getEntries(), false, 4, null);
        FormBuilder formBuilder2 = formBuilder.addLabeledComponent(LiquibaseResourceBundle.messageWithColon((String)"source.root", (Object[])new Object[0]), (JComponent)this.getSourceRootField()).addLabeledComponent(LiquibaseResourceBundle.messageWithColon((String)"directory", (Object[])new Object[0]), (JComponent)this.getDirectoryField());
        String string = FlywayResourceBundle.messageWithColon("callback.event", new Object[0]);
        CallbackEventField callbackEventField = this.callbackEventField;
        if (callbackEventField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callbackEventField");
            callbackEventField = null;
        }
        formBuilder2.addLabeledComponent(string, (JComponent)((Object)callbackEventField)).addLabeledComponent(LiquibaseResourceBundle.messageWithColon((String)"description", (Object[])new Object[0]), (JComponent)this.getFileNameField());
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        CallbackEventField callbackEventField = this.callbackEventField;
        if (callbackEventField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callbackEventField");
            callbackEventField = null;
        }
        return (JComponent)((Object)callbackEventField);
    }

    private final ValidationInfo validateFileName() {
        ValidationInfo validationInfo;
        String[] stringArray = new String[]{this.getFileNameWithoutExt() + "." + this.getFileExt()};
        Path changeLogPath = Paths.get(this.getDirectoryField().getDirectory(), stringArray);
        if (Files.exists(changeLogPath, new LinkOption[0])) {
            String string = FlywayResourceBundle.message("Validation.callbackFileExists", new Object[0]);
            CallbackEventField callbackEventField = this.callbackEventField;
            if (callbackEventField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"callbackEventField");
                callbackEventField = null;
            }
            validationInfo = new ValidationInfo(string, (JComponent)((Object)callbackEventField));
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    @NotNull
    public String getFileNameWithoutExt() {
        CallbackEventField callbackEventField = this.callbackEventField;
        if (callbackEventField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"callbackEventField");
            callbackEventField = null;
        }
        FlywayCallbackEvent selectedCallback = callbackEventField.getSingleCallback();
        String description = this.getFileNameField().getText();
        if (selectedCallback == null) {
            Intrinsics.checkNotNull((Object)description);
            return description;
        }
        CharSequence charSequence = description;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return selectedCallback.getId();
        }
        Project project = this.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DatabaseMigrationState dbMigrationState = DatabaseMigrationConfig.Companion.getInstance(project).getState();
        return selectedCallback.getId() + dbMigrationState.getFlywayMigrationSeparator() + description;
    }

    @NotNull
    protected String getHelpId() {
        return JpaHelpConstants.PluginDoc.INSTANCE.getSqlCallbacks();
    }
}

