/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extract.closure;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.ExtractClosureProcessorBase;
import org.jetbrains.plugins.groovy.refactoring.extract.closure.OtherLanguageUsageInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceClosureParameterProcessor;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GroovyIntroduceParameterUtil;

public class ExtractClosureFromClosureProcessor
extends ExtractClosureProcessorBase {
    public ExtractClosureFromClosureProcessor(@NotNull GrIntroduceParameterSettings helper) {
        if (helper == null) {
            ExtractClosureFromClosureProcessor.$$$reportNull$$$0(0);
        }
        super(helper);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ExtractClosureFromClosureProcessor.$$$reportNull$$$0(1);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        if (!this.myHelper.generateDelegate()) {
            for (GrStatement statement : this.myHelper.getStatements()) {
                GroovyIntroduceParameterUtil.detectAccessibilityConflicts(statement, usagesIn, (MultiMap<PsiElement, String>)conflicts, this.myHelper.replaceFieldsWithGetters() != 0, this.myProject);
            }
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ExtractClosureFromClosureProcessor.$$$reportNull$$$0(2);
        }
        GrIntroduceClosureParameterProcessor.processExternalUsages(usages, this.myHelper, ExtractClosureFromClosureProcessor.generateClosure(this.myHelper));
        GrIntroduceClosureParameterProcessor.processClosure(usages, this.myHelper);
        GrStatementOwner declarationOwner = GroovyRefactoringUtil.getDeclarationOwner(this.myHelper.getStatements()[0]);
        ExtractUtil.replaceStatement(declarationOwner, this.myHelper);
    }

    protected UsageInfo @NotNull [] findUsages() {
        GrVariable var = (GrVariable)this.myHelper.getToSearchFor();
        if (var != null) {
            ArrayList<OtherLanguageUsageInfo> result2 = new ArrayList<OtherLanguageUsageInfo>();
            for (PsiReference ref2 : ReferencesSearch.search((PsiElement)var).asIterable()) {
                PsiElement element = ref2.getElement();
                if (element.getLanguage() != GroovyLanguage.INSTANCE) {
                    result2.add(new OtherLanguageUsageInfo(ref2));
                    continue;
                }
                GrCall call = GroovyRefactoringUtil.getCallExpressionByMethodReference(element);
                if (call == null) continue;
                result2.add((OtherLanguageUsageInfo)new ExternalUsageInfo(element));
            }
            UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                ExtractClosureFromClosureProcessor.$$$reportNull$$$0(3);
            }
            return usageInfoArray;
        }
        if (UsageInfo.EMPTY_ARRAY == null) {
            ExtractClosureFromClosureProcessor.$$$reportNull$$$0(4);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromClosureProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/extract/closure/ExtractClosureFromClosureProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

