/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface PrettierCodeStyleInstaller {
    public static final ExtensionPointName<PrettierCodeStyleInstaller> EP_NAME = ExtensionPointName.create((String)"com.intellij.prettierjs.codeStyleInstaller");

    public void install(@NotNull Project var1, @NotNull PrettierConfig var2, @NotNull CodeStyleSettings var3);

    public boolean isInstalled(@NotNull Project var1, @NotNull PrettierConfig var2, @NotNull CodeStyleSettings var3);

    public static void applyCommonPrettierSettings(@NotNull PrettierConfig config, @NotNull CodeStyleSettings settings, @NotNull Language language) {
        CommonCodeStyleSettings commonSettings;
        CommonCodeStyleSettings.IndentOptions indentOptions;
        if (config == null) {
            PrettierCodeStyleInstaller.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PrettierCodeStyleInstaller.$$$reportNull$$$0(1);
        }
        if (language == null) {
            PrettierCodeStyleInstaller.$$$reportNull$$$0(2);
        }
        if ((indentOptions = (commonSettings = settings.getCommonSettings(language)).getIndentOptions()) != null) {
            indentOptions.INDENT_SIZE = config.tabWidth;
            indentOptions.CONTINUATION_INDENT_SIZE = config.tabWidth;
            indentOptions.TAB_SIZE = config.tabWidth;
            indentOptions.USE_TAB_CHARACTER = config.useTabs;
        }
        settings.setSoftMargins(language, Collections.singletonList(config.printWidth));
    }

    public static boolean commonPrettierSettingsApplied(@NotNull PrettierConfig config, @NotNull CodeStyleSettings settings, @NotNull Language language) {
        if (config == null) {
            PrettierCodeStyleInstaller.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            PrettierCodeStyleInstaller.$$$reportNull$$$0(4);
        }
        if (language == null) {
            PrettierCodeStyleInstaller.$$$reportNull$$$0(5);
        }
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        List softMargins = settings.getSoftMargins(language);
        return (indentOptions == null || indentOptions.INDENT_SIZE == config.tabWidth && indentOptions.TAB_SIZE == config.tabWidth && indentOptions.CONTINUATION_INDENT_SIZE == config.tabWidth && indentOptions.USE_TAB_CHARACTER == config.useTabs) && (softMargins.isEmpty() || softMargins.size() == 1 && (Integer)softMargins.get(0) == config.printWidth);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/prettierjs/codeStyle/PrettierCodeStyleInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCommonPrettierSettings";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "commonPrettierSettingsApplied";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

