/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

final class FrontendJavaEnterInStringHandler
extends EnterInStringLiteralHandler {
    FrontendJavaEnterInStringHandler() {
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language;
        if (file == null) {
            FrontendJavaEnterInStringHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FrontendJavaEnterInStringHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            FrontendJavaEnterInStringHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            FrontendJavaEnterInStringHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            FrontendJavaEnterInStringHandler.$$$reportNull$$$0(4);
        }
        if ((language = file.getLanguage()) == JavaLanguage.INSTANCE) {
            int caretOffset = (Integer)caretOffsetRef.get();
            EnterHandlerDelegate.Result result = super.preprocessEnter(file, editor, caretOffsetRef, caretAdvanceRef, dataContext, originalHandler);
            if (result == EnterHandlerDelegate.Result.DefaultForceIndent) {
                Document document = editor.getDocument();
                Project project = file.getProject();
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                int endOffset = (Integer)caretOffsetRef.get();
                MarkupModelEx markupModelEx = (MarkupModelEx)editor.getMarkupModel();
                ArrayList highlighters = new ArrayList();
                markupModelEx.processRangeHighlightersOverlappingWith(caretOffset, endOffset, ex -> {
                    if (ex.getTextAttributesKey() != null && JavaHighlightingColors.STRING.getExternalName().equals(ex.getTextAttributesKey().getExternalName())) {
                        highlighters.add(ex);
                    }
                    return true;
                });
                for (RangeHighlighterEx highlighter : highlighters) {
                    markupModelEx.removeHighlighter((RangeHighlighter)highlighter);
                }
                return result;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/java/frontend/codeInsight/editorActions/FrontendJavaEnterInStringHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

