/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.fus.fus;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.fus.fus.AuthorshipEventData;
import com.intellij.code.provenance.core.fus.fus.ProvenanceStatistics;
import com.intellij.code.provenance.core.fus.fus.ProvenanceStatisticsComputer;
import com.intellij.code.provenance.info.ProvenanceStatisticsInfo;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FloatEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016JF\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0014\b\u0002\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000201002\b\b\u0002\u00102\u001a\u000201H\u0007JA\u00103\u001a\u0004\u0018\u0001042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000201H\u0001\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00107\u001a\u000204H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/code/provenance/core/fus/fus/ProvenanceUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGroup", "OPERATION_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "FILE_TYPE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/openapi/fileTypes/FileType;", "FILE_TYPE_COUNT", "Lcom/intellij/internal/statistic/eventLog/events/RoundedIntEventField;", "FILE_COUNTS_BY_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/ObjectListEventField;", "DELETED_LINES_COUNT", "TOTAL_CHANGED_LINES_COUNT", "AI_GENERATED_LINES_PERCENTAGE", "Lcom/intellij/internal/statistic/eventLog/events/FloatEventField;", "HUMAN_WRITTEN_LINES_PERCENTAGE", "HUMAN_WRITTEN_AVG_TIME_PER_LINE", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "FILES_COUNT", "AI_INLINE_COMPLETION_LINES_PERCENTAGE", "AI_CODE_GENERATION_LINES_PERCENTAGE", "AI_APPLY_SNIPPET_LINES_PERCENTAGE", "CLAUDE_CODE_GENERATION_LINES_PERCENTAGE", "JUNIE_CODE_GENERATION_LINES_PERCENTAGE", "TYPING_LINES_PERCENTAGE", "PASTE_LINES_PERCENTAGE", "COMPLETION_LINES_PERCENTAGE", "REFACTORING_LINES_PERCENTAGE", "UNKNOWN_LINES_PERCENTAGE", "LINES_PERCENTAGE_BY_KIND", "Lcom/intellij/internal/statistic/eventLog/events/ObjectEventField;", "AUTHORSHIP_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "logAuthorshipStatistics", "", "project", "Lcom/intellij/openapi/project/Project;", "statInfo", "", "Lcom/intellij/code/provenance/info/ProvenanceStatisticsInfo;", "operationType", "", "fileTypesWithCount", "", "", "deletedLines", "buildAuthorshipEventData", "Lcom/intellij/code/provenance/core/fus/fus/AuthorshipEventData;", "buildAuthorshipEventData$intellij_code_provenance_core_fus", "logAuthorshipEvent", "eventData", "intellij.code.provenance.core.fus"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProvenanceUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceUsageCollector.kt\ncom/intellij/code/provenance/core/fus/fus/ProvenanceUsageCollector\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,186:1\n126#2:187\n153#2,3:188\n*S KotlinDebug\n*F\n+ 1 ProvenanceUsageCollector.kt\ncom/intellij/code/provenance/core/fus/fus/ProvenanceUsageCollector\n*L\n136#1:187\n136#1:188,3\n*E\n"})
public final class ProvenanceUsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final ProvenanceUsageCollector INSTANCE = new ProvenanceUsageCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("code.provenance", 3, "FUS", "Anonymized code provenance statistics", null, 16, null);
    @NotNull
    private static final StringEventField OPERATION_TYPE;
    @NotNull
    private static final PrimitiveEventField<FileType> FILE_TYPE_FIELD;
    @NotNull
    private static final RoundedIntEventField FILE_TYPE_COUNT;
    @NotNull
    private static final ObjectListEventField FILE_COUNTS_BY_TYPE;
    @NotNull
    private static final RoundedIntEventField DELETED_LINES_COUNT;
    @NotNull
    private static final RoundedIntEventField TOTAL_CHANGED_LINES_COUNT;
    @NotNull
    private static final FloatEventField AI_GENERATED_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField HUMAN_WRITTEN_LINES_PERCENTAGE;
    @NotNull
    private static final LongEventField HUMAN_WRITTEN_AVG_TIME_PER_LINE;
    @NotNull
    private static final RoundedIntEventField FILES_COUNT;
    @NotNull
    private static final FloatEventField AI_INLINE_COMPLETION_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField AI_CODE_GENERATION_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField AI_APPLY_SNIPPET_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField CLAUDE_CODE_GENERATION_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField JUNIE_CODE_GENERATION_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField TYPING_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField PASTE_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField COMPLETION_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField REFACTORING_LINES_PERCENTAGE;
    @NotNull
    private static final FloatEventField UNKNOWN_LINES_PERCENTAGE;
    @NotNull
    private static final ObjectEventField LINES_PERCENTAGE_BY_KIND;
    @NotNull
    private static final VarargEventId AUTHORSHIP_EVENT;

    private ProvenanceUsageCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @ApiStatus.Internal
    public final void logAuthorshipStatistics(@NotNull Project project, @NotNull List<ProvenanceStatisticsInfo> statInfo, @NotNull String operationType, @NotNull Map<FileType, Integer> fileTypesWithCount, int deletedLines) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(statInfo, (String)"statInfo");
            Intrinsics.checkNotNullParameter((Object)operationType, (String)"operationType");
            Intrinsics.checkNotNullParameter(fileTypesWithCount, (String)"fileTypesWithCount");
            AuthorshipEventData authorshipEventData = this.buildAuthorshipEventData$intellij_code_provenance_core_fus(statInfo, operationType, fileTypesWithCount, deletedLines);
            if (authorshipEventData == null) break block0;
            AuthorshipEventData eventData = authorshipEventData;
            boolean bl = false;
            INSTANCE.logAuthorshipEvent(project, eventData);
        }
    }

    public static /* synthetic */ void logAuthorshipStatistics$default(ProvenanceUsageCollector provenanceUsageCollector, Project project, List list, String string, Map map, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        provenanceUsageCollector.logAuthorshipStatistics(project, list, string, map, n);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @Nullable
    public final AuthorshipEventData buildAuthorshipEventData$intellij_code_provenance_core_fus(@NotNull List<ProvenanceStatisticsInfo> statInfo, @NotNull String operationType, @NotNull Map<FileType, Integer> fileTypesWithCount, int deletedLines) {
        List list;
        Intrinsics.checkNotNullParameter(statInfo, (String)"statInfo");
        Intrinsics.checkNotNullParameter((Object)operationType, (String)"operationType");
        Intrinsics.checkNotNullParameter(fileTypesWithCount, (String)"fileTypesWithCount");
        if (statInfo.isEmpty() && fileTypesWithCount.isEmpty()) {
            return null;
        }
        ProvenanceStatistics stats = ProvenanceStatisticsComputer.INSTANCE.computeStatistics(statInfo);
        int filesCount = statInfo.size();
        EventPair[] eventPairArray = new EventPair[10];
        Float f = stats.getLinePercentagesByKind().get(DocumentChangesKind.AI_INLINE_COMPLETION);
        eventPairArray[0] = AI_INLINE_COMPLETION_LINES_PERCENTAGE.with((Object)Float.valueOf(f != null ? f.floatValue() : 0.0f));
        Float f2 = stats.getLinePercentagesByKind().get(DocumentChangesKind.AI_CODE_GENERATION);
        eventPairArray[1] = AI_CODE_GENERATION_LINES_PERCENTAGE.with((Object)Float.valueOf(f2 != null ? f2.floatValue() : 0.0f));
        Float f3 = stats.getLinePercentagesByKind().get(DocumentChangesKind.AI_APPLY_SNIPPET);
        eventPairArray[2] = AI_APPLY_SNIPPET_LINES_PERCENTAGE.with((Object)Float.valueOf(f3 != null ? f3.floatValue() : 0.0f));
        Float f4 = stats.getLinePercentagesByKind().get(DocumentChangesKind.CLAUDE_CODE_GENERATION);
        eventPairArray[3] = CLAUDE_CODE_GENERATION_LINES_PERCENTAGE.with((Object)Float.valueOf(f4 != null ? f4.floatValue() : 0.0f));
        Float f5 = stats.getLinePercentagesByKind().get(DocumentChangesKind.JUNIE_CODE_GENERATION);
        eventPairArray[4] = JUNIE_CODE_GENERATION_LINES_PERCENTAGE.with((Object)Float.valueOf(f5 != null ? f5.floatValue() : 0.0f));
        Float f6 = stats.getLinePercentagesByKind().get(DocumentChangesKind.TYPING);
        eventPairArray[5] = TYPING_LINES_PERCENTAGE.with((Object)Float.valueOf(f6 != null ? f6.floatValue() : 0.0f));
        Float f7 = stats.getLinePercentagesByKind().get(DocumentChangesKind.PASTE);
        eventPairArray[6] = PASTE_LINES_PERCENTAGE.with((Object)Float.valueOf(f7 != null ? f7.floatValue() : 0.0f));
        Float f8 = stats.getLinePercentagesByKind().get(DocumentChangesKind.COMPLETION);
        eventPairArray[7] = COMPLETION_LINES_PERCENTAGE.with((Object)Float.valueOf(f8 != null ? f8.floatValue() : 0.0f));
        Float f9 = stats.getLinePercentagesByKind().get(DocumentChangesKind.REFACTORING);
        eventPairArray[8] = REFACTORING_LINES_PERCENTAGE.with((Object)Float.valueOf(f9 != null ? f9.floatValue() : 0.0f));
        Float f10 = stats.getLinePercentagesByKind().get(DocumentChangesKind.UNKNOWN);
        eventPairArray[9] = UNKNOWN_LINES_PERCENTAGE.with((Object)Float.valueOf(f10 != null ? f10.floatValue() : 0.0f));
        ObjectEventData linesByKindPercentageData = new ObjectEventData(eventPairArray);
        if (!fileTypesWithCount.isEmpty()) {
            void $this$mapTo$iv$iv;
            Map<FileType, Integer> $this$map$iv = fileTypesWithCount;
            boolean $i$f$map = false;
            Map<FileType, Integer> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FileType fileType = (FileType)entry.getKey();
                int count = ((Number)entry.getValue()).intValue();
                EventPair[] eventPairArray2 = new EventPair[]{FILE_TYPE_FIELD.with((Object)fileType), FILE_TYPE_COUNT.with((Object)count)};
                collection.add(new ObjectEventData(eventPairArray2));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List fileTypesData = list;
        return new AuthorshipEventData(operationType, fileTypesData, deletedLines, stats.getTotalChangedLines(), stats.getAiGeneratedLinesPercentage(), stats.getHumanWrittenLinesPercentage(), stats.getHumanWrittenAvgTimePerLineMs(), filesCount, linesByKindPercentageData);
    }

    @ApiStatus.Internal
    private final void logAuthorshipEvent(Project project, AuthorshipEventData eventData) {
        EventPair[] eventPairArray = new EventPair[]{OPERATION_TYPE.with((Object)eventData.getOperationType()), FILE_COUNTS_BY_TYPE.with(eventData.getFileTypesData()), DELETED_LINES_COUNT.with((Object)eventData.getDeletedLines()), TOTAL_CHANGED_LINES_COUNT.with((Object)eventData.getTotalChangedLines()), AI_GENERATED_LINES_PERCENTAGE.with((Object)Float.valueOf(eventData.getAiGeneratedLinesPercentage())), HUMAN_WRITTEN_LINES_PERCENTAGE.with((Object)Float.valueOf(eventData.getHumanWrittenLinesPercentage())), HUMAN_WRITTEN_AVG_TIME_PER_LINE.with((Object)eventData.getHumanWrittenAvgTimePerLineMs()), FILES_COUNT.with((Object)eventData.getFilesCount()), LINES_PERCENTAGE_BY_KIND.with((Object)eventData.getLinesByKindPercentageData())};
        AUTHORSHIP_EVENT.log(project, eventPairArray);
    }

    static {
        Object[] objectArray = new String[]{"commit", "stash", "unstash", "checkout", "amend"};
        OPERATION_TYPE = EventFields.String((String)"operation_type", (List)CollectionsKt.listOf((Object[])objectArray));
        FILE_TYPE_FIELD = EventFields.FileType;
        FILE_TYPE_COUNT = EventFields.RoundedInt((String)"count");
        objectArray = new EventField[]{FILE_TYPE_FIELD, FILE_TYPE_COUNT};
        FILE_COUNTS_BY_TYPE = new ObjectListEventField("file_counts_by_type", (EventField[])objectArray, null, 4, null);
        DELETED_LINES_COUNT = EventFields.RoundedInt((String)"deleted_lines_count");
        TOTAL_CHANGED_LINES_COUNT = EventFields.RoundedInt((String)"total_changed_lines_count");
        AI_GENERATED_LINES_PERCENTAGE = EventFields.Float$default((String)"ai_generated_lines_percentage", null, (int)2, null);
        HUMAN_WRITTEN_LINES_PERCENTAGE = EventFields.Float$default((String)"human_written_lines_percentage", null, (int)2, null);
        HUMAN_WRITTEN_AVG_TIME_PER_LINE = EventFields.Long$default((String)"human_written_avg_time_per_line_ms", null, (int)2, null);
        FILES_COUNT = EventFields.RoundedInt((String)"files_count");
        AI_INLINE_COMPLETION_LINES_PERCENTAGE = EventFields.Float$default((String)"ai_inline_completion_lines_percentage", null, (int)2, null);
        AI_CODE_GENERATION_LINES_PERCENTAGE = EventFields.Float$default((String)"ai_code_generation_lines_percentage", null, (int)2, null);
        AI_APPLY_SNIPPET_LINES_PERCENTAGE = EventFields.Float$default((String)"ai_apply_snippet_lines_percentage", null, (int)2, null);
        CLAUDE_CODE_GENERATION_LINES_PERCENTAGE = EventFields.Float$default((String)"claude_code_generation_lines_percentage", null, (int)2, null);
        JUNIE_CODE_GENERATION_LINES_PERCENTAGE = EventFields.Float$default((String)"junie_code_generation_lines_percentage", null, (int)2, null);
        TYPING_LINES_PERCENTAGE = EventFields.Float$default((String)"typing_lines_percentage", null, (int)2, null);
        PASTE_LINES_PERCENTAGE = EventFields.Float$default((String)"paste_lines_percentage", null, (int)2, null);
        COMPLETION_LINES_PERCENTAGE = EventFields.Float$default((String)"completion_lines_percentage", null, (int)2, null);
        REFACTORING_LINES_PERCENTAGE = EventFields.Float$default((String)"refactoring_lines_percentage", null, (int)2, null);
        UNKNOWN_LINES_PERCENTAGE = EventFields.Float$default((String)"unknown_lines_percentage", null, (int)2, null);
        objectArray = new EventField[]{AI_INLINE_COMPLETION_LINES_PERCENTAGE, AI_CODE_GENERATION_LINES_PERCENTAGE, AI_APPLY_SNIPPET_LINES_PERCENTAGE, CLAUDE_CODE_GENERATION_LINES_PERCENTAGE, JUNIE_CODE_GENERATION_LINES_PERCENTAGE, TYPING_LINES_PERCENTAGE, PASTE_LINES_PERCENTAGE, COMPLETION_LINES_PERCENTAGE, REFACTORING_LINES_PERCENTAGE, UNKNOWN_LINES_PERCENTAGE};
        LINES_PERCENTAGE_BY_KIND = new ObjectEventField("lines_percentage_by_kind", "Breakdown of changed-line percentages by DocumentChangesKind", (EventField[])objectArray);
        objectArray = new EventField[]{OPERATION_TYPE, FILE_COUNTS_BY_TYPE, DELETED_LINES_COUNT, TOTAL_CHANGED_LINES_COUNT, AI_GENERATED_LINES_PERCENTAGE, HUMAN_WRITTEN_LINES_PERCENTAGE, HUMAN_WRITTEN_AVG_TIME_PER_LINE, FILES_COUNT, LINES_PERCENTAGE_BY_KIND};
        AUTHORSHIP_EVENT = GROUP.registerVarargEvent("authorship.changed", "Code authorship statistics for VCS operations", (EventField[])objectArray);
    }
}

