/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet.validation;

import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.validation.SpringFileSetCycleChecker;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FileSetDependenciesValidator
extends FacetEditorValidator {
    private final Collection<SpringFileSet> myFileSets;

    public FileSetDependenciesValidator(Collection<SpringFileSet> fileSets) {
        this.myFileSets = fileSets;
    }

    @NotNull
    public ValidationResult check() {
        ValidationResult validationResult = this.validateDependencies();
        if (validationResult == null) {
            FileSetDependenciesValidator.$$$reportNull$$$0(0);
        }
        return validationResult;
    }

    private ValidationResult validateDependencies() {
        SpringFileSetCycleChecker checker = new SpringFileSetCycleChecker(this.myFileSets);
        if (!checker.hasCycles()) {
            return ValidationResult.OK;
        }
        Map.Entry<SpringFileSet, SpringFileSet> cycle = checker.getCircularDependency();
        return new ValidationResult(SpringBundle.message("fileset.circular.dependencies", FileSetDependenciesValidator.getFileSetDisplay(cycle.getKey()), FileSetDependenciesValidator.getFileSetDisplay(cycle.getValue())));
    }

    private static String getFileSetDisplay(SpringFileSet springFileSet) {
        return springFileSet.getName() + " (" + springFileSet.getFacet().getModule().getName() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/validation/FileSetDependenciesValidator", "check"));
    }
}

