/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverter;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class FieldRetrievingFactoryBeanConverterImpl
extends FieldRetrievingFactoryBeanConverter {
    @NonNls
    private static final String FIELD_RETRIEVING_FACTORY_BEAN_CLASS = "org.springframework.beans.factory.config.FieldRetrievingFactoryBean";
    @NonNls
    private static final String STATIC_FIELD_PROPERTY_NAME = "staticField";
    private static final Condition<GenericDomValue<?>> PROPERTY_NAME_CONDITION = SpringValueConditionFactory.createPropertyNameCondition((String)"staticField");

    public FieldRetrievingFactoryBeanConverterImpl() {
        super(true);
    }

    public FieldRetrievingFactoryBeanConverterImpl(boolean soft) {
        super(soft);
    }

    private static boolean checkBeanClass(DomElement element) {
        return FieldRetrievingFactoryBeanConverterImpl.isFieldRetrievingFactoryBean((CommonSpringBean)SpringConverterUtil.getCurrentBean((DomElement)element));
    }

    public static boolean isFieldRetrievingFactoryBean(@Nullable CommonSpringBean springBean) {
        if (!(springBean instanceof SpringBean)) {
            return false;
        }
        SpringBean bean = (SpringBean)springBean;
        String beanClass = bean.getClazz().getStringValue();
        return FIELD_RETRIEVING_FACTORY_BEAN_CLASS.equals(beanClass);
    }

    public static boolean isResolved(Project project, String field) {
        int index = field.lastIndexOf(".");
        if (index <= 0) {
            return false;
        }
        String className = field.substring(0, index);
        String fieldName = field.substring(index + 1);
        if (StringUtil.isEmpty((String)fieldName) || StringUtil.isEmpty((String)className)) {
            return false;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            for (PsiField psiField : psiClass.getFields()) {
                if (!psiField.hasModifierProperty("static") || !fieldName.equals(psiField.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static class FactoryClassAndPropertyCondition
    implements Condition<Pair<PsiType, GenericDomValue<?>>> {
        public boolean value(Pair<PsiType, GenericDomValue<?>> pair) {
            GenericDomValue element = (GenericDomValue)pair.getSecond();
            return PROPERTY_NAME_CONDITION.value((Object)element) && FieldRetrievingFactoryBeanConverterImpl.checkBeanClass((DomElement)element);
        }
    }

    public static class FactoryClassCondition
    implements Condition<GenericDomValue<?>> {
        public boolean value(GenericDomValue context) {
            return FieldRetrievingFactoryBeanConverterImpl.checkBeanClass((DomElement)context);
        }
    }
}

