/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInsight.navigation.TargetPresentationProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.impl.RawNavigationRequest;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.run.SpringMultipleOccurrencesFilter;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BeanNameFilter
extends SpringMultipleOccurrencesFilter {
    private static final String[] DETECTION_MESSAGES = new String[]{"Error creating bean with name '", "containing bean '"};

    @Override
    @Nullable
    protected Filter.Result findNextOccurrence(int startOffset, String line, int entireLength) {
        int index = -1;
        int messageLength = -1;
        for (String message : DETECTION_MESSAGES) {
            index = StringUtil.indexOf((CharSequence)line, (CharSequence)message, (int)startOffset);
            if (index == -1) continue;
            messageLength = message.length();
            break;
        }
        if (index == -1) {
            return null;
        }
        int beanNameStart = index + messageLength;
        int beanNameEnd = StringUtil.indexOf((CharSequence)line, (char)'\'', (int)beanNameStart);
        if (beanNameEnd == -1) {
            return null;
        }
        final String beanName = line.substring(beanNameStart, beanNameEnd);
        int textStartOffset = entireLength - line.length() + beanNameStart;
        return new Filter.Result(textStartOffset, textStartOffset + beanName.length(), project -> BeanNameFilter.showResult((context, editor) -> {
            final ConsoleView consoleView = (ConsoleView)LangDataKeys.CONSOLE_VIEW.getData(context);
            if (consoleView == null) {
                return;
            }
            Navigatable navigatable = new Navigatable(){
                final /* synthetic */ Editor val$editor;
                {
                    this.val$editor = editor;
                }

                @Nullable
                public NavigationRequest navigationRequest() {
                    List<SpringBeanPointer<?>> beans = BeanNameFilter.findBeanCandidates(project, beanName);
                    if (!beans.isEmpty()) {
                        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)consoleView)).submit(() -> BeanNameFilter.showBeanTargets(this.val$editor, beans));
                        return null;
                    }
                    PsiClass byBeanName = JavaPsiFacade.getInstance((Project)project).findClass(beanName, GlobalSearchScope.allScope((Project)project));
                    if (byBeanName != null) {
                        return new RawNavigationRequest((Navigatable)byBeanName, true);
                    }
                    ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)consoleView)).submit(() -> HintManager.getInstance().showErrorHint(this.val$editor, SpringBundle.message("model.bean.not.found.error.message", beanName)));
                    return null;
                }
            };
            DataContext wrapper = SimpleDataContext.getSimpleContext((DataKey)CommonDataKeys.NAVIGATABLE, (Object)navigatable, (DataContext)context);
            OpenSourceUtil.openSourcesFrom((DataContext)wrapper, (boolean)true);
        }));
    }

    private static List<SpringBeanPointer<?>> findBeanCandidates(Project project, String beanName) {
        SmartList beans = new SmartList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Set models = SpringManager.getInstance((Project)project).getAllModelsWithoutDependencies(module);
            for (SpringModel model : models) {
                SpringBeanPointer byName = SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName);
                ContainerUtil.addIfNotNull((Collection)beans, (Object)byName);
            }
        }
        return beans;
    }

    private static void showBeanTargets(@NotNull Editor editor, Collection<? extends SpringBeanPointer<?>> beans) {
        if (editor == null) {
            BeanNameFilter.$$$reportNull$$$0(0);
        }
        new PsiTargetNavigator(() -> ContainerUtil.map2SetNotNull((Collection)beans, pointer -> pointer.getPsiElement())).tabTitle(SpringBundle.message("spring.bean.show.beans.candidates.title", new Object[0])).presentationProvider((TargetPresentationProvider)new SpringBeansPsiElementCellRenderer()).navigate(editor, SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/spring/run/BeanNameFilter", "showBeanTargets"));
    }
}

