/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Map;
import org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsManagerImpl;
import org.intellij.lang.xpath.xslt.associations.impl.TransactionalManager;

class TempManager
extends TransactionalManager {
    private final FileAssociationsManagerImpl myImpl;
    private final FileAssociationsManagerImpl myTmp;
    private long myStartModCount;
    private long myImplModCount;

    TempManager(FileAssociationsManagerImpl impl, Project project) {
        this.myTmp = new FileAssociationsManagerImpl(project);
        this.myTmp.markAsTempCopy();
        this.myTmp.copyFrom(impl);
        this.myImpl = impl;
        this.myStartModCount = 0L;
        this.myImplModCount = this.myImpl.getModificationCount();
    }

    @Override
    public void applyChanges() {
        assert (this.myImplModCount == this.myImpl.getModificationCount());
        this.myImpl.copyFrom(this.myTmp);
        this.myImplModCount = this.myImpl.getModificationCount();
        this.myStartModCount = this.myTmp.getModificationCount();
    }

    @Override
    public boolean isModified() {
        assert (this.myImplModCount == this.myImpl.getModificationCount());
        return this.myStartModCount != this.myTmp.getModificationCount();
    }

    @Override
    public void reset() {
        assert (this.myImplModCount == this.myImpl.getModificationCount());
        this.myTmp.copyFrom(this.myImpl);
        this.myStartModCount = this.myTmp.getModificationCount();
    }

    @Override
    public void dispose() {
        Disposer.dispose((Disposable)this.myTmp);
    }

    @Override
    public void removeAssociations(PsiFile file) {
        this.myTmp.removeAssociations(file);
    }

    @Override
    public void removeAssociation(PsiFile file, PsiFile assoc) {
        this.myTmp.removeAssociation(file, assoc);
    }

    @Override
    public void addAssociation(PsiFile file, PsiFile assoc) {
        this.myTmp.addAssociation(file, assoc);
    }

    @Override
    public void addAssociation(PsiFile file, VirtualFile assoc) {
        this.myTmp.addAssociation(file, assoc);
    }

    @Override
    public Map<VirtualFile, VirtualFile[]> getAssociations() {
        return this.myTmp.getAssociations();
    }

    @Override
    public PsiFile[] getAssociationsFor(PsiFile file) {
        return this.myTmp.getAssociationsFor(file);
    }

    @Override
    public PsiFile[] getAssociationsFor(PsiFile file, FileType ... fileTypes) {
        return this.myTmp.getAssociationsFor(file, fileTypes);
    }
}

