/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.inspections.SassScssBaseInspection;
import org.jetbrains.plugins.scss.psi.ISassScssInclude;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelector;
import org.jetbrains.plugins.scss.psi.SassScssVariable;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassScssResolvedByNameOnlyInspection
extends SassScssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SassScssResolvedByNameOnlyInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            SassScssResolvedByNameOnlyInspection.$$$reportNull$$$0(1);
        }
        return new SASSSCSSElementVisitor(this){

            public void visitSassScssVariable(SassScssVariable sassScssVariable) {
                PsiElement nameIdentifier = sassScssVariable.getVarNameElement();
                if (nameIdentifier != null) {
                    CssInspectionsUtil.checkForProperlyResolving((PsiElement)sassScssVariable, (PsiElement)nameIdentifier, (ProblemsHolder)holder, (String)SASSBundle.message((String)"inspections.resolved.without.imports.message", (Object[])new Object[]{sassScssVariable.getName()}));
                }
            }

            public void visitInclude(ISassScssInclude scssInclude) {
                PsiElement mixinNameElement = scssInclude.getMixinNameElement();
                CssInspectionsUtil.checkForProperlyResolving((PsiElement)scssInclude, (PsiElement)(mixinNameElement != null ? mixinNameElement : scssInclude), (ProblemsHolder)holder, (String)SASSBundle.message((String)"inspections.resolved.without.imports.message", (Object[])new Object[]{scssInclude.getName()}));
            }

            public void visitPlaceholderSelector(SassScssPlaceholderSelector selector) {
                if (selector.isInsideExtendStatement()) {
                    CssInspectionsUtil.checkForProperlyResolving((PsiElement)selector, (ProblemsHolder)holder, (String)SASSBundle.message((String)"inspections.resolved.without.imports.message", (Object[])new Object[]{selector.getName()}));
                }
            }

            public void visitElement(@NotNull PsiElement element) {
                Language stylesheetLanguage;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((stylesheetLanguage = CssPsiUtilCore.getStylesheetLanguage((PsiElement)element)) != SASSLanguage.INSTANCE && stylesheetLanguage != SCSSLanguage.INSTANCE) {
                    return;
                }
                if (element instanceof CssFunction) {
                    boolean hasProblem = false;
                    for (PsiReference reference : element.getReferences()) {
                        if (reference instanceof SassScssFunctionReference) {
                            ResolveResult[] results = ((SassScssFunctionReference)reference).multiResolve(false);
                            hasProblem = hasProblem || results.length > 0;
                            for (ResolveResult result : results) {
                                if (!result.isValidResult()) continue;
                                hasProblem = false;
                            }
                            continue;
                        }
                        if (!(reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length > 0 : reference.resolve() != null)) continue;
                        return;
                    }
                    if (hasProblem) {
                        PsiElement functionNameElement = ((CssFunction)element).getFunctionNameElement();
                        holder.registerProblem(functionNameElement != null ? functionNameElement : element, SASSBundle.message((String)"inspections.resolved.without.imports.message", (Object[])new Object[]{((CssFunction)element).getName()}), new LocalQuickFix[0]);
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection$1", "visitElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

