/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtensionsManager;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerRunConfigurationCreator {
    private final Project myProject;
    @Nullable
    private final Executor myExecutor;

    public DockerRunConfigurationCreator(@NotNull Project project) {
        if (project == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(0);
        }
        this(project, DefaultRunExecutor.getRunExecutorInstance());
    }

    public DockerRunConfigurationCreator(@NotNull Project project, @Nullable Executor executor) {
        if (project == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myExecutor = executor;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(2);
        }
        return project;
    }

    public void setupAndFireDeployment(@NotNull DeploymentSource deploymentSource, @NotNull DockerDeploymentConfiguration deploymentConfiguration, @Nullable RemoteServer server2) {
        if (deploymentSource == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(3);
        }
        if (deploymentConfiguration == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(4);
        }
        RunnerAndConfigurationSettings settings = this.createConfiguration(deploymentSource, deploymentConfiguration, server2);
        this.openForEditingAndExecute(settings, DockerBundle.message((String)"DockerRunConfigurationCreator.editConfiguration.title.new", (Object[])new Object[0]));
    }

    public void openForEditingAndExecute(@NotNull RunnerAndConfigurationSettings settings, @NotNull @Nls String title) {
        if (settings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(5);
        }
        if (title == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(6);
        }
        if (this.editConfiguration(settings, title)) {
            this.rememberConfiguration(settings);
            this.executeConfiguration(settings);
        }
    }

    public void rememberConfiguration(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(7);
        }
        RunManager runManager = this.getRunManager();
        runManager.addConfiguration(settings);
        runManager.setSelectedConfiguration(settings);
    }

    public void setSelectedConfiguration(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(8);
        }
        this.getRunManager().setSelectedConfiguration(settings);
    }

    public void executeConfiguration(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(9);
        }
        if (this.myExecutor != null) {
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)settings, (Executor)this.myExecutor);
        }
    }

    public boolean editConfiguration(@NotNull RunnerAndConfigurationSettings settings, @NotNull @Nls String title) {
        if (settings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(10);
        }
        if (title == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(11);
        }
        return RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (String)title, (Executor)this.myExecutor);
    }

    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull DockerSingletonDeploymentSourceType sourceType, @Nullable VirtualFile sourceFile, @Nullable RemoteServer docker) {
        if (sourceType == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(12);
        }
        assert (docker == null || docker.getType() == DockerCloudType.getInstance()) : "Docker expected: " + String.valueOf(docker.getType());
        DeploymentSource deploymentSource = sourceType.getSingletonSource();
        DockerDeploymentConfiguration deploymentConfiguration = Optional.ofNullable(this.createDeploymentConfigurationFromTemplate(sourceType)).orElseGet(() -> DockerCloudType.getInstance().createDeploymentConfigurator(this.myProject).createDefaultConfiguration(deploymentSource));
        DockerDeploymentConfigurationUtilsKt.setSourceFile(this.myProject, deploymentConfiguration, sourceFile);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.createConfiguration(deploymentSource, deploymentConfiguration, docker);
        if (runnerAndConfigurationSettings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(13);
        }
        return runnerAndConfigurationSettings;
    }

    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull DeploymentSource deploymentSource, @NotNull DockerDeploymentConfiguration deploymentConfiguration, @Nullable RemoteServer server2) {
        if (deploymentSource == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(14);
        }
        if (deploymentConfiguration == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(15);
        }
        DeployToServerConfigurationType<DockerCloudConfiguration> configurationType = DockerCloudType.getRunConfigurationType();
        ConfigurationFactory factory = configurationType.getFactoryForType(deploymentSource.getType());
        RunnerAndConfigurationSettings settings = this.getRunManager().createConfiguration(configurationType.getDisplayName(), factory);
        settings.setTemporary(true);
        DeployToServerRunConfiguration runConfiguration = (DeployToServerRunConfiguration)settings.getConfiguration();
        if (server2 != null) {
            runConfiguration.setServerName(server2.getName());
        }
        runConfiguration.setDeploymentSource(deploymentSource);
        runConfiguration.setDeploymentConfiguration((DeploymentConfiguration)deploymentConfiguration);
        runConfiguration.setName(this.suggestConfigurationName(runConfiguration.suggestedName()));
        DeployToServerRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration(runConfiguration);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = settings;
        if (runnerAndConfigurationSettings == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(16);
        }
        return runnerAndConfigurationSettings;
    }

    private static ConfigurationFactory getConfigurationFactory(@NotNull DockerSingletonDeploymentSourceType sourceType) {
        if (sourceType == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(17);
        }
        DeploymentSource deploymentSource = sourceType.getSingletonSource();
        DeployToServerConfigurationType<DockerCloudConfiguration> configurationType = DockerCloudType.getRunConfigurationType();
        return configurationType.getFactoryForType(deploymentSource.getType());
    }

    @Nullable
    public DockerDeploymentConfiguration createDeploymentConfigurationFromTemplate(@NotNull DockerSingletonDeploymentSourceType sourceType) {
        if (sourceType == null) {
            DockerRunConfigurationCreator.$$$reportNull$$$0(18);
        }
        RunnerAndConfigurationSettings settings = this.getRunManager().getConfigurationTemplate(DockerRunConfigurationCreator.getConfigurationFactory(sourceType));
        settings.setTemporary(true);
        DeployToServerRunConfiguration config2 = (DeployToServerRunConfiguration)settings.getConfiguration().clone();
        return (DockerDeploymentConfiguration)config2.getDeploymentConfiguration();
    }

    public String suggestConfigurationName(String template) {
        return this.getRunManager().suggestUniqueName(template, DockerCloudType.getRunConfigurationType());
    }

    private RunManager getRunManager() {
        return RunManager.getInstance((Project)this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/DockerRunConfigurationCreator";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSource";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentConfiguration";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/DockerRunConfigurationCreator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupAndFireDeployment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openForEditingAndExecute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rememberConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "editConfiguration";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguration";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFactory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createDeploymentConfigurationFromTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13, 16 -> new IllegalStateException(string);
        };
    }
}

