/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;

public class UnexpectedColumnChangeGenerator
extends liquibase.diff.output.changelog.core.UnexpectedColumnChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Column.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Change[] changes = super.fixUnexpected(unexpectedObject, control, referenceDatabase, comparisonDatabase, chain);
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
        if (intellijDatabase == null) {
            return changes;
        }
        Relation table = ((Column)unexpectedObject).getRelation();
        if (table == null) {
            return changes;
        }
        OrmEntity foundEntity = intellijDatabase.findOrmEntityByTableName(table.getName());
        if (foundEntity != null && OrmUtil.INSTANCE.getEntityByOrmEntity(foundEntity) instanceof AuditEntity) {
            return new Change[0];
        }
        return changes;
    }
}

