/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.Index;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.liquibase.common.ddl.model.JForeignKey;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import org.jetbrains.annotations.NotNull;

public class UnexpectedIndexChangeGenerator
extends liquibase.diff.output.changelog.core.UnexpectedIndexChangeGenerator {
    public static final String SYS_IDX_PREFIX = "SYS_";

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (liquibase.structure.core.Index.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        IntellijDatabase intellijDatabase = LiquibaseUtils.getIntellijDatabase(referenceDatabase, comparisonDatabase);
        if (intellijDatabase != null) {
            liquibase.structure.core.Index index;
            if (!intellijDatabase.getOrmFramework().getMappingFeatures().indexesAndConstraints && unexpectedObject instanceof liquibase.structure.core.Index && intellijDatabase.findOrmEntityByTableName((index = (liquibase.structure.core.Index)unexpectedObject).getRelation().getName()) == null) {
                return new Change[0];
            }
            if (this.isLegalIndex(unexpectedObject, intellijDatabase, intellijDatabase == referenceDatabase ? comparisonDatabase : referenceDatabase)) {
                return null;
            }
        }
        return super.fixUnexpected(unexpectedObject, control, referenceDatabase, comparisonDatabase, chain);
    }

    private boolean isLegalIndex(DatabaseObject unexpectedObject, IntellijDatabase intellijDatabase, Database jdbcDatabase) {
        liquibase.structure.core.Index idx = (liquibase.structure.core.Index)unexpectedObject;
        Relation relation = idx.getRelation();
        if (relation == null) {
            return true;
        }
        if (relation instanceof Table && (LiquibaseUtils.getDatabaseType(jdbcDatabase) != DbType.MYSQL || LiquibaseUtils.getDatabaseType(jdbcDatabase) == DbType.MARIA) && UnexpectedIndexChangeGenerator.isPkIndex((Table)relation, idx)) {
            return true;
        }
        OrmEntity entity = intellijDatabase.findOrmEntityByTableName(relation.getName());
        if (entity == null) {
            return true;
        }
        String idxName = unexpectedObject.getName();
        if (StringUtil.startsWithIgnoreCase((String)idxName, (String)SYS_IDX_PREFIX)) {
            return true;
        }
        return this.hasUniqueIdxWithTheSameName(intellijDatabase, entity, idx) || UnexpectedIndexChangeGenerator.isUniqueConstraintFromEntityAttr(entity, idx) || UnexpectedIndexChangeGenerator.isAutoGeneratedFkIndex(intellijDatabase, jdbcDatabase, entity, idx);
    }

    private static boolean isAutoGeneratedFkIndex(IntellijDatabase intellijDatabase, Database jdbcDatabase, OrmEntity entity, liquibase.structure.core.Index idx) {
        String idxName = idx.getName();
        DbType dbType = LiquibaseUtils.getDatabaseType(jdbcDatabase);
        if (dbType != DbType.H2 && dbType != DbType.HSQL || StringUtil.isEmpty((String)idxName)) {
            return false;
        }
        LiquibaseGenerator liquibaseGenerator = intellijDatabase.getLiquibaseGenerator();
        List<JForeignKey> foreignKeys = liquibaseGenerator.generateForeignKeysConstraints(entity);
        List<Index> uniqueConstraints = liquibaseGenerator.getUniqueConstraints(idx.getRelation().getName(), entity, intellijDatabase.getOrmEntitiesToProcess());
        ArrayList constraintNames = new ArrayList(ContainerUtil.map(foreignKeys, JForeignKey::getName));
        constraintNames.addAll(ContainerUtil.map(uniqueConstraints, Index::getName));
        return ContainerUtil.or(constraintNames, cn -> StringUtil.equalsIgnoreCase((CharSequence)idxName, (CharSequence)cn) || StringUtil.startsWithIgnoreCase((String)idxName, (String)(cn + "_index_")));
    }

    private static boolean isPkIndex(@NotNull Table relation, @NotNull liquibase.structure.core.Index idx) {
        PrimaryKey primaryKey;
        if (relation == null) {
            UnexpectedIndexChangeGenerator.$$$reportNull$$$0(0);
        }
        if (idx == null) {
            UnexpectedIndexChangeGenerator.$$$reportNull$$$0(1);
        }
        return (primaryKey = relation.getPrimaryKey()) != null && primaryKey.getColumns().equals(idx.getColumns());
    }

    private static boolean isUniqueConstraintFromEntityAttr(OrmEntity entity, liquibase.structure.core.Index idx) {
        List columns = idx.getColumns();
        if (columns == null || columns.size() != 1) {
            return false;
        }
        OrmDiffModelProvider ormDiffModelProvider = OrmDiffModelProvider.Companion.getForFramework(entity.getOrmFramework());
        List ormEntityAttributePath = ormDiffModelProvider.findOrmAttributeForColumn(entity, ((Column)columns.getFirst()).getName());
        return !ormEntityAttributePath.isEmpty() && ormDiffModelProvider.isUnique((OrmEntityAttribute)ormEntityAttributePath.getLast());
    }

    public boolean hasUniqueIdxWithTheSameName(IntellijDatabase intellijDatabase, OrmEntity entity, liquibase.structure.core.Index idx) {
        String idxName = idx.getName();
        if (StringUtil.isEmpty((String)idxName)) {
            return false;
        }
        List<Index> uniqueConstraints = OrmDiffModelProvider.Companion.getForFramework(intellijDatabase.getOrmFramework()).getUniqueConstraints(intellijDatabase.getGenerationContext(), idx.getRelation().getName(), entity, intellijDatabase.getOrmEntitiesToProcess());
        return ContainerUtil.or(uniqueConstraints, jIndex -> StringUtil.isEmpty((String)jIndex.getName()) || idxName.equalsIgnoreCase(jIndex.getNameNN(entity)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "relation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "idx";
                break;
            }
        }
        objectArray[1] = "liquibase/ext/intellij/diff/UnexpectedIndexChangeGenerator";
        objectArray[2] = "isPkIndex";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

