/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.stubs.index.CssAmpersandSelectorIndex;
import com.intellij.psi.css.impl.stubs.index.CssClassIndex;
import com.intellij.psi.css.impl.stubs.index.CssIdIndex;
import com.intellij.psi.css.index.CssTemplateSelectorsIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CssIndexUtil {
    private CssIndexUtil() {
    }

    public static void processAllSelectorSuffixes(@NotNull CssSelectorSuffixType type, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull PairProcessor<? super String, ? super CssSelectorSuffix> processor) {
        block7: {
            block6: {
                if (type == null) {
                    CssIndexUtil.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    CssIndexUtil.$$$reportNull$$$0(1);
                }
                if (scope == null) {
                    CssIndexUtil.$$$reportNull$$$0(2);
                }
                if (processor == null) {
                    CssIndexUtil.$$$reportNull$$$0(3);
                }
                if (type != CssSelectorSuffixType.CLASS) break block6;
                for (String name : StubIndex.getInstance().getAllKeys(CssClassIndex.KEY, project)) {
                    CssIndexUtil.processSelectorSuffixes(type, name, project, scope, processor);
                }
                break block7;
            }
            if (type != CssSelectorSuffixType.ID) break block7;
            for (String name : StubIndex.getInstance().getAllKeys(CssIdIndex.KEY, project)) {
                CssIndexUtil.processSelectorSuffixes(type, name, project, scope, processor);
            }
        }
    }

    public static void processSelectorSuffixes(@NotNull CssSelectorSuffixType type, @NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull PairProcessor<? super String, ? super CssSelectorSuffix> processor) {
        if (type == null) {
            CssIndexUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            CssIndexUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(8);
        }
        if (type == CssSelectorSuffixType.CLASS) {
            CssIndexUtil.processClasses(name, project, scope, processor);
        } else if (type == CssSelectorSuffixType.ID) {
            CssIndexUtil.processIds(name, project, scope, processor);
        }
    }

    public static void processAllSelectorNamesInScope(@NotNull CssSelectorSuffixType type, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (type == null) {
            CssIndexUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(12);
        }
        if (type == CssSelectorSuffixType.CLASS) {
            CssIndexUtil.processAllClassNamesInScope(project, scope, processor);
        } else if (type == CssSelectorSuffixType.ID) {
            CssIndexUtil.processAllIdNamesInScope(project, scope, processor);
        }
    }

    public static void processSelectorNamesFromHtmlAttributes(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(15);
        }
        CssIndexUtil.processKeysInScope(CssTemplateSelectorsIndex.KEY, project, scope, processor);
    }

    public static void processAllIdNamesInScope(@NotNull Project project, GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(17);
        }
        CssIndexUtil.processKeysInScope(CssIdIndex.KEY, CssSelectorSuffix.class, project, scope, processor);
    }

    public static void processIds(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull PairProcessor<? super String, ? super CssSelectorSuffix> processor) {
        if (name == null) {
            CssIndexUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(21);
        }
        for (CssSelectorSuffix suffix : StubIndex.getElements(CssIdIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssSelectorSuffix.class)) {
            if (processor.process((Object)name, (Object)suffix)) continue;
            return;
        }
    }

    public static void processAllClassNamesInScope(@NotNull Project project, GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(23);
        }
        CssIndexUtil.processKeysInScope(CssClassIndex.KEY, CssSelectorSuffix.class, project, scope, processor);
    }

    public static void processClasses(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull PairProcessor<? super String, ? super CssSelectorSuffix> processor) {
        if (name == null) {
            CssIndexUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(27);
        }
        for (CssSelectorSuffix suffix : StubIndex.getElements(CssClassIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, CssSelectorSuffix.class)) {
            if (processor.process((Object)name, (Object)suffix)) continue;
            return;
        }
    }

    public static <T extends PsiElement> void processKeysInScope(@NotNull StubIndexKey<String, T> indexKey, @NotNull Class<T> requiredClass, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (indexKey == null) {
            CssIndexUtil.$$$reportNull$$$0(28);
        }
        if (requiredClass == null) {
            CssIndexUtil.$$$reportNull$$$0(29);
        }
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(32);
        }
        for (String s : StubIndex.getInstance().getAllKeys(indexKey, project)) {
            if (StubIndex.getElements(indexKey, (Object)s, (Project)project, (GlobalSearchScope)scope, requiredClass).isEmpty() || processor.process((Object)s)) continue;
            return;
        }
    }

    public static <T> void processKeysInScope(@NotNull ID<String, T> indexId, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super String> processor) {
        if (indexId == null) {
            CssIndexUtil.$$$reportNull$$$0(33);
        }
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(36);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        for (String s : index.getAllKeys(indexId, project)) {
            if (index.getContainingFiles(indexId, (Object)s, scope).isEmpty()) continue;
            processor.process((Object)s);
        }
    }

    public static void writeMediaTypes(@NotNull StubOutputStream dataStream, @NotNull Set<CssMediaType> mediaTypes) throws IOException {
        if (dataStream == null) {
            CssIndexUtil.$$$reportNull$$$0(37);
        }
        if (mediaTypes == null) {
            CssIndexUtil.$$$reportNull$$$0(38);
        }
        dataStream.writeVarInt(mediaTypes.size());
        for (CssMediaType type : mediaTypes) {
            dataStream.writeUTFFast(type.name());
        }
    }

    @NotNull
    public static Set<CssMediaType> readMediaTypes(@NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            CssIndexUtil.$$$reportNull$$$0(39);
        }
        int typesLength = dataStream.readVarInt();
        LinkedHashSet<CssMediaType> types = new LinkedHashSet<CssMediaType>();
        for (int i = 0; i < typesLength; ++i) {
            types.add(CssMediaType.valueOf((String)dataStream.readUTFFast()));
        }
        LinkedHashSet<CssMediaType> linkedHashSet = types;
        if (linkedHashSet == null) {
            CssIndexUtil.$$$reportNull$$$0(40);
        }
        return linkedHashSet;
    }

    public static void processAmpersandSelectors(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super CssSelector> processor) {
        if (project == null) {
            CssIndexUtil.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            CssIndexUtil.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            CssIndexUtil.$$$reportNull$$$0(43);
        }
        StubIndex.getInstance().processElements(CssAmpersandSelectorIndex.KEY, (Object)CssAmpersandSelectorIndex.VALUE, project, scope, CssSelector.class, processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 30: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: 
            case 20: 
            case 26: 
            case 31: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 21: 
            case 23: 
            case 27: 
            case 32: 
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClass";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mediaTypes";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/stubs/index/CssIndexUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/stubs/index/CssIndexUtil";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "readMediaTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllSelectorSuffixes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSelectorSuffixes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAllSelectorNamesInScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSelectorNamesFromHtmlAttributes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processAllIdNamesInScope";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processIds";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAllClassNamesInScope";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processKeysInScope";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "writeMediaTypes";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readMediaTypes";
                break;
            }
            case 40: {
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processAmpersandSelectors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 40 -> new IllegalStateException(string);
        };
    }
}

