/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.InjectionUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.JupyterFileViewProvider;
import org.jetbrains.plugins.notebooks.psi.jupyter.JupyterLangUtilKt;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterTemplateTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005H\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0014\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/psi/JupyterKotlinFileViewProvider;", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/JupyterFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getLanguages", "", "Lcom/intellij/lang/Language;", "getTemplateDataLanguage", "getBaseLanguage", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "intellij.kotlin.jupyter.core"})
public final class JupyterKotlinFileViewProvider
extends JupyterFileViewProvider {
    public JupyterKotlinFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(manager, file, eventSystemEnabled);
        InjectionUtils.setFormatOnlyInjectedCode((FileViewProvider)((FileViewProvider)this), (boolean)true);
    }

    @NotNull
    public Set<Language> getLanguages() {
        Object[] objectArray = new Language[]{this.getBaseLanguage(), JupyterLangUtilKt.getMarkdownLanguage()};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = Language.ANY;
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"ANY");
        return language;
    }

    @NotNull
    public Language getBaseLanguage() {
        return (Language)JupyterLanguage.INSTANCE;
    }

    @NotNull
    protected JupyterKotlinFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new JupyterKotlinFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        if (Intrinsics.areEqual((Object)lang, (Object)Language.ANY)) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (lang == JupyterLanguage.INSTANCE) {
            psiFile = parserDefinition.createFile((FileViewProvider)this);
        } else if (lang == JupyterLangUtilKt.getMarkdownLanguage()) {
            PsiFileImpl psiFileImpl;
            PsiFile psiFile2 = parserDefinition.createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl $this$createFile_u24lambda_u240 = psiFileImpl = (PsiFileImpl)psiFile2;
            boolean bl = false;
            $this$createFile_u24lambda_u240.setContentElementType((IElementType)JupyterTemplateTypes.MARKDOWN_TEMPLATE);
            psiFile = (PsiFile)psiFileImpl;
        } else {
            psiFile = null;
        }
        return psiFile;
    }
}

