/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.repl.creating;

import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.api.KernelRunMode;
import org.jetbrains.kotlinx.jupyter.api.ReplCompilerMode;
import org.jetbrains.kotlinx.jupyter.api.embedded.InMemoryReplResultsHolder;
import org.jetbrains.kotlinx.jupyter.api.libraries.CommManager;
import org.jetbrains.kotlinx.jupyter.api.outputs.DisplayHandler;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtil;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryInfoCache;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryReferenceParser;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ResolutionInfoProvider;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.SocketDisplayHandler;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.repl.MavenRepositoryCoordinates;
import org.jetbrains.kotlinx.jupyter.repl.ReplRuntimeProperties;
import org.jetbrains.kotlinx.jupyter.repl.config.DefaultReplSettings;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplComponentsProviderBase;
import org.jetbrains.kotlinx.jupyter.startup.parameters.KotlinKernelOwnParams;
import org.jetbrains.kotlinx.jupyter.util.StringUtilKt;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0019H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020\u0007H\u0016J\u000f\u0010(\u001a\u0004\u0018\u00010)H\u0016\u00a2\u0006\u0002\u0010*J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\tH\u0016J\b\u0010:\u001a\u00020;H\u0016J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlinx/jupyter/repl/creating/DefaultReplComponentsProvider;", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/ReplComponentsProviderBase;", "_settings", "Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;", "_communicationFacility", "Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;", "_commManager", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;", "_inMemoryResultsHolder", "Lorg/jetbrains/kotlinx/jupyter/api/embedded/InMemoryReplResultsHolder;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;Lorg/jetbrains/kotlinx/jupyter/messaging/JupyterCommunicationFacility;Lorg/jetbrains/kotlinx/jupyter/api/libraries/CommManager;Lorg/jetbrains/kotlinx/jupyter/api/embedded/InMemoryReplResultsHolder;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger$delegate", "Lkotlin/Lazy;", "provideLoggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "provideResolutionInfoProvider", "Lorg/jetbrains/kotlinx/jupyter/libraries/ResolutionInfoProvider;", "provideDisplayHandler", "Lorg/jetbrains/kotlinx/jupyter/api/outputs/DisplayHandler;", "provideScriptClasspath", "", "Ljava/io/File;", "provideHomeDir", "provideMavenRepositories", "Lorg/jetbrains/kotlinx/jupyter/repl/MavenRepositoryCoordinates;", "provideLibraryResolver", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "provideRuntimeProperties", "Lorg/jetbrains/kotlinx/jupyter/repl/ReplRuntimeProperties;", "provideScriptReceivers", "", "provideKernelRunMode", "Lorg/jetbrains/kotlinx/jupyter/api/KernelRunMode;", "provideCommunicationFacility", "provideCommManager", "provideDebugPort", "", "()Ljava/lang/Integer;", "provideExplicitClientType", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "httpUtil", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "getHttpUtil", "()Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryHttpUtil;", "provideHttpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "provideLibraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "provideLibraryInfoCache", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryInfoCache;", "provideLibraryReferenceParser", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryReferenceParser;", "provideInMemoryReplResultsHolder", "provideReplCompilerMode", "Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;", "provideExtraCompilerArguments", "", "shared-compiler"})
public class DefaultReplComponentsProvider
extends ReplComponentsProviderBase {
    @NotNull
    private final DefaultReplSettings _settings;
    @NotNull
    private final JupyterCommunicationFacility _communicationFacility;
    @NotNull
    private final CommManager _commManager;
    @NotNull
    private final InMemoryReplResultsHolder _inMemoryResultsHolder;
    @NotNull
    private final Lazy logger$delegate;

    public DefaultReplComponentsProvider(@NotNull DefaultReplSettings _settings, @NotNull JupyterCommunicationFacility _communicationFacility, @NotNull CommManager _commManager, @NotNull InMemoryReplResultsHolder _inMemoryResultsHolder) {
        Intrinsics.checkNotNullParameter((Object)_settings, (String)"_settings");
        Intrinsics.checkNotNullParameter((Object)_communicationFacility, (String)"_communicationFacility");
        Intrinsics.checkNotNullParameter((Object)_commManager, (String)"_commManager");
        Intrinsics.checkNotNullParameter((Object)_inMemoryResultsHolder, (String)"_inMemoryResultsHolder");
        this._settings = _settings;
        this._communicationFacility = _communicationFacility;
        this._commManager = _commManager;
        this._inMemoryResultsHolder = _inMemoryResultsHolder;
        this.logger$delegate = LazyKt.lazy(() -> DefaultReplComponentsProvider.logger_delegate$lambda$0(this));
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    @Override
    @NotNull
    public KernelLoggerFactory provideLoggerFactory() {
        return this._settings.getLoggerFactory();
    }

    @Override
    @NotNull
    public ResolutionInfoProvider provideResolutionInfoProvider() {
        return this._settings.getReplConfig().getResolutionInfoProvider();
    }

    @Override
    @NotNull
    public DisplayHandler provideDisplayHandler() {
        return new SocketDisplayHandler(this._communicationFacility, this.getNotebook());
    }

    @Override
    @NotNull
    public List<File> provideScriptClasspath() {
        return ((KotlinKernelOwnParams)this._settings.getKernelConfig().getOwnParams()).getScriptClasspath();
    }

    @Override
    @Nullable
    public File provideHomeDir() {
        return ((KotlinKernelOwnParams)this._settings.getKernelConfig().getOwnParams()).getHomeDir();
    }

    @Override
    @NotNull
    public List<MavenRepositoryCoordinates> provideMavenRepositories() {
        return this._settings.getReplConfig().getMavenRepositories();
    }

    @Override
    @Nullable
    public LibraryResolver provideLibraryResolver() {
        return this._settings.getReplConfig().getLibraryResolver();
    }

    @Override
    @NotNull
    public ReplRuntimeProperties provideRuntimeProperties() {
        return this._settings.getRuntimeProperties();
    }

    @Override
    @NotNull
    public List<Object> provideScriptReceivers() {
        return this._settings.getReplConfig().getScriptReceivers();
    }

    @Override
    @NotNull
    public KernelRunMode provideKernelRunMode() {
        return this._settings.getReplConfig().getKernelRunMode();
    }

    @Override
    @NotNull
    public JupyterCommunicationFacility provideCommunicationFacility() {
        return this._communicationFacility;
    }

    @Override
    @NotNull
    public CommManager provideCommManager() {
        return this._commManager;
    }

    @Override
    @Nullable
    public Integer provideDebugPort() {
        return ((KotlinKernelOwnParams)this._settings.getKernelConfig().getOwnParams()).getDebugPort();
    }

    @Override
    @Nullable
    public JupyterClientType provideExplicitClientType() {
        JupyterClientType jupyterClientType;
        String string = ((KotlinKernelOwnParams)this._settings.getKernelConfig().getOwnParams()).getClientType();
        if (string != null) {
            JupyterClientType jupyterClientType2;
            String typeName = string;
            boolean bl = false;
            try {
                jupyterClientType2 = JupyterClientType.valueOf(StringUtilKt.toUpperCaseAsciiOnly(typeName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.getLogger().warn("Unknown client type: " + typeName);
                jupyterClientType2 = null;
            }
            jupyterClientType = jupyterClientType2;
        } else {
            jupyterClientType = null;
        }
        return jupyterClientType;
    }

    private final LibraryHttpUtil getHttpUtil() {
        return this._settings.getReplConfig().getHttpUtil();
    }

    @Override
    @NotNull
    public HttpClient provideHttpClient() {
        return this.getHttpUtil().getHttpClient();
    }

    @Override
    @NotNull
    public LibraryDescriptorsManager provideLibraryDescriptorsManager() {
        return this.getHttpUtil().getLibraryDescriptorsManager();
    }

    @Override
    @NotNull
    public LibraryInfoCache provideLibraryInfoCache() {
        return this.getHttpUtil().getLibraryInfoCache();
    }

    @Override
    @NotNull
    public LibraryReferenceParser provideLibraryReferenceParser() {
        return this.getHttpUtil().getLibraryReferenceParser();
    }

    @Override
    @NotNull
    public InMemoryReplResultsHolder provideInMemoryReplResultsHolder() {
        return this._inMemoryResultsHolder;
    }

    @Override
    @NotNull
    public ReplCompilerMode provideReplCompilerMode() {
        return ((KotlinKernelOwnParams)this._settings.getKernelConfig().getOwnParams()).getReplCompilerMode();
    }

    @Override
    @NotNull
    public List<String> provideExtraCompilerArguments() {
        return ((KotlinKernelOwnParams)this._settings.getKernelConfig().getOwnParams()).getExtraCompilerArguments();
    }

    private static final Logger logger_delegate$lambda$0(DefaultReplComponentsProvider this$0) {
        return KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)this$0.getLoggerFactory(), (KClass)Reflection.getOrCreateKotlinClass(this$0.getClass()));
    }
}

